c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM.h"
c x,y$B$O(BEW, NS$B$KBP1~(B.
      parameter(maxseis=MAXSIEIS_INC,maxorder=MAXORDER_INC)
      parameter(jfilemax=100)  ! appropriately large number
      implicit real*8 (a-h,o-z)                                         
      complex*16 ai
      dimension  x(maxseis),y(maxseis),d(maxseis)
     +     ,dtan(maxseis),drad(maxseis),dx(maxseis),dy(maxseis)
     +     ,ri(maxseis),rate(maxseis),tht(maxseis)
c
      complex s(maxseis),e(maxseis),work(maxseis),element
      complex u(maxseis,maxseis),v(maxseis,maxseis)
      complex a(maxseis,maxseis), ainv(maxseis,maxseis)
      complex ctmp(maxseis,maxseis)
      integer job,info
      character*200 buf,seisfile(maxseis),ofile(0:jfilemax)
      character*80 cline
c
      nopen0=10
      ai=(0.d0,1.d0)
      
      call rseis(5,nseis,x,y,x0,y0,rr,ri,rate,seisfile)
      read(5,*)ncomp
      read(5,*)morder
      call calorder(nseis,morder,mordermax)

c check
      if((ncomp-1)*(mordermax+1)+(morder+1).gt.jfilemax)then
         write(6,*)'ERROR in jfilemax. STOP'
         stop
      endif
      if(nopen0+(ncomp-1)*(mordermax+1)+(morder+1).gt.99)then
         write(6,*)'ERROR in openfie id. STOP'
         stop
      endif

      write(6,*)'read ncomp   : ',ncomp
      do icomp=1,ncomp
         do iorder=0,morder
            jfile=(icomp-1)*(mordermax+1)+(iorder+1)
            read(5,'(a)')ofile(jfile)
            write(6,'(a,a)')'OUTPUT: ',
     +           ofile(jfile)(1:index(ofile(jfile),' ')-1)
            nopen_w=nopen0+jfile

            open(nopen_w,file=ofile(jfile)(1:index(ofile(jfile),' ')-1)
     +           //'.log')
            write(nopen_w,'(a1,2i5,3f15.7)')'#',iorder,
     +           mordermax,rr,x0,y0
            do iseis=1,nseis
c ----------------------------------------------------------------------
c               deg=atan360(x(iseis)-x0,y(iseis)-y0)
c BUG FIXED 2006/3/22 by Cho
               deg=atan360(x(iseis),y(iseis))
c     x(=EW)$B<4$K4X$7$F(B0$BEY$+$i;O$^$C$FH?;~7W<~$j$r@5$H$9$k!#(B
c ----------------------------------------------------------------------
               write(nopen_w,'(a)')
     +              '# '//seisfile(iseis)
     +              (1:index(seisfile(iseis),' ')-1)
               write(nopen_w,'(a1,i5,f8.1,2f12.7,2g15.7)')
     +              '#',iseis,deg,ri(iseis),rate(iseis)
               tht(iseis)=D2R*deg
            enddo
            close(nopen_w)
         enddo
      enddo

c----------------------------------------------------------------------
c kernel
c----------------------------------------------------------------------
c kernel$B:n@.$K$D$$$F$O(Bmorder$B$N;XDj$K$h$i$:(Bnseis$B$K1~$8$?:GBg<!?t$^$G(B
c $B5a$a$k$3$H$H$9$k(B. 
c ($BBn1[<!?t$OK\<AE*$KITL@$J$N$G$=$N$[$&$,8m:9$,>/$J$$$H9M$($k(B.)
      do iseis=1,nseis
         a(iseis,1)= 1.
         do iorder=1,mordermax
            a(iseis,2*iorder  )= 2.*cos(dble(iorder)*tht(iseis))
            a(iseis,2*iorder+1)=-2.*sin(dble(iorder)*tht(iseis))
         enddo
      enddo
      ip=2*mordermax+1

c nseis > mordermax*2+1$B$N>l9g$O<!$N<!?t$N<B?tIt$@$15a$a$k$3$H$H$9$k!#(B
      if(nseis-ip.eq.1)then
         ip=ip+1
         do iseis=1,nseis
            a(iseis,ip)= 2.*cos(dble(ip)*tht(iseis))
         enddo
      endif
c----------------------------------------------------------------------
c $BJ#AG9TNs$r07$&I,MW$O$J$$$,(B, $B>-Mh$N3HD%@-$r9MN8$7$F(Bcsvds()$B$rE,MQ$7$F$*$/(B
c
c         input  ctmp (--> destroyed)
c         output s:diagonals including sigular values
c                e:ordinarily contains zeros
c                u:matrix of N left singular vectors when JOBA=1
c                v:matrix of right singular vectors when JOBB=1
c                info:The singular values (and their corresponding
c                 singular vectors) S(INFO+1),S(INFO+2),...,S(M)
c                 are correct (here M=MIN(N,P)).  Thus if info.eq.0, 
c                 all the singular values and their vectors are correct.
         job=11 
c         call csvdc (ctmp,maxseis,ip,nseis, 
         call csvdc (a,maxseis,ip,nseis, 
     +        s,e,u,maxseis,v,maxseis,work,job,info)  
c----------------------------------------------------------------------
c  $B$H$j$"$($:%@%s%W$O$J$7(B
         dmp=0.
         krank=ip
         do iseis=1,nseis
            do iorder=1,ip
               element=(0.,0.)
               do ll=1,krank
                  element=element+v(iorder,ll)*conjg(u(iseis,ll))/
     +                 (s(ll)+dmp)
               enddo
               ainv(iorder,iseis)=conjg(element)
            enddo
         enddo
         write(6,*)'Inverse Matrix:'
         do iorder=1,ip
            write(6,'(10f10.4)')
     +           (real(ainv(iorder,iseis)),iseis=1,nseis)
         enddo

c----------------------------------------------------------------------
c data processing 
c----------------------------------------------------------------------
      do icomp=1,ncomp
         do iorder=0,morder
            jfile=(icomp-1)*(mordermax+1)+(iorder+1)
            nopen_w=nopen0+jfile
            open(nopen_w,file=ofile(jfile))
         enddo
      enddo

      nopen1=nopen0+(mordermax+1)*ncomp+1
      do iseis=1,nseis
         open(nopen1+iseis,file=seisfile(iseis),status='old',err=999)
#if defined GPL
         do iline=1,28
            read(nopen1+iseis,*,err=998,end=998)
         enddo
#endif
      enddo

 10   continue
      if(ncomp.eq.1)then
         do iseis=1,nseis
#if defined GPL
            call getline(nopen1+iseis,cline)
            read(cline,*,err=99,end=99)time,d(iseis)
#else
            read(nopen1+iseis,*,err=99,end=99)time,d(iseis)
#endif
         enddo
         call pwave(nopen0,1,mordermax,nseis,morder,time,d,ainv)
      else if(ncomp.eq.2)then
         do iseis=1,nseis
#if defined GPL
            call getline(nopen1+iseis,cline)
            read(cline,*,err=99,end=99)
     +           time,dum,dx(iseis),dy(iseis)
#else
            read(nopen1+iseis,*,err=99,end=99)
     +           time,dum,dx(iseis),dy(iseis)
#endif
c radial$B@.J,$OF07BJ}8~$,@5(B, tangenrial$B@.J,$OJ}0L3QJ}8~$,@5(B
            drad(iseis)= dx(iseis)*cos(tht(iseis))
     +                  +dy(iseis)*sin(tht(iseis))
            dtan(iseis)=-dx(iseis)*sin(tht(iseis))
     +                  +dy(iseis)*cos(tht(iseis))
         enddo
         call pwave(nopen0,1,mordermax,nseis,morder,time,drad,ainv)
         call pwave(nopen0,2,mordermax,nseis,morder,time,dtan,ainv)
      else if(ncomp.eq.3)then
         do iseis=1,nseis
#if defined GPL
            call getline(nopen1+iseis,cline)
            read(cline,*,err=99,end=99)
     +           time,d(iseis),dx(iseis),dy(iseis)
#else
            read(nopen1+iseis,*,err=99,end=99)
     +           time,d(iseis),dx(iseis),dy(iseis)
#endif
            drad(iseis)= dx(iseis)*cos(tht(iseis))
     +                  +dy(iseis)*sin(tht(iseis))
            dtan(iseis)=-dx(iseis)*sin(tht(iseis))
     +                  +dy(iseis)*cos(tht(iseis))
         enddo
         call pwave(nopen0,1,mordermax,nseis,morder,time,d,ainv)
         call pwave(nopen0,2,mordermax,nseis,morder,time,drad,ainv)
         call pwave(nopen0,3,mordermax,nseis,morder,time,dtan,ainv)
      else
         write(6,*)'ERROR ncomp:',ncomp
      endif
      goto 10

 99   do iseis=1,nseis
         close(nopen1+iseis)
      enddo
      do icomp=1,ncomp
         do iorder=0,morder
            jfile=(icomp-1)*(mordermax+1)+(iorder+1)
            nopen_w=nopen0+jfile
            close(nopen_w)
         enddo
      enddo
      write(6,*)'Done.'
      stop
 998  continue
      write(6,*)'ERROR: header ',seisfile(iseis)
      stop
 999  continue
      write(6,*)'ERROR: open ',seisfile(iseis)
      end

      subroutine pwave(nopen,ncomp,mordermax,nseis,
     +     morder,time,d,ainv)
      parameter(maxseis=MAXSIEIS_INC)
      implicit real*8 (a-h,o-z)                                         
      dimension  d(maxseis)
      complex ainv(maxseis,maxseis)
      iorder=0
      arl=0.
      aim=0.

      jfile=(ncomp-1)*(mordermax+1)+(iorder+1)
      nopen_w=nopen+jfile
      do iseis=1,nseis
         arl=arl+ainv(1,iseis)*d(iseis)
      enddo
      write(nopen_w,'(3g20.8)')time,arl,aim
      do iorder=1,morder
         arl=0.
         aim=0.
         do iseis=1,nseis
            arl=arl+ainv(2*iorder  ,iseis)*d(iseis)
            aim=aim+ainv(2*iorder+1,iseis)*d(iseis)
         enddo
         jfile=(ncomp-1)*(mordermax+1)+(iorder+1)
         nopen_w=nopen+jfile
         write(nopen_w,'(3g20.8)')time,arl,aim
      enddo
      return
      end

      subroutine rseis(ifile,nseis,x,y,x0,y0,rr,ri,rate,seisfile)
      implicit real*8 (a-h,o-z)                                         
      parameter(maxseis=MAXSIEIS_INC)
      dimension x(maxseis),y(maxseis),ri(maxseis),rate(maxseis)
      dimension xorg(maxseis),yorg(maxseis)
      character*200 seisfile(maxseis)
      eps=RADIUS_ERROR_LEVEL
      read(ifile,*)nseis
      do i=1,nseis
         read(ifile,*)x(i),y(i)
         xorg(i)=x(i)
         yorg(i)=y(i)
         write(6,*)x(i),y(i)
         read(ifile,'(a)')seisfile(i)
         seisfile(i)=seisfile(i)(1:index(seisfile(i),' ')-1)
         write(6,'(2a)')'INPUT: ',
     +        seisfile(i)(1:index(seisfile(i),' ')-1)
      enddo
     
      if(nseis.eq.1)then
         write(6,*)'Notice: nseis=',nseis
         read(ifile,*)rr
         x0=x(1)
         y0=y(1)
         rate(1)=0.
         ri(1)=rr
      else if(nseis.eq.2)then
         iderrinradius=0
         write(6,*)'Notice: nseis=',nseis
         read(ifile,*)rr1
         read(ifile,*)rr2
         x0=999.
         y0=999.
         rr=(rr1+rr2)/2.
         ri(1)=rr1
         ri(2)=rr2
         write(6,*)'    SeisNo CorrectedXY Actual radius   error rate'
         do i=1,nseis
            rate(i)=(ri(i)-rr)/rr
            write(6,*)'radius() ',i,x(i),y(i),ri(i),rate(i)
            if(abs(rate(i)).gt.eps)then
               iderrinradius=1
            endif
         enddo
         if(iderrinradius.eq.1)then
            write(6,*)'ERROR: in radius.'
            write(6,*)'Error(s) exceeds a limit value ',eps
            write(6,*)'(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
            stop
         endif
      else
c     calculation of the central position (x0,y0)
         call crctcntr(nseis,x,y,x0,y0,rr)
         write(6,*)'CENTER: (',x0,y0,')',' RADIUS: ',rr
         iderrinradius=0
         write(6,*)'    SeisNo CorrectedXY Actual radius   error rate'
c         do i=1,nseis
c            write(6,*)'DEBUG:',x(i),y(i),dsqrt(x(i)**2+y(i)**2)
c         enddo
         do i=1,nseis
            ri(i)=dsqrt((xorg(i)-x0)**2+(yorg(i)-y0)**2)
            rate(i)=(ri(i)-rr)/rr
            write(6,*)'radius() ',i,x(i),y(i),ri(i),rate(i)
            if(abs(rate(i)).gt.eps)then
               iderrinradius=1
            endif
         enddo
         if(iderrinradius.eq.1)then
            write(6,*)'ERROR: in radius.'
            write(6,*)'Error(s) exceeds a limit ',eps
            write(6,*)'(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
            stop
         endif
      endif
      return
      end

      subroutine calorder(nseis,morder,mordermax)
      mordermax=0
 10   continue
      if(nseis.lt.2*mordermax+1)then
         mordermax=mordermax-1
      else
         mordermax=mordermax+1
         goto 10
      endif
      write(6,*)'Order :',morder,' (Max order:',mordermax,')'
      if(morder.gt.mordermax)then
         write(6,*)'ERROR: Morder is set to ',morder
         write(6,*)'possible morder is less than: ',mordermax
         write(6,*)'STOP'
         stop
      endif
      return
      end

      subroutine crctcntr(nseis,x,y,x0,y0,rr)
c $B1_7A%"%l%$$K$*$$$F(B2,3,4$BHVL\$NCO?L7WG[CV$+$iCf?4E@!"H>7B$r7W;;$9$k(B
c $B%k!<%A%s(B(Sat May 11 09:31:59 JST 2002)$B!#(B
      implicit real*8 (a-h,o-z)                                         
      dimension x(*),y(*)
      if(nseis.lt.3)then
         write(6,*)'ERROR in crctcntr():nseis ',nseis
         stop
      endif
      if(y(1)-y(2).ne.0.d0)then
         x12=(x(1)+x(2))/2.d0
         y12=(y(1)+y(2))/2.d0
         a12=-(x(1)-x(2))/(y(1)-y(2))
         if(y(1)-y(3).ne.0.d0)then
            x13=(x(1)+x(3))/2.d0
            y13=(y(1)+y(3))/2.d0
            a13=-(x(1)-x(3))/(y(1)-y(3))
         else
            x13=(x(2)+x(3))/2.d0
            y13=(y(2)+y(3))/2.d0
            a13=-(x(2)-x(3))/(y(2)-y(3))
         endif
      else
         x12=(x(2)+x(3))/2.d0
         y12=(y(2)+y(3))/2.d0
         a12=-(x(2)-x(3))/(y(2)-y(3))
c
         x13=(x(1)+x(3))/2.d0
         y13=(y(1)+y(3))/2.d0
         a13=-(x(1)-x(3))/(y(1)-y(3))
      endif
c
      x0=(a12*x12-a13*x13+y13-y12)/(a12-a13)
      y0=a12*(x0-x12)+y12
      rr=dsqrt((x(1)-x0)**2+(y(1)-y0)**2)
c
      do i=1,nseis
         x(i)=x(i)-x0
         y(i)=y(i)-y0
      enddo
      return
      end

      real*8 function  atan360(x,y)
      implicit real*8 (a-h,o-z)                                         
      pi=acos(-1.d0)
      if(y.eq.0.d0.and.x.ge.0.d0)then
         atan360=0.d0
         return
      else if(y.eq.0.d0.and.x.lt.0.d0)then
         atan360=180.d0
         return
      endif
      if(x.eq.0.d0.and.y.gt.0.d0)then
         atan360=90.d0
         return
      else if(x.eq.0.d0.and.y.lt.0.d0)then
         atan360=270.d0
         return
      endif
      atan360=180.d0/pi*atan(y/x)
      if(x.lt.0)then
         atan360=atan360+180.d0
      else if(x.gt.0.and.y.lt.0)then
         atan360=atan360+360.d0
      endif
 10   continue
      if(atan360.ge.0.d0.and.atan360.lt.360.d0)then
         return
      else if(atan360.lt.0.d0)then
         atan360=atan360+360.d0
      else if(atan360.ge.360.d0)then
         atan360=atan360-360.d0
      endif
      goto 10
      end

