c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM_PREPROCESS.h"
c $B=$@0(B
c $BJd4V(B/$BJd30%0%j%C%I$,(B df$B0J>e$K$O$J$l$F$$$k>l9g$O(B999$B$r=PNO$9$k$h$&$K$7$?!#(B
c 999$B$rF~NO$5$l$?>l9g$b(B999$B$r=PNO$9$k$h$&$K$7$?!#(B  (2006/10/12)
      implicit real*8 (a-h,o-z)                                         
      parameter(nmax=NMAX_INC)
      dimension dat(nmax),distmin(nmax)
      character infile*200
c      data alpha/1.0/
      read(5,'(a)')infile
      read(5,*)freqmax
      read(5,*)df
c      dflim=df*alpha
      dflim=df
      ndf=int(freqmax/df+0.5d0)
      call rmkd(df,ndf,dat,distmin,infile)
      do i=1,ndf
         if(distmin(i).le.dflim)then
            write(6,*)df*i,dat(i)
         else
            write(6,*)df*i,999.d0
         endif
      enddo
      stop
      end

      subroutine rmkd(df,nemax,dat,distmin,infile)
      implicit real*8 (a-h,o-z)                                         
      parameter(nmax=NMAX_INC)
      character infile*200
      dimension f(nmax),dat_dum(nmax),dat(nmax),distmin(nmax)
      eps=1.d-6
      open(10,file=infile,status='old')
      i=1
 10   read(10,*,end=99,err=99)f(i),dat_dum(i)
      i=i+1
      goto 10
 99   continue
      ndata=i-1
      close(10)
      if(ndata.gt.nmax)then
         write(6,*)'Program linearint2'
         write(6,*)'ERROR(ndata>nmax) in rmkd: ',ndata,nmax
         stop
      endif
 
c linear interpolatin
      idum=1
      do i=1,nemax
         freq=i*df
 500     continue
         if(freq.lt.f(1))then
            if(dat_dum(2).eq.999.d0.or.dat_dum(1).eq.999.d0)then
               y=999.d0
               distmin(i)=0.d0
            else
               a=(dat_dum(2)-dat_dum(1))/(f(2)-f(1))
               y=a*(freq-f(1))+dat_dum(1)
               distmin(i)=abs(freq-f(1))
            endif
         else if(freq.gt.f(ndata))then
            if(dat_dum(ndata).eq.999.d0.or.
     +           dat_dum(ndata-1).eq.999.d0)then
               y=999.d0
               distmin(i)=0.d0
            else
            a=(dat_dum(ndata)-dat_dum(ndata-1))/(f(ndata)-f(ndata-1))
            y=a*(freq-f(ndata))+dat_dum(ndata)
            distmin(i)=abs(freq-f(ndata))
            endif
         elseif(freq.ge.f(idum)-eps.and.freq.le.f(idum+1)+eps)then
            if(dat_dum(idum+1).eq.999.d0.or.
     +           dat_dum(idum).eq.999.d0)then
               y=999.d0
               distmin(i)=0.d0
            else
            a=(dat_dum(idum+1)-dat_dum(idum))/(f(idum+1)-f(idum))
            y=a*(freq-f(idum))+dat_dum(idum)
            distmin(i)=abs(freq-f(idum))
            if(abs(freq-f(idum+1)).lt.distmin(i))
     +           distmin(i)=abs(freq-f(idum+1))
            endif
         else 
            idum=idum+1
            goto 500
         endif
         dat(i)=y
      enddo
      return
      end
