c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM.h"
      program main
      parameter(maxseis=MAXSIEIS_INC,nmax=NMAX_INC,
     +     maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      common/PARABLOCK/dt,nseis,nblock,kpoint,nb(maxb),ne(maxb),
     +     icomp,nokjb(maxb)
      character*200 seisfile(maxseis)
      common/FLBLOCK/seisfile
      dimension d(nmax),dat(nmax,3)
      
      call rpara()
c      write(6,*)'DEBUG: OK1' 

      do ib=1,nblock
         nokjb(ib)=1
         do iseis=1,nseis

            open(15,file=seisfile(iseis),status='old')
            do i=1,nb(ib)-1
               read(15,*,err=999,end=999)
            enddo
            do i=1,kpoint
               read(15,*,err=999,end=999)
     +              dum,(dat(i,j),j=1,icomp)
            enddo
 999        close(15)

            do j=1,icomp
               do i=1,kpoint
                  d(i)=dat(i,j)
               enddo
               
               call dtrd(d,kpoint,d,1,dum,dum) !Remove Trend
               call moment(kpoint,d, ave,std,var,askew,akrt) 
               
c     Jarque-Bera statistics
c               ajb=dble(kpoint)*(askew*askew/6.d0+akrt*akrt/24.d0)
c     Jarque-Bera statistics improved by Nakagawa (2009)
               ajbd=askew*askew/6.d0+(akrt+3.d0)*(akrt+3.d0)/24.d0
               
c               call jbtest(1,2,kpoint,ajb, idok_jb) ! 99% level
               call jbtest(2,2,kpoint,ajbd,idok_jbd) ! 99% level
               
               if(idok_jbd.eq.0)nokjb(ib)=0
               
c               write(6,1001)
c     +              ave,std,var,askew,akrt,ajb,idok_jb,ajbd,idok_jbd
c 1001          format(6g15.6,i3,g15.6,i3)

            enddo               !             do j=1,icomp
         enddo                  !       do iseis=1,nseis
      enddo                     !          do ib=1,nblock

c output      
      nblock_out=0
      do ib=1,nblock
         if(nokjb(ib).eq.1)nblock_out=nblock_out+1
      enddo

      write(6,'(i14)')nblock_out
      write(6,'(f14.8)')dt*kpoint
      write(6,'(f14.8)')dt
      do ib=1,nblock
         if(nokjb(ib).eq.1)then
            write(6,'(f14.8)')dt*(nb(ib)-1)
         endif
      enddo
      stop
      end

      subroutine rpara()
      parameter(maxseis=MAXSIEIS_INC,nmax=NMAX_INC,
     +     maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      common/PARABLOCK/dt,nseis,nblock,kpoint,nb(maxb),ne(maxb),
     +     icomp,nokjb(maxb)
      character*200 seisfile(maxseis)
      common/FLBLOCK/seisfile
      
      read(5,*)nseis
c      write(6,*)'No. of Seismograms:',nseis
      read(5,*)icomp
      do i=1,nseis
         read(5,'(a)')seisfile(i)
         seisfile(i)=seisfile(i)(1:index(seisfile(i),' ')-1)
c         write(6,'(a,i2,a)')'DATAFILE ',i,') '//seisfile(i)
c     +        (1:index(seisfile(i),' ')-1)
      enddo
      read(5,*)nblock
      read(5,*)duration
      read(5,*)dt
      kpoint=int(duration/dt+0.5)
      do i=1,nblock
         read(5,*)tstart
         nb(i)=int(tstart/dt+0.5)+1
         ne(i)=nb(i)+kpoint-1
c         write(6,2021)i,nb(i),ne(i),kpoint,0,
c     +        dt*(nb(i)-1),dt*ne(i)
 2021    format('Segment ',i3,':',i6,'-',i6,
     +        ' pts (Total ',i7,' pts [but use ',i7,'])',
     +        f8.3,' -',f8.3,' s')
      enddo
c      write(6,*)nblock,duration
c      write(6,*)dt
      return
      end

      subroutine   dtrd (x,n,y,ndeg,slope,avex)
      implicit real*8 (a-h,o-z)                                         
      dimension  x(1) , y(1)                                            
c*****this dtrd removes the mean and/or a linear trend                  
c***** x(i)- original series   , y(i)- calculated seies                 
c***** ndeg- code word  - if -1   no change
c                         if  0   only mean removed                      
c*****                  - if  1   both mean and linear trend removed     
c֥ǡΡפp288
      an = n                                                            
      s1 = 0.0                                                          
      s2 = 0.0                                                          
      slope=12345.
      if ( ndeg ) 9,11,20                                              
 9    return
   11 do 12 i=1,n                                                       
   12 s1 = s1 + x(i)                                                  
      avex = s1 / an                                                    
      do 15  i=1,n                                                      
   15 y(i) = x(i) -avex                               
      return                                                            
   20 do 22 i=1,n                                                       
      s1 = s1 + x(i)                                            
   22 s2 = s2 + s1                                                      
      avei = 0.5*(an+1.0)                                             
      avex = s1 / an                                                    
      slope = -12.0*(s2-avei*s1)/(an*(an**2-1.0))     
      do 28 i=1,n                                                       
      ai = i                                                            
   28 y(i) = x(i)-avex-slope*(ai-avei )            
c      write(6,*)'DEBUG:Subroutine(drtr):',slope,avex
      return                                                            
      end                                                               

      subroutine moment(n,x,ave,std,var,skwew,curt) 
      implicit real*8 (a-h,o-z)                                         
      dimension x(*)
      if(n.lt.2)then
         write(6,*)'ERROR moment(): n < 2: ',n
         write(6,*)'RETURN (nothing done)'
         return
      endif
      
      sum=0.d0
      do i=1,n
         sum=sum+x(i)
      enddo
      ave=sum/dble(n)

      ep=0.d0
      var=0.d0
      skwew=0.d0
      curt=0.d0
      do i=1,n
         s=x(i)-ave
         ep=ep+s
         p=s*s
         var=var+p
         p=p*s
         skwew=skwew+p
         p=p*s
         curt=curt+p
      enddo

c      var=var/dble(n-1)  ! corrected two-pass algorithm not used
      var=(var-ep*ep/dble(n))/dble(n-1)  ! corrected two-pass algorithm

      std=dsqrt(var)
      skwew=skwew/(dble(n)*var*std)
      curt=curt/(dble(n)*var*var)-3.d0
      return
      end

      subroutine jbtest(itype,iconf,n,ajb,idok)
      implicit real*8(a-h,o-z)
c     itype:1  original jb 
c          :21 improved quantity by Nakagawa2009
c     iconf:1  95%
c          :2  99%
c     ajb  :jb value      
c     n    :the number of data points
c     idok :1 maybe normal distribution
c          :2 perhaps not
      if(iconf.ne.1.and.iconf.ne.2)then
         write(6,*)'ERROR jbtest(): iconf not defined:',iconf
         write(6,*)'STOP'
         stop
      endif

      if(     itype.eq.1)then
c     x^2_2 test 0.05  0.01 0.005% C.L.
         if(     iconf.eq.1)then
            valuec=5.991d0
         else if(iconf.eq.2)then
            valuec=9.210d0
         endif
         if(ajb.le.valuec)then
            idok=1
         else
            idok=0
         endif
         
      else if(itype.eq.2)then
         if(     iconf.eq.1)then
            valuec=1.645d0
         else if(iconf.eq.2)then
            valuec=2.326d0
         endif
         if(ajb.le.cjb(n,valuec))then
            idok=1
         else
            idok=0
         endif
      else
         write(6,*)'ERROR jbtest(): itype not defined:',itype
         write(6,*)'STOP'
         stop
      endif

      return
      end

      real*8 function cjb(n,valuec)
      implicit real*8(a-h,o-z)
      an=dble(n)
      r2=dsqrt(2.d0)
      r6=dsqrt(6.d0)
      an05=1.d0/dsqrt(an)
      
      amu_1=(3.d0*an-5.d0)*(an**2+12.d0*an+7.d0)
     +     /(8.d0*(an+5.d0)*(an+3.d0)*(an+1.d0))

      amu_2=an*(an-2.d0)*(3.d0*an**7 +239.d0*an**6
     +     +6819.d0*an**5 +37283.d0*an**4  -8775.d0*an**3
     +     -329451.d0*an**2 -327711.d0*an -99175.d0)
     +     /(2.d0*(an+9.d0)*(an+13.d0)*(an+7.d0)*(an+11.d0)
     +     *((an+5.d0)*(an+3.d0)*(an+1.d0))**2)

      rbeta_1=(8.d0 
     +     +2750.d0/9.d0/an
     +     -33968.d0/9.d0/an/an)*r6*an05

      A = 6.d0 + 8.d0/rbeta_1 *
     +     (2.d0/rbeta_1+dsqrt(1.d0+4.d0/(rbeta_1*rbeta_1)))

      ai=1/A
      ra=dsqrt(A)
      sqrtmu2=dsqrt(amu_2)
      valuec2=valuec*valuec
      valuec3=valuec2*valuec
      
      cjb=(8.d0*sqrtmu2+A*(ai*dsqrt(1.d0/(-4.d0+A))
     +     *amu_1*(-2.d0*(4.d0*r2/ra+9.d0
     +     *(2.d0-9.d0*A)**2*valuec)*ra
     +     + 27.d0*A*(r2*(4.d0+9.d0*A*(-2.d0+3.d0*A))
     +     +2.d0*r2*(-2.d0+9.d0*A)*valuec2
     +     -4.d0*valuec3*ra))
     +     + 9.d0*sqrtmu2*(-12.d0+r2*(2.d0-9.d0*A)**2
     +     /ra*valuec+12.d0*valuec2
     +     + 6.d0*A*(-18.d0+valuec2
     +     *(-9.d0+r2/ra*valuec)))))
     +     /(dsqrt(1.d0/(-4.d0+A))*(-2.d0
     +     *(4.d0*r2/ra+9.d0*(2.d0-9.d0*A)**2*valuec)
     +     *ra + 27.d0*A*(r2*(4.d0+9.d0*A*(-2.d0+3.d0*A))
     +     +2.d0*r2*(-2.d0+9.d0*A)*valuec2
     +     -4.d0*valuec3*ra)))
      return
      end
