c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM.h"
      implicit real*8 (a-h,o-z)                                         
      parameter(maxseis=MAXSIEIS_INC)
      dimension x(maxseis),y(maxseis),ri(maxseis),rate(maxseis)
      dimension xorg(maxseis),yorg(maxseis)
      eps=RADIUS_ERROR_LEVEL
      ifile=5
      iderrinradius=0
      read(ifile,*)idhuddle
      read(ifile,*)nseis
      read(ifile,*)nseis_total

      if(nseis_total.gt.maxseis)then
            write(6,'(a,2i10)')'ERROR: The number of seismographs'//
     +        ' exceeds the maximum (maxseis) ',
     +        nseis_total, maxseis
            write(6,'(a)')
     +           'To continue, you should do either of the following:'
            write(6,'(a)')'i) Decrease the number of seismographs'
            write(6,'(a)')'ii) Edit the parameber MAXSIEIS_INC '//
     +           'in src/PARAM.h and recompile the program'
         stop
      else
         write(6,'(a,i10)')'The number of seismographs (total):',
     +        nseis_total
      endif

      if(idhuddle.eq.1)stop

      if(nseis_total.eq.1)then
         write(6,'(a,f10.5)')' RADIUS: ',0.
         stop
      endif

      if(nseis_total.eq.2)then
         do i=1,nseis_total
            read(ifile,*)x(i),y(i)
         enddo
         rr=sqrt((x(2)-x(1))**2+(y(2)-y(1))**2)
         write(6,'(a,f10.5)')' RADIUS: ',rr
         stop
      endif

      if(nseis_total.eq.3.and.nseis.eq.2)then
         do i=1,nseis
            read(ifile,*)x(i),y(i)
         enddo
         read(ifile,*)x0,y0
         rr1=sqrt((x(1)-x0)**2+(y(1)-y0)**2)
         rr2=sqrt((x(2)-x0)**2+(y(2)-y0)**2)
         write(6,*)'    SeisNo CorrectedXY Actual radius   error rate'
         write(6,*)'radius() ',1,x(1),y(1),rr1,0.
         write(6,*)'radius() ',2,x(2),y(2),rr2,(rr2-rr1)/rr1
         if(abs((rr2-rr1)/rr1).gt.eps)then
            write(6,*)
            write(6,*)'ERROR: in radius.'
            write(6,*)'Error(s) exceeds a limit ',eps
            write(6,*)'(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
         else
            write(6,'(a,f10.5)')' RADIUS: ',rr1
         endif
         stop
      endif

      do i=1,nseis
         read(ifile,*)x(i),y(i)
         xorg(i)=x(i)
         yorg(i)=y(i)
      enddo

      if(nseis_total.eq.3.and.nseis.eq.3)then ! 3$BE@!uA4ItD>@~>e$K$"$k>l9g$N=hM}(B
         ax=x(1)-x(3)
         ay=y(1)-y(3)
         bx=x(2)-x(3)
         by=y(2)-y(3)
         costh=(ax*bx+ay*by)/(sqrt(ax**2+ay**2)*sqrt(bx**2+by**2))
         if(abs(costh-1.).le.eps)then
            write(6,*)
            write(6,*)'ERROR: in radius.'
            write(6,*)'[three seismometers on a single line]'
            write(6,*)'Error(s) exceeds a limit ',eps
            write(6,*)'(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
            stop
         endif
      endif

      if(nseis_total-nseis.eq.1)then
         id_center=1
         read(ifile,*)x_center,y_center
      else
         id_center=0
      endif

c------------------------      
c added on 20180206 start
c------------------------
      if(id_center.eq.1.and.nseis.ge.2)then
         i=1
         hankei0=dsqrt((x(i)-x_center)**2
     *        +(y(i)-y_center)**2)
         do i=2,nseis
            hankei=dsqrt((x(i)-x_center)**2
     *           +(y(i)-y_center)**2)
            write(6,*)'hankei, hankei0 ',hankei, hankei0 
            rate(i)=(hankei-hankei0)/hankei0 
            write(6,*)'radius() ',i,x(i),y(i),hankei,rate(i)
            if(abs(rate(i)).gt.eps)then
               iderrinradius=1
            endif
         enddo
         if(iderrinradius.eq.1)then
            write(6,*)'ERROR: in radius.'
            write(6,*)'Error(s) exceeds a limit value ',eps
            write(6,*)'(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
            stop
         endif
      endif
c------------------------      
c added on 20180206 end
c------------------------


      
      if(nseis.eq.1)then
         write(6,*)'Notice: nseis=',nseis
         read(ifile,*)rr
         x0=x(1)
         y0=y(1)
         rate(1)=0.
         ri(1)=rr
      else if(nseis.eq.2)then
c         iderrinradius=0
         write(6,*)'Notice: nseis=',nseis
         read(ifile,*)rr1
         read(ifile,*)rr2
         x0=999.
         y0=999.
         rr=(rr1+rr2)/2.
         ri(1)=rr1
         ri(2)=rr2
         write(6,*)'    SeisNo CorrectedXY Actual radius   error rate'
         do i=1,nseis
            rate(i)=(ri(i)-rr)/rr
            write(6,*)'radius() ',i,x(i),y(i),ri(i),rate(i)
            if(abs(rate(i)).gt.eps)then
               iderrinradius=1
            endif
         enddo
         if(iderrinradius.eq.1)then
            write(6,*)'ERROR: in radius.'
            write(6,*)'Error(s) exceeds a limit value ',eps
            write(6,*)'(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
            stop
         endif
      else
c     calculation of the central position (x0,y0)
         call crctcntr(nseis,x,y,x0,y0,rr)
         write(6,*)'CENTER POINT CALCULATED: (',
     +        x0,y0,')'
         write(6,'(a,f10.5)')' RADIUS: ',rr
         write(6,*)'    SeisNo CorrectedXY Actual radius   error rate'
c         do i=1,nseis
c            write(6,*)'DEBUG:',x(i),y(i),dsqrt(x(i)**2+y(i)**2)
c         enddo
         do i=1,nseis
            ri(i)=dsqrt((xorg(i)-x0)**2+(yorg(i)-y0)**2)
            rate(i)=(ri(i)-rr)/rr
            write(6,*)'radius() ',i,x(i),y(i),ri(i),rate(i)
            if(abs(rate(i)).gt.eps)then
               iderrinradius=1
            endif
         enddo
         if(iderrinradius.eq.1)then
            write(6,*)'ERROR: in radius.'
            write(6,*)'Error(s) exceeds a limit ',eps
            write(6,*)'(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
         endif

         if(id_center.eq.1)then
            write(6,*)'CENTER POINT FROM seismfile: (',
     +           x_center,y_center,')'
            rate_cx=(x0-x_center)/rr
            rate_cy=(y0-y_center)/rr
            write(6,*)'error rate in location (x,y):',rate_cx,rate_cy
            if(abs(rate_cx).gt.eps)then
               iderrinradius=2
            endif
            if(abs(rate_cy).gt.eps)then
               iderrinradius=2
            endif
            if(iderrinradius.eq.2)then
               write(6,*)'ERROR: in the location of center point.'
               write(6,*)'Error(s) exceeds a limit ',eps
               write(6,*)
     +              '(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
            endif
         endif

      endif
      stop
      end

      subroutine calorder(nseis,morder,mordermax)
      mordermax=0
 10   continue
      if(nseis.lt.2*mordermax+1)then
         mordermax=mordermax-1
      else
         mordermax=mordermax+1
         goto 10
      endif
      write(6,*)'Order :',morder,' (Max order:',mordermax,')'
      if(morder.gt.mordermax)then
         write(6,*)'ERROR: Morder is set to ',morder
         write(6,*)'possible morder is less than: ',mordermax
         write(6,*)'STOP'
         stop
      endif
      return
      end

      subroutine crctcntr(nseis,x,y,x0,y0,rr)
c $B1_7A%"%l%$$K$*$$$F(B2,3,4$BHVL\$NCO?L7WG[CV$+$iCf?4E@!"H>7B$r7W;;$9$k(B
c $B%k!<%A%s(B(Sat May 11 09:31:59 JST 2002)$B!#(B
c $B!J$?$@$7(B3$B$D$NCO?L7W$,D>@~>e$K$J$$>l9g(B)
      implicit real*8 (a-h,o-z)                                         
      dimension x(*),y(*)
      if(nseis.lt.3)then
         write(6,*)'ERROR in crctcntr():nseis ',nseis
         stop
      endif
      if(y(1)-y(2).ne.0.d0)then
         x12=(x(1)+x(2))/2.d0
         y12=(y(1)+y(2))/2.d0
         a12=-(x(1)-x(2))/(y(1)-y(2))
         if(y(1)-y(3).ne.0.d0)then
            x13=(x(1)+x(3))/2.d0
            y13=(y(1)+y(3))/2.d0
            a13=-(x(1)-x(3))/(y(1)-y(3))
         else
            x13=(x(2)+x(3))/2.d0
            y13=(y(2)+y(3))/2.d0
            a13=-(x(2)-x(3))/(y(2)-y(3))
         endif
      else
         x12=(x(2)+x(3))/2.d0
         y12=(y(2)+y(3))/2.d0
         a12=-(x(2)-x(3))/(y(2)-y(3))
c
         x13=(x(1)+x(3))/2.d0
         y13=(y(1)+y(3))/2.d0
         a13=-(x(1)-x(3))/(y(1)-y(3))
      endif
c
      x0=(a12*x12-a13*x13+y13-y12)/(a12-a13)
      y0=a12*(x0-x12)+y12
      rr=dsqrt((x(1)-x0)**2+(y(1)-y0)**2)
c
      do i=1,nseis
         x(i)=x(i)-x0
         y(i)=y(i)-y0
      enddo
      return
      end

      real*8 function  atan360(x,y)
      implicit real*8 (a-h,o-z)                                         
      pi=acos(-1.d0)
      if(y.eq.0.d0.and.x.ge.0.d0)then
         atan360=0.d0
         return
      else if(y.eq.0.d0.and.x.lt.0.d0)then
         atan360=180.d0
         return
      endif
      if(x.eq.0.d0.and.y.gt.0.d0)then
         atan360=90.d0
         return
      else if(x.eq.0.d0.and.y.lt.0.d0)then
         atan360=270.d0
         return
      endif
      atan360=180.d0/pi*atan(y/x)
      if(x.lt.0)then
         atan360=atan360+180.d0
      else if(x.gt.0.and.y.lt.0)then
         atan360=atan360+360.d0
      endif
 10   continue
      if(atan360.ge.0.d0.and.atan360.lt.360.d0)then
         return
      else if(atan360.lt.0.d0)then
         atan360=atan360+360.d0
      else if(atan360.ge.360.d0)then
         atan360=atan360-360.d0
      endif
      goto 10
      end

