c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
      implicit real*8 (a-h,o-z)
      character*200 dfile,sfile,fort30file
      eps=1.d-14
      D2R=acos(-1.d0)/180.
      read(5,*)num,numall
      read(5,*)freqmax
      read(5,'(a)')sfile
      read(5,'(a)')dfile
      read(5,'(a)')fort30file
      open(10,file=sfile)
      open(20,file=dfile)
      open(30,file=fort30file)
 5    continue
      if(num.eq.1)then
         ndum=0
         sumavc=0.d0
         sumavs=0.d0
      else
         read(10,*,err=99,end=99)freq,sumavc,sumavs,ndum
      endif
      read(20,*,err=99,end=99)freq,angle
      if(freq.gt.freqmax)goto 99
      ndum=ndum+1
      sumavc=sumavc+cos(D2R*angle)
      sumavs=sumavs+sin(D2R*angle)
      if(num.eq.numall)then
         if(ndum.eq.0)then
            aveangle=0.
            std=0.
         else if(ndum.eq.1)then
            aveangle=atan360(sumavc,sumavs)
            aver=sqrt(sumavc**2+sumavs**2)
            std=0.
         else
            fnum=dble(ndum)
            aveangle=atan360(sumavc,sumavs)
            aver=sqrt(sumavc**2+sumavs**2)/fnum
            averinv=1.-aver
            if(averinv.gt.0.)then
               std=sqrt(averinv)
            else
               std=0.
            endif
         endif

c         write(30,'(3e20.10)')freq,range180(aveangle),std
         write(30,'(3e20.10)')freq,range180(aveangle)
      else
         write(30,'(3e20.10,i10)')freq,sumavc,sumavs,ndum
      endif
      goto 5
 99   continue
      close(10)
      close(20)
      close(30)
      stop
      end

      real*8 function range180(x)
      implicit real*8 (a-h,o-z)
      range180=x      
 10   continue
      if(range180.lt.-180.d0)then
         range180=range180+360.d0
      else if(range180.gt.180.d0)then
         range180=range180-360.d0
      else
         return
      endif
      goto 10
      end

      real*8 function  atan360(x,y)
      implicit real*8 (a-h,o-z)                                         
      pi=acos(-1.d0)
      if(y.eq.0.d0.and.x.ge.0.d0)then
         atan360=0.d0
         return
      else if(y.eq.0.d0.and.x.lt.0.d0)then
         atan360=180.d0
         return
      endif
      if(x.eq.0.d0.and.y.gt.0.d0)then
         atan360=90.d0
         return
      else if(x.eq.0.d0.and.y.lt.0.d0)then
         atan360=270.d0
         return
      endif
      atan360=180.d0/pi*atan(y/x)
      if(x.lt.0)then
         atan360=atan360+180.d0
      else if(x.gt.0.and.y.lt.0)then
         atan360=atan360+360.d0
      endif
 10   continue
      if(atan360.ge.0.d0.and.atan360.lt.360.d0)then
         return
      else if(atan360.lt.0.d0)then
         atan360=atan360+360.d0
      else if(atan360.ge.360.d0)then
         atan360=atan360-360.d0
      endif
      goto 10
      end
