c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM.h"
      implicit real*8 (a-h,o-z)    
      character*200 dfile,sfile,fort30file
      eps=1.d-8
      nrobust=NROBUST4AVERAGE_INC
      read(5,*)idlogave
      read(5,*)num,numall
      read(5,*)freqmax
      read(5,'(a)')sfile
      read(5,'(a)')dfile
      read(5,'(a)')fort30file
      open(10,file=sfile)
      open(20,file=dfile)
      open(30,file=fort30file)
 5    continue
      if(num.eq.1)then
         ndum=0
         sumav=0.d0
         sumsq=0.d0
         datmax=-1.d10
         datmin=1.d10
      else
         read(10,*,err=99,end=99)
     +        freq,sumav,sumsq,ndum,datmin,datmax
         if(freq.gt.freqmax)goto 99
      endif
c     
      read(20,*,err=99,end=99)freq,dat
      if(idlogave.eq.1)then
         if(dat.le.0)then
            dat=999.d0
         else
            dat=log10(dat)
         endif
      endif
c     
      if(dat.ne.999.d0)then
         if(dat.lt.datmin)datmin=dat
         if(dat.gt.datmax)datmax=dat
      endif

      if(abs(dat-999.d0).lt.eps.or.abs(sumav-999.d0).lt.eps)then
         continue
      else
         ndum=ndum+1
         sumav=sumav+dat
         sumsq=sumsq+dat**2
      endif
c

      if(num.eq.numall)then
         if(ndum.eq.0)then
            sumav=999.d0
            sumsq=999.d0
         else if(ndum.eq.1)then
            sumsq=0.d0
         else if(ndum.ge.nrobust)then
            ndum=ndum-2
            fnum=dble(ndum)
            dat=datmin
            sumav=sumav-dat
            sumsq=sumsq-dat**2
            dat=datmax
            sumav=sumav-dat
            sumsq=sumsq-dat**2
            sumav=sumav/fnum
            sqrt_in=sumsq-fnum*sumav**2
            if(sqrt_in.ge.0.d0)then
               sumsq=dsqrt(sqrt_in/(fnum-1.d0))
            else
               sumsq=999.d0
            endif
         else
            fnum=dble(ndum)
            sumav=sumav/fnum
            sqrt_in=sumsq-fnum*sumav**2
            if(sqrt_in.ge.0.d0)then
               sumsq=dsqrt(sqrt_in/(fnum-1.d0))
            else
               sumsq=999.d0
            endif
         endif
         
         if(sumsq.eq.0.d0.or.sumsq.eq.999.d0)then
            ci95=999.d0
            ci99=999.d0
         else
            call tv(ndum-1,t95,t99)
            ci95=t95*sumsq/dsqrt(dble(ndum))
            ci99=t99*sumsq/dsqrt(dble(ndum))
         endif
      else                      !      if(num.eq.numall)then
         ci95=0.d0
         ci99=0.d0
      endif                     !      if(num.eq.numall)then
      write(30,'(3e20.10,i5,4e15.6)')
     +     freq,sumav,sumsq,ndum,datmin,datmax,ci95,ci99
      goto 5
 99   continue
      close(10)
      close(20)
      close(30)
      stop
      end

      subroutine tv(nf,t95,t99)
      implicit real*8 (a-h,o-z)
      dimension t(2,200)
      t(1,1 )=12.706d0
      t(1,2 )= 4.303d0  
      t(1,3 )= 3.182d0  
      t(1,4 )= 2.776d0  
      t(1,5 )= 2.571d0  
      t(1,6 )= 2.447d0  
      t(1,7 )= 2.365d0  
      t(1,8 )= 2.306d0  
      t(1,9 )= 2.262d0  
      t(1,10)= 2.226d0  
      t(1,11)= 2.201d0  
      t(1,12)= 2.179d0  
      t(1,13)= 2.160d0  
      t(1,14)= 2.145d0  
      t(1,15)= 2.131d0  
      t(1,16)= 2.120d0  
      t(1,17)= 2.110d0  
      t(1,18)= 2.101d0  
      t(1,19)= 2.093d0  
      t(1,20)= 2.086d0  
      t(1,21)= 2.080d0  
      t(1,22)= 2.074d0  
      t(1,23)= 2.069d0  
      t(1,24)= 2.064d0  
      t(1,25)= 2.060d0  
      t(1,26)= 2.056d0  
      t(1,27)= 2.052d0  
      t(1,28)= 2.048d0  
      t(1,29)= 2.045d0  
      t(1,30)= 2.042d0  
      t(1,40)= 2.021d0  
      t(1,60)= 2.000d0  
      t(1,120)= 1.980d0  
      t(1,121)= 1.960d0  
      
      t(2,1)=63.657d0
      t(2,2)=9.925d0 
      t(2,3)=5.841d0
      t(2,4)=4.604d0
      t(2,5)=4.032d0
      t(2,6)=3.707d0
      t(2,7)=3.499d0
      t(2,8)=3.355d0
      t(2,9)=3.250d0
      t(2,10)=3.169d0
      t(2,11)=3.106d0
      t(2,12)=3.055d0
      t(2,13)=3.021d0
      t(2,14)=2.977d0
      t(2,15)=2.947d0
      t(2,16)=2.921d0
      t(2,17)=2.898d0
      t(2,18)=2.878d0
      t(2,19)=2.861d0
      t(2,20)=2.845d0
      t(2,21)=2.831d0
      t(2,22)=2.819d0
      t(2,23)=2.807d0
      t(2,24)=2.797d0
      t(2,25)=2.787d0
      t(2,26)=2.779d0
      t(2,27)=2.771d0
      t(2,28)=2.763d0
      t(2,29)=2.756d0
      t(2,30)=2.750d0
      t(2,40)=2.704d0
      t(2,60)=2.660d0
      t(2,120)=2.617d0
      t(2,121)=2.576d0

c     nf=1000でinfと等価とする。
      if(     nf.le.30)then     ! dof 1-30
         t95=t(1,nf)
         t99=t(2,nf)
      else if(nf.ge.1000)then    ! dof 200>
         t95=t(1,121)
         t99=t(2,121)
      else
         if(nf.le.40)then       ! 30 < dof < 200
            x_1=30.d0
            x_2=40.d0
            y95_1=t(1,30)
            y95_2=t(1,40)
            y99_1=t(2,30)
            y99_2=t(2,40)
         else if(nf.le.60)then
            x_1=40.d0
            x_2=60.d0
            y95_1=t(1,40)
            y95_2=t(1,60)
            y99_1=t(2,40)
            y99_2=t(2,60)
         else if(nf.le.120)then
            x_1=60.d0
            x_2=120.d0
            y95_1=t(1,60)
            y95_2=t(1,120)
            y99_1=t(2,60)
            y99_2=t(2,120)
         else if(nf.le.1000)then
            x_1=120.d0
            x_2=1000.d0
            y95_1=t(1,120)
            y95_2=t(1,121)
            y99_1=t(2,120)
            y99_2=t(2,121)
         endif
         t95=(y95_2-y95_1)/(x_2-x_1)*(dble(nf)-x_1)+y95_1
         t99=(y99_2-y99_1)/(x_2-x_1)*(dble(nf)-x_1)+y99_1
      endif
      return
      end
      
      
      
