#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<SPEC2PV for horizontal components>"
. script/chkfile.sh $R0rfile.log
. script/chkfile.sh $sprh_cca_minus_L
radius=`cat $R0rfile.log | sed -n '1,1'p | awk '{printf "%f",$4}'`
echo "Array radius: $radius [km][from $R0rfile.log]"
dfmin=`   cat $sprh_cca_minus_L | sed -n '1,1'p | awk '{printf "%f\n",$1}'`
freq_max=`cat $sprh_cca_minus_L | tail -1       | awk '{printf "%f\n",$1}'`

#------------------------------ 
# CCA-L
. script/chkfile.sh $sprh_cca_minus_L
echo "OUTPUT (for CCA-L) " $velh_cca_minus_L
cat $sprh_cca_minus_L  | awk 'BEGIN{printf "21 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
printf "%e %e\n",$1,$2}' | $bindir/sctr2pv > $velh_cca_minus_L
#------------------------------ 

#------------------------------ 
# CCA-R
. script/chkfile.sh $sprh_cca_minus_R
echo "OUTPUT (for CCA-R) " $velh_cca_minus_R
cat $sprh_cca_minus_R | awk 'BEGIN{printf "21 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
printf "%e %e\n",$1,$2}' | $bindir/sctr2pv > $velh_cca_minus_R
#------------------------------ 

if [ $id_center -eq 1 ]
then

#------------------------------ 
# SPAC-L
. script/chkfile.sh $sprh_spac_minus_L
echo "OUTPUT (for SPAC-L) " $velh_spac_minus_L
cat $sprh_spac_minus_L | awk 'BEGIN{printf "22 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
printf "%e %e\n",$1,$2}' | $bindir/sctr2pv  > $velh_spac_minus_L
#------------------------------ 

#------------------------------ 
# SPAC+L
. script/chkfile.sh $sprh_spac_plus_L
echo "OUTPUT (for SPAC+L) " $velh_spac_plus_L
cat $sprh_spac_plus_L | awk 'BEGIN{printf "23 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
printf "%e %e\n",$1,$2}' | $bindir/sctr2pv > $velh_spac_plus_L
#------------------------------ 

#------------------------------ 
# SPAC-R
. script/chkfile.sh $sprh_spac_minus_R
echo "OUTPUT (for SPAC-R) " $velh_spac_minus_R
cat $sprh_spac_minus_R | awk 'BEGIN{printf "22 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
printf "%e %e\n",$1,$2}' | $bindir/sctr2pv > $velh_spac_minus_R
#------------------------------ 

#------------------------------ 
# SPAC+R
. script/chkfile.sh $sprh_spac_plus_R
echo "OUTPUT (for SPAC+R) " $velh_spac_plus_R
cat $sprh_spac_plus_R | awk 'BEGIN{printf "23 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
printf "%e %e\n",$1,$2}' | $bindir/sctr2pv > $velh_spac_plus_R
#------------------------------ 

fi
