#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<SPEC2PV>"
. script/chkfile.sh $Z0rfile.log
radius=`cat $Z0rfile.log | sed -n '1,1'p | awk '{printf "%f",$4}'`
echo "Array radius: $radius [km][from $Z0rfile.log]"

if [ -f $spr_spacfile ]
then
file=$spr_spacfile
elif [ -f $spr_ccafile ]
then
file=$spr_ccafile
else
echo ERROR nofile found : $spr_spacfile $spr_ccafile
exit 1
fi
dfmin=`   cat $file | sed -n '1,1'p | awk '{printf "%f\n",$1}'`
freq_max=`cat $file | tail -1       | awk '{printf "%f\n",$1}'`


if [ $nseis -ne 1 -a $nseis -ne 2 ]
then
#------------------------------ 
# CCA
. script/chkfile.sh $spr_ccafile
echo "OUTPUT (for CCA) " $vel_ccafile
cat $spr_ccafile | awk 'BEGIN{printf "5 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{print $0}' | $bindir/sctr2pv > $vel_ccafile
#------------------------------ 
fi

if [ $id_center -eq 1 ]
then

if test "$id_miniature_array" != "1"
then
#------------------------------ 
# Orignal SPAC
. script/chkfile.sh $spr_spacfile
echo "OUTPUT (for SPAC) " $vel_spacfile
cat $spr_spacfile | awk 'BEGIN{printf "1 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{print $0}' | $bindir/sctr2pv > $vel_spacfile
#------------------------------ 

#------------------------------ 
# h0
. script/chkfile.sh $spr_h0file
echo "OUTPUT (for H0) " $vel_h0file
cat $spr_h0file | awk 'BEGIN{printf "2 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{print $0}' | $bindir/sctr2pv > $vel_h0file
#------------------------------ 
fi

if [ $nseis -ne 1 -a $nseis -ne 2 ]
then

if test "$id_miniature_array" != "1"
then
#------------------------------ 
# h1
. script/chkfile.sh $spr_h1file
echo "OUTPUT (for H1) " $vel_h1file
cat $spr_h1file | awk 'BEGIN{printf "3 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{print $0}' | $bindir/sctr2pv > $vel_h1file
#------------------------------ 

#------------------------------ 
# V
. script/chkfile.sh $spr_vfile
echo "OUTPUT (for V) " $vel_vfile
cat $spr_vfile | awk 'BEGIN{printf "4 "'"$radius"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{print $0}' | $bindir/sctr2pv > $vel_vfile
#------------------------------ 
fi

#------------------------------
# nc-CCA 
# Long-Wavelength Approximation (removal of the effects of incoherent noises)
#------------------------------
. script/chkfile.sh $spr_ccafile 
. script/chkfile.sh $nsrfile
echo "OUTPUT (for nc-CCA) " $vellwapx_ccafile
paste $spr_ccafile $nsrfile | awk 'BEGIN{root2=sqrt(2);Pi2=6.2831853
radius=1.*"'"$radius"'"; N=1.*"'"$nseis"'"}{
f=$1; s=$2; epsiron=$4; a=epsiron/N; D1=4*(1-a*(s-1))/(s+2)
if(D1>0.){rk=sqrt(D1); c=radius*Pi2*f/rk; print f,c}}'   > $vellwapx_ccafile
#------------------------------

#------------------------------
# CCA 
# Calculation of Limit of NSR
#------------------------------
tmpfile=$outputdir/tmp.d
echo $nsrlim $nseis | $bindir/bslj0212 > $tmpfile
. script/chkfile.sh $vel_ccafile
echo "OUTPUT (for NSR limit by CCA) " $nsrlim_ccafile
cat $vel_ccafile | awk 'BEGIN{
pi=3.14159265; pi2=pi*2; printf "%s\n","'"$tmpfile"'" }{
print $1,pi2/$3}' | $bindir/minnoise > $nsrlim_ccafile

. script/chkfile.sh $vellwapx_ccafile
echo "OUTPUT (for NSR limit by nc-CCA) " $nsrlim_lwapx_ccafile
cat $vellwapx_ccafile | awk 'BEGIN{radius="'"$radius "'"*1.0
pi=3.14159265; pi2=pi*2; printf "%s\n","'"$tmpfile"'" }{
print $1,pi2*$1*radius/$2}' | $bindir/minnoise > $nsrlim_lwapx_ccafile
rm -f $tmpfile
fi # if nseis

fi
