#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo 
echo "<CALCULATE WEIGHTS for COHERENCE CCA>"

echo seismfile: $seismfile
# circle process

if [ $nseis -eq 1 ] # for a two-station array
then

echo $nseis                  > $infile_mkcrcle_circle
cat $seismfile | grep -v '^#' | awk '{if(/[0-9]/){
if($4!=1){printf "%g\t%g\n%s\n",$1,$2,$3}}}' >> $infile_mkcrcle_circle
radius=`cat $seismfile | grep -v '^#' | awk 'BEGIN{i=1}{
if(/[0-9]/){x[i]=$1;y[i]=$2;i=i+1}
}END{printf "%e\n",sqrt((x[1]-x[2])^2+(y[1]-y[2])^2)}'`
echo $radius                 >> $infile_mkcrcle_circle
echo 1                       >> $infile_mkcrcle_circle
echo 0                       >> $infile_mkcrcle_circle

elif [ $nseis -eq 2 ] # for a three-station array with a center point
then

echo $nseis                  > $infile_mkcrcle_circle
cat $seismfile | grep -v '^#' | awk '{if(/[0-9]/){
if($4!=1){printf "%g\t%g\n%s\n",$1,$2,$3}}}' >> $infile_mkcrcle_circle
radius1=`cat $seismfile | grep -v '^#' | awk 'BEGIN{i=1}{
if(/[0-9]/){if($4==1){x0=$1;y0=$2}else{x[i]=$1;y[i]=$2;i=i+1}
}}END{printf "%e\n",sqrt((x[1]-x0)^2+(y[1]-y0)^2)}'`
radius2=`cat $seismfile | grep -v '^#' | awk 'BEGIN{i=1}{
if(/[0-9]/){if($4==1){x0=$1;y0=$2}else{x[i]=$1;y[i]=$2;i=i+1}
}}END{printf "%e\n",sqrt((x[2]-x0)^2+(y[2]-y0)^2)}'`
echo $radius1                >> $infile_mkcrcle_circle
echo $radius2                >> $infile_mkcrcle_circle
echo 1                       >> $infile_mkcrcle_circle
echo 0                       >> $infile_mkcrcle_circle

else # other types of arrays

echo $nseis                  > $infile_mkcrcle_circle
cat $seismfile | grep -v '^#' | awk '{if(/[0-9]/){
if($4!=1){printf "%g\t%g\n%s\n",$1,$2,$3}}}' >> $infile_mkcrcle_circle
echo 1                       >> $infile_mkcrcle_circle
echo 1                       >> $infile_mkcrcle_circle

fi

cat $infile_mkcrcle_circle | $bindir/mkcrcl_unevenw >& $logfile_mkcrcle_circle
cat $logfile_mkcrcle_circle | grep OUTPUT
cat $logfile_mkcrcle_circle | grep 'ERROR' >& /dev/null
if test "$?" == "0"
then
echo ERROR detected in executing $bindir/mkcrcl_unevenw.
echo abnormal exit $0
echo See logfile: $logfile_mkcrcle_circle 
exit 1
fi

