#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

# Averaging All Power Spectral Densities 

if [ -f $outputdir2/SD1u_SD1u.d ]
then
PSDFILES_U=`ls -d $outputdir2/SD*u_SD*u.d | grep -v AVE`
fi
if [ -f $outputdir2/SD1n_SD1n.d ]
then
PSDFILES_N=`ls -d $outputdir2/SD*n_SD*n.d | grep -v AVE`
fi
if [ -f $outputdir2/SD1e_SD1e.d ]
then
PSDFILES_E=`ls -d $outputdir2/SD*e_SD*e.d | grep -v AVE`
fi
avetmpfile=$outputdir2/SDave.tmp
freq_Nyquist=`cat $logfile_estspec_psd | grep 'Nyquist frequency' | tr ':' ' ' | awk '{printf "%s",$3}'`
freqmax_ave=$freq_Nyquist
#freqmax_ave=`echo $freqmax_ave $freq_Nyquist | awk '{if($1<=$2){print $1}else{print $2}}'`
freq_interporate=`cat $logfile_estspec_psd | grep 'Frequency interval' | tr ':' ' ' | awk '{printf "%s",$3}'`

#----------------
# Average PSD
#----------------
for i in 1 2 3 
do

if   [ $i -eq 1 ]
then
PSDFILES="$PSDFILES_E"
psdavefile=$outputdir2/SDAVEe.d
elif [ $i -eq 2 ]
then
PSDFILES="$PSDFILES_N"
psdavefile=$outputdir2/SDAVEn.d
elif [ $i -eq 3 ]
then
PSDFILES="$PSDFILES_U"
psdavefile=$outputdir2/SDAVEu.d
fi

nfiles=0
for file in $PSDFILES
do
let nfiles=nfiles+1
done
if [ -f $avetmpfile ]
then
rm -f $avetmpfile
fi

if [ $nfiles -gt 1 ]
then
nfile=1
for file in $PSDFILES 
do
$bindir/calave <<EOF
1
$nfile,$nfiles
$freqmax_ave
$avetmpfile
$file
$outputdir2/fort.30
EOF
mv -f $outputdir2/fort.30 $avetmpfile
let nfile=nfile+1
done
echo "OUTPUT (AveragePSD): $psdavefile"
# format of average file
# frequency, average,ave-std,ave+std,number of data values,minimum,maximum,ave-ci95,ave+ci95,ave-ci99,ave+ci99
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e %15.6e %20.10e %20.10e %20.10e %20.10e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6,10^($2-$7),10^($2+$7),10^($2-$8),10^($2+$8)}' > $psdavefile
rm -f $avetmpfile
fi

done
