#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

idcalave_log=0  # <== take logarithminc mean for some quantities when set to 1. 
#idcalave_log=1  # <== take logarithminc mean for some quantities when set to 1. 

#----------------
# Detect Directories
#----------------
DIRS=`ls -d $outputdir/[1-9]*`
ndirs=0
for dir in $DIRS
do
let ndirs=ndirs+1
done

echo 
echo Averaging over $ndirs segment clusters... 
echo "For the sake of robustness, the maximum and minimum values (plus non-numbers (ex. NaN)) are eliminated from the averaging process when the number of segment clusters exceeds NROBUST4AVERAGE_INC (defined in the file PARAM.h). Read the file $avedir/ave.info for details."

echo 
echo Averaging over $ndirs segment clusters... > $avedir/ave.info
echo "For the sake of robustness, the maximum and minimum values (plus non-numbers (ex. NaN)) are eliminated from the averaging process when the number of segment clusters exceeds NROBUST4AVERAGE_INC (defined in the file PARAM.h)." >> $avedir/ave.info
echo "Each average file has a six columns (frequency, average, standard deviation, number of segment clusters for average, the minimum and maximum values. If you want to change NROBUST4AVERAGE_INC, you should edit the file PARAM.h and recompile from the sources, by the simple command Install_xxx.sh. Phase velocities are averaged after eliminating and iterporating data portions with NO ROOT." >> $avedir/ave.info

avetmpfile=$outputdir/ave.tmp

SPRFILES=""
SPRFILES_COHCCA=""
VELFILES=""
VELFILES_COHCCA=""
NSRFILES=""
PSDFILES=""
PSDRATIOFILES=""
CMPLXCOHFILES=""
MSQCOHFILES=""
MSQCOH2NSRFILES=""
PHASEFILES=""
PSDNOISEFILES=""
#PSDSGNLFILES=""

freq_Nyquist=`cat $logfile_estspec_psd | grep 'Nyquist frequency' | tr ':' ' ' | awk '{printf "%s",$3}'`

echo                                               >>$avedir/ave.info
echo "*** Information on each segment cluster ***" >>$avedir/ave.info
echo "Segment duration:  $segment_duration [s]"    >>$avedir/ave.info
echo "dt: $delta_t [s]"                            >>$avedir/ave.info
echo "Nyquist Frequency: $freq_Nyquist [Hz]"       >>$avedir/ave.info
#echo "Parameter freqmax_ave: $freqmax_ave [Hz]"    >>$avedir/ave.info
freqmax_ave=$freq_Nyquist
#freqmax_ave=`echo $freqmax_ave $freq_Nyquist | awk '{if($1<=$2){print $1}else{print $2}}'`

if [ $idhuddle -eq 1 ]
then
printf "\nA huddle test was made in the analysis. Some files in this directory have names with the numbers corresponding to the data file described in the seismfile. The following table is the summary of the correspondence.\nNo.\tData file\n"       >> $avedir/ave.info
n=1
while [ $n -le $nseis_total ] 
do
echo $n ${codechar[$n]}|awk '{printf "%d.\t%s\n",$1,$2}'>>$avedir/ave.info
let n=n+1
done

elif [ $idcohcca -eq 1 ]  # if [ $idhuddle -eq 1 ]
then

printf "\nA SPAC analysis was made. Some files in this directory have names with the numbers corresponding to the data file described in the seismfile. The following table is the summary of the correspondence.\nNo.\tData file\n"       >> $avedir/ave.info
n=1
while [ $n -le $nseis_total ] 
do
echo $n ${codechar[$n]}|awk '{printf "%d.\t%s\n",$1,$2}'>>$avedir/ave.info
let n=n+1
done

fi # if [ $idhuddle -eq 1 ]


if [ $idarray -eq 1 ]
then

#----------------
# Detect File IDs
#----------------
FILES=`ls -d $outputdir/1/vel* | grep -v '.lint$'`
for file in $FILES
do
VELFILES="$VELFILES `basename $file`"
done

if [ -f $outputdir/1/spr_spac.d ]
then
SPRFILES=spr_spac.d
fi

if [ -f $outputdir/1/spr_cca.d ]
then
SPRFILES="$SPRFILES spr_cca.d"
fi

if [ $nseis -ne 1 -a $nseis -ne 2 ]
then
if [ $id_center -eq 1 ]
then
FILES=`ls -d $outputdir/1/nsr* $outputdir/1/pow_noise.d $outputdir/1/pow_signal.d 2> /dev/null | grep -v '.lint$'`
for file in $FILES
do
NSRFILES="$NSRFILES `basename $file`"
done

if [ $idcmax_by_nsr -eq 1 ];then
VELFILES="$VELFILES `basename $nsrlim_vfile0`"
fi
fi # id_center

fi # nseis

#----------------
# Average Velocities
#----------------

# create interpolated files
freq_interporate=`cat $logfile_estspec | grep 'Frequency interval' | tr ':' ' ' | awk '{printf "%s",$3}'`

ndir=1
for dir in $DIRS
do

for file in $VELFILES $SPRFILES
do
file0=$outputdir/$ndir/$file
if [ -f $file0 ] 
then
cat $file0 |grep -vi 'Inf'|grep -vi 'NAN'| grep -v 'NO_ROOT' > $file0.tmp
$bindir/linearint2 <<EOF > $file0.lint
$file0.tmp  
$freqmax_ave
$freq_interporate
EOF
rm -f $file0.tmp
fi
done

for file in $NSRFILES AmpRV_R.d powratio_R2L.d 
do
file0=$outputdir/$ndir/$file
if [ -f $file0 ] 
then
cat $file0 |grep -vi 'Inf'|grep -vi 'NAN'| grep -v 'NO_ROOT' > $file0.tmp
$bindir/linearint2_log <<EOF > $file0.lint
$file0.tmp  
$freqmax_ave
$freq_interporate
EOF
rm -f $file0.tmp
fi
done

let ndir=ndir+1
done

# take averages
for file in $VELFILES $SPRFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave <<EOF
0
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
echo OUTPUT: $avedir/$file
#mv -f $avetmpfile $avedir/$file
cat $avetmpfile |awk '{printf "%s %s %s %s\n",$1,$2,$3,$4}' > $avedir/$file
rm -f $avetmpfile
done # dir

#----------------
# Power partition ratio of R/V coponent of Rayleigh waves
#----------------
if [ $idcomp == 3 ]
then
ndir=1
file=AmpRV_R.d
for dir in $DIRS
do
$bindir/calave <<EOF
$idcalave_log
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
if [ $idcalave_log -eq 1 ]
then
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
else
#mv -f $avetmpfile $avedir/$file
cat $avetmpfile |awk '{printf "%s %s %s %s\n",$1,$2,$3,$4}' > $avedir/$file
rm -f $avetmpfile
fi
fi

#----------------
# Average Power partion ratio of Rayleigh to Love waves
#----------------
if [ $id_center -eq 1 -a $idcomp == 3 ]
then
ndir=1
file=powratio_R2L.d
for dir in $DIRS
do
$bindir/calave <<EOF
$idcalave_log
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
if [ $idcalave_log -eq 1 ]
then
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
else
#mv -f $avetmpfile $avedir/$file
cat $avetmpfile |awk '{printf "%s %s %s %s\n",$1,$2,$3,$4}' > $avedir/$file
rm -f $avetmpfile
fi
fi

#----------------
# Average NSR
#----------------
if [ $id_center -eq 1 ]
then
for file in $NSRFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave <<EOF
$idcalave_log
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,average-1sigma,average+1sigma,number of data values,minimum,maximum
if [ $idcalave_log -eq 1 ]
then
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
else
#mv -f $avetmpfile $avedir/$file
cat $avetmpfile |awk '{printf "%s %s %s %s\n",$1,$2,$3,$4}' > $avedir/$file
rm -f $avetmpfile
fi
done
fi # id_center

fi # idarray


#----------------
# Average Power partion ratio of horizontal to vertical power spectral density
# Average PSD
#----------------
if [ $idhuddle -eq 1 ]
then

FILES=`ls -d $outputdir/1/MSQcoh* | grep -v '.lint$'`
for file in $FILES
do
MSQCOHFILES="$MSQCOHFILES `basename $file`"
done

FILES=`ls -d $outputdir/1/NSR* | grep -v '.lint$'`
for file in $FILES
do
MSQCOH2NSRFILES="$MSQCOH2NSRFILES `basename $file`"
done

FILES=`ls -d $outputdir/1/PSD_NOISE* | grep -v '.lint$'`
for file in $FILES
do
PSDNOISEFILES="$PSDNOISEFILES `basename $file`"
done

FILES=`ls -d $outputdir/1/PHASE* | grep -v '.lint$'`
for file in $FILES
do
PHASEFILES="$PHASEFILES `basename $file`"
done

elif [ $idcohcca -eq 1 ]  # $idhuddle -eq 1 
then

FILES=`ls -d $outputdir/1/PHASE* | grep -v '.lint$'`
for file in $FILES
do
PHASEFILES="$PHASEFILES `basename $file`"
done

#FILES=`ls -d $outputdir/1/CMPLXcoh* | grep -v '.lint$'`
#for file in $FILES
#do
#CMPLXCOHFILES="$CMPLXCOHFILES `basename $file`"
#done

FILES=`ls -d $outputdir/1/vel* | grep -v '.lint$'`
for file in $FILES
do
VELFILES_COHCCA="$VELFILES_COHCCA `basename $file`"
done

FILES=`ls -d $outputdir/1/spr* | grep -v '.lint$'`
for file in $FILES
do
SPRFILES_COHCCA="$SPRFILES_COHCCA `basename $file`"
done

if [ -f $outputdir/1/`basename $nsrlim_vfile0` ]
then
FILES=`ls -d $outputdir/1/cmax_* | grep -v '.lint$'`
for file in $FILES
do
VELFILES_COHCCA="$VELFILES_COHCCA `basename $file`"
done
fi

# nsr*.dˤФĤ경Τ˻ʿ(20121217)
if [ -f $outputdir/1/nsr_h1.lwapx.d.3st -o -f $outputdir/1/nsr_h1.lwapx.d.5st ]
then
FILES=`ls -d $outputdir/1/nsr_* | grep -v '.lint$'`
for file in $FILES
do
VELFILES_COHCCA="$VELFILES_COHCCA `basename $file`"
done

else

if [ $nseis -ne 1 -a $nseis -ne 2 ]
then
if [ $id_center -eq 1 ]
then
FILES=`ls -d $outputdir/1/nsr* 2> /dev/null | grep -v '.lint$'`
for file in $FILES
do
NSRFILES="$NSRFILES `basename $file`"
done
fi
fi

fi

if [ -f $outputdir/1/pow_noise.d ]
then
NSRFILES="$NSRFILES pow_noise.d pow_signal.d"
fi

fi  # $idhuddle -eq 1 

if [ $idpsd -eq 1 ]
then

FILES=`ls -d $outputdir/1/SD*.d`
tmpfile=$outputdir/scrach.tmp
if [ -f $tmpfile ]
then
rm -f $tmpfile
fi
touch -f $tmpfile
for file in $FILES
do
fileid=`basename $file | awk 'BEGIN{FS="_"}{print $1}'`
file0=`dirname $file`/"$fileid"_"$fileid".d
if [ -f $file0 ]
then
basename $file0 >> $tmpfile
fi
done
PSDFILES=`sort $tmpfile | uniq `
rm -f $tmpfile

fi # idpsd

if [ $idhuddle -eq 1 -o $idpsd -eq 1 ]
then

if [ $nseis_total -gt 1 ]
then
FILES=`ls -d $outputdir/1/PSDRATIO* | grep -v '.lint$'`
for file in $FILES
do
PSDRATIOFILES="$PSDRATIOFILES `basename $file`"
done

fi # $idhuddle -o $idpsd 
fi # if [ $nseis_total -gt 1 ]

if [ -f $logfile_estspec_hv ]
then
logfile_estspec0=$logfile_estspec_hv
elif [ -f $logfile_estspec_psd ]
then
logfile_estspec0=$logfile_estspec_psd 
else
echo "Error(mkave.sh): neither $logfile_estspec_hv nor $logfile_estspec_psd not found."
echo STOP.
exit 1
fi
freq_interporate=`cat $logfile_estspec0 | grep 'Frequency interval' | tr ':' ' ' | awk '{printf "%s",$3}'`

ndir=1
for dir in $DIRS
do
for file in spr_hv.d spr_hv_ew.d spr_hv_ns.d $PSDFILES $MSQCOH2NSRFILES $PSDNOISEFILES $PSDRATIOFILES $NSRFILES
do
file0=$outputdir/$ndir/$file
if [ -f $file0 ] 
then
cat $file0 |grep -vi 'Inf'|grep -vi 'NAN'| grep -v 'NO_ROOT' > $file0.tmp
$bindir/linearint2_log <<EOF > $file0.lint
$file0.tmp  
$freqmax_ave
$freq_interporate
EOF
rm -f $file0.tmp
fi   # if [ -f $file0 ] 
done # for file in spr_hv.d spr_hv_ew.d spr_hv_ns.d $PSDFILES ...
let ndir=ndir+1
done # for dir in $DIRS

ndir=1
for dir in $DIRS
do
for file in $MSQCOHFILES $PHASEFILES $CMPLXCOHFILES $VELFILES_COHCCA $SPRFILES_COHCCA
do
file0=$outputdir/$ndir/$file
if [ -f $file0 ] 
then
cat $file0 |grep -vi 'Inf'|grep -vi 'NAN'| grep -v 'NO_ROOT' > $file0.tmp
$bindir/linearint2 <<EOF > $file0.lint
$file0.tmp  
$freqmax_ave
$freq_interporate
EOF
rm -f $file0.tmp
fi
done # for file in $MSQCOHFILES ...
let ndir=ndir+1
done # for dir in $DIRS

if [ $idhv -eq 1 ]
then
for file in spr_hv.d spr_hv_ew.d spr_hv_ns.d 
do
ndir=1
#file=spr_hv.d
for dir in $DIRS
do
$bindir/calave <<EOF
$idcalave_log
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done # for dir in $DIRS
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
if [ $idcalave_log -eq 1 ]
then
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
else # if [ $idcalave_log -eq 1 ]
#mv -f $avetmpfile $avedir/$file
cat $avetmpfile |awk '{printf "%s %s %s %s\n",$1,$2,$3,$4}' > $avedir/$file
rm -f $avetmpfile
fi   # if [ $idcalave_log -eq 1 ]
done # for file in spr_hv.d spr_hv_ew.d spr_hv_ns.d 
fi # idhv

if [ $idpsd -eq 1 -o $idhuddle -eq 1 ]
then

for file in $PSDFILES $MSQCOH2NSRFILES $PSDNOISEFILES $PSDRATIOFILES $NSRFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave <<EOF
$idcalave_log
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
if [ $idcalave_log -eq 1 ]
then
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
else
#mv -f $avetmpfile $avedir/$file
cat $avetmpfile |awk '{printf "%s %s %s %s\n",$1,$2,$3,$4}' > $avedir/$file
rm -f $avetmpfile
fi
done

fi #idpsd -o $idhuddle

#-------------------------------------------
# Create a file indicating ranges of large PSDR
#-------------------------------------------
if test "$id_miniature_array" == "1"
then
if [ $idpsd -eq 1 -o $idhuddle -eq 1 ]
then
if [ -f $avedir/PSDRATIO1_2u.d ]
then
FILES=`ls $avedir/PSDRATIO*u.d`
outfile=$avedir/$PSDRORFILE
if [ -f $outfile ]
then
rm -f $outfile
fi
touch -f $outfile
for file in $FILES
do
cat $file | awk 'BEGIN{lim1=1.*"'"$PSDRLim1"'";lim2=1.*"'"$PSDRLim2"'"
}{if($2<lim1||$2>lim2){print $1}}'  >> $outfile
done
cat $outfile | sort -n | uniq > $outfile.tmp
mv -f $outfile.tmp $outfile
fi # [ -f $avedir/PSDRATIO1_2u.d ]
fi # [ $idpsd -eq 1 -o $idhuddle -eq 1 ]
fi #  test "$id_miniature_array" == "1"


if [ $idhuddle -eq 1 ]
then

for file in $MSQCOHFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave <<EOF
0
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done # dir
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
echo OUTPUT: $avedir/$file
#mv -f $avetmpfile $avedir/$file
cat $avetmpfile |awk '{printf "%s %s %s %s\n",$1,$2,$3,$4}' > $avedir/$file
rm -f $avetmpfile
done 

for file in $PHASEFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave_direc <<EOF
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
echo OUTPUT: $avedir/$file
mv -f $avetmpfile $avedir/$file
done # dir


for file_amp in $PSDRATIOFILES
do
file_phase=`echo $file_amp | sed 's/PSDRATIO/PHASE/'`
file_inst=`echo $file_amp | sed 's/PSDRATIO/DIFINSTRES/'`
echo OUTPUT: $avedir/$file_inst
paste $avedir/$file_amp $avedir/$file_phase | awk '{print $1,sqrt($2),$9}' > $avedir/$file_inst
done

elif [ $idcohcca -eq 1 ] #idhuddle
then

for file in $CMPLXCOHFILES  $VELFILES_COHCCA $SPRFILES_COHCCA
do
ndir=1
for dir in $DIRS
do
$bindir/calave <<EOF
0
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done # dir
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
echo OUTPUT: $avedir/$file
#mv -f $avetmpfile $avedir/$file
cat $avetmpfile |awk '{printf "%s %s %s %s\n",$1,$2,$3,$4}' > $avedir/$file
rm -f $avetmpfile
done 

for file in $PHASEFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave_direc <<EOF
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
$outputdir/fort.30
EOF
mv -f $outputdir/fort.30 $avetmpfile
let ndir=ndir+1
done # for dir in $DIRS
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
echo OUTPUT: $avedir/$file
mv -f $avetmpfile $avedir/$file
done # for file in $PHASEFILES

fi #idhuddle
