c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM_PREPROCESS.h"
      parameter(maxseis=MAXSIEIS_INC,maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      dimension begok(maxb)
      character*200 infile(maxseis),outfile,file
c
c      read(5,*)nblock,duration,dt,beg,ovlprate
      read(5,*)nblock
      read(5,*)duration
      read(5,*)dt
      read(5,*)beg
      read(5,*)ovlprate

      read(5,*)nfile
      read(5,*)rmsr0min,rmsr0max
      do ifile=1,nfile
         read(5,'(a)')infile(ifile)
c         write(6,'(a)')'in: '//infile(ifile)
c     +        (1:index(infile(ifile),' ')-1)
      enddo
      read(5,'(a)')outfile
c      write(6,'(a)')'out: '//outfile(1:index(outfile,' ')-1)

c RMS FILE$B$N:n@.(B
      iok=0
      do ifile=1,nfile
         file=infile(ifile)
         open(10+ifile,file=file,err=91)
      enddo
      do ifile=1,nfile
         read(10+ifile,*)duration2,dt2,beg2,ovlprate2
         call check(duration,duration2,'  duration')
         call check(dt,dt2,            '        dt')
         call check(beg,beg2,          '       beg')
         call check(ovlprate,ovlprate2,'  ovlprate')
      enddo

 1    rmsrmax=0.
      rmsrmin=1.e10
      do ifile=1,nfile
         read(10+ifile,*,err=10,end=10)beg,rmsr
         if(rmsr.gt.rmsrmax)rmsrmax=rmsr
         if(rmsr.lt.rmsrmin)rmsrmin=rmsr
      enddo
c      write(6,*)beg,rmsrmax
      if(rmsrmax.ge.rmsr0min.and.rmsrmax.le.rmsr0max)then
         iok=iok+1
         begok(iok)=beg
         if(iok.eq.nblock)goto 10
      endif
      goto 1
 10   do ifile=1,nfile+1
         close(10+ifile)
      enddo

      if(iok.lt.nblock)nblock=iok
      file=outfile
      open(10+nfile+1,file=file,err=91)
      write(10+nfile+1,*)nblock
      write(10+nfile+1,*)duration
      write(10+nfile+1,*)dt
      do iblock=1,nblock
         write(10+nfile+1,*)begok(iblock)
      enddo
      stop 
 91   write(6,*)'Program segment.'
      write(6,*)'ERROR in program maxrms: opening file ',
     +     file(1:index(file,' ')-1)
      stop 
      end

      subroutine check(x1,x2,msg)
      implicit real*8 (a-h,o-z)                                         
      character*10 msg
      eps=1.e-6
      if(abs(x1-x2).gt.eps)then
         write(6,'(a)')'Program segment.'
         write(6,'(a)')'ERROR in program c0.'
         write(6,'(a)')msg//'[differing parameter].'
         write(6,*)x1,' <==> ',x2, '  STOP.'
         stop
      endif
      return
      end
