c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM.h"
c x and y correspond to EW and NS components, respectively.
      parameter(maxseis=MAXSIEIS_INC,maxorder=MAXORDER_INC)
      implicit real*8 (a-h,o-z)                                         
      dimension  x(maxseis),y(maxseis)
      character*200 seisfile(maxseis),ofile(6)
      character*80 cline

c-------------------------
c      call rseis(5,nseis,x,y,x0,y0,rr,ri,rate,seisfile)
c-------------------------
      i=1
      read(5,*)x(i),y(i)
      write(6,*)x(i),y(i)
      read(5,'(a)')seisfile(i)
      seisfile(i)=seisfile(i)(1:index(seisfile(i),' ')-1)
      write(6,'(2a)')'INPUT: ',
     +     seisfile(i)(1:index(seisfile(i),' ')-1)
c-------------------------

      read(5,*)ncomp
      read(5,*)morder ! dummy
      do icomp=1,ncomp
         read(5,'(a)')ofile(icomp)
      enddo
      write(6,*)'read ncomp   : ',ncomp

      open(10,file=seisfile(1),status='old')
#if defined GPL
      do iline=1,28
         read(10,*,err=99,end=99)
      enddo
#endif

      if(ncomp.eq.1)then  ! Z00.d
         write(6,'(a,a)')'OUTPUT: ',ofile(1)(1:index(ofile(1),' ')-1)
         open(15,file=ofile(1),status='unknown')
#if defined GPL
 11      call getline(10,cline)
         read(cline,*,err=91,end=91)time,d
#else
 11      read(10,*,err=91,end=91)time,d
#endif
         write(15,'(3g20.8)')time,d,0.0
         goto 11
 91      continue
         close(15)
      else if(ncomp.eq.2)then 
         write(6,'(a,a)')'OUTPUT: ',ofile(1)(1:index(ofile(1),' ')-1)
         write(6,'(a,a)')'OUTPUT: ',ofile(2)(1:index(ofile(2),' ')-1)
         open(15,file=ofile(1),status='unknown') ! R10.d
         open(16,file=ofile(2),status='unknown') ! T10.d
#if defined GPL
 12      call getline(10,cline)
         read(cline,*,err=92,end=92)time,d,dx,dy
#else
 12      read(10,*,err=92,end=92)time,d,dx,dy
#endif
         write(15,'(3g20.8)')time,dx/2.,-dy/2.
         write(16,'(3g20.8)')time,dy/2., dx/2.
         goto 12
         close(15)
         close(16)
 92      continue
      else if(ncomp.eq.3)then 
         write(6,'(a,a)')'OUTPUT: ',ofile(1)(1:index(ofile(1),' ')-1)
         write(6,'(a,a)')'OUTPUT: ',ofile(2)(1:index(ofile(2),' ')-1)
         write(6,'(a,a)')'OUTPUT: ',ofile(3)(1:index(ofile(3),' ')-1)
         open(15,file=ofile(1),status='unknown') ! Z00.d
         open(16,file=ofile(2),status='unknown') ! R10.d
         open(17,file=ofile(3),status='unknown') ! T10.d
#if defined GPL
 13      call getline(10,cline)
         read(cline,*,err=93,end=93)time,d,dx,dy
#else
 13      read(10,*,err=93,end=93)time,d,dx,dy
#endif
         write(15,'(3g20.8)')time,d, 0.
         write(16,'(3g20.8)')time,dx/2.,-dy/2.
         write(17,'(3g20.8)')time,dy/2., dx/2.
         goto 12
         close(15)
         close(16)
         close(17)
 93      continue
      endif
      close(10)

      write(6,*)'Done.'
      stop
 99   write(6,*)'ERROR: file:',seisfile(1)         
      end
