c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM_PREPROCESS.h"
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)                                         
      character file1*200,outfile*200,comp*1
      common /DATBLK/dat(nmax)

      read(5,*)duration
      read(5,*)dt
      read(5,*)beg
      read(5,*)ovlprate
      read(5,*)nremove
      read(5,'(a)')comp
      read(5,'(a)')file1
      read(5,'(a)')outfile
      if(comp.eq.'u')idcomp=1
      if(comp.eq.'e')idcomp=2
      if(comp.eq.'n')idcomp=3
      open(17,file=outfile)
      nlen=int(duration/dt+0.5)
      call rfile(npts,nremove,idcomp,dt,file1)
c      write(6,*)'npts=',npts
      call dtrd(dat,npts,dat,1,slope,ave) !Remove Trend
      call rms(dt,rmsvalue0,1,npts)
c      write(6,*)'rms all',rmsvalue0
      write(17,*)duration,dt,beg,ovlprate
      tstep=duration*(1.-ovlprate)
      do iblock=1,1000000
         nbeg=int(beg/dt+0.5)
         nend=nbeg+nlen-1
         if(nend.gt.npts)goto 10
         call rms(dt,rmsvalue,nbeg,nend)
c         write(17,*)beg+duration*0.5,rmsvalue/rmsvalue0,rmsvalue
         write(17,*)beg,rmsvalue/rmsvalue0
         beg=beg+tstep
 10   enddo
      close(17)
      stop
      end

      subroutine rms(dt,rmsvalue,nbeg,nend)
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)                                         
      common /DATBLK/dat(nmax)
      sum=0.
      do i=nbeg,nend
         sum=sum+dat(i)**2
      enddo
      tt=dt*(nend-nbeg)
      rmsvalue=sqrt(sum/tt)
      return
      end

      subroutine wfile(file)
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)                                         
      common /DATBLK/dat(nmax)
      character*200 file
c
      common /SACBLK/fhd,nhd,khd
      real fhd(70),d_sac
      integer nhd(40)
      character khd(48)*4

      open(1,file=file,access='direct',recl=4)
      do i=1,70
      write(1,rec=i)fhd(i)
      enddo
      do i=1,40
      write(1,rec=i+70)nhd(i)
      enddo
      do i=1,48
      write(1,rec=i+110)khd(i)
      enddo
      do i=1,nhd(10)
         d_sac=dat(i)*1.
         write(1,rec=i+158)d_sac
      enddo
      return
 91   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR:opening file ',file(1:index(file,' ')-1)
      stop 
 93   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR: in file ',file(1:index(file,' ')-1)
      write(6,*)'       writing data ',i
      stop
      end

      subroutine rfile(npts,nremove,idcomp,dt,file)
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)                                         
      character*200 file
      character*80 buf
      common /DATBLK/dat
      dimension dat(nmax)
      open(15,file=file,status='old',err=91)
c      do i=1,28
c         read(15,*)
c      enddo
      i=1
c 10   read(15,*,err=89,end=89)buf,dum,dum,dat(i)
      if(idcomp.eq.1)then
 10      read(15,*,err=89,end=89)buf,dat(i)
         i=i+1
         goto 10
 89      continue
      else if(idcomp.eq.2)then
 11      read(15,*,err=90,end=90)buf,dum,dat(i)
         i=i+1
         goto 11
 90      continue
      else if(idcomp.eq.3)then
 12      read(15,*,err=88,end=88)buf,dum,dum,dat(i)
         i=i+1
         goto 12
 88      continue
      endif
      npts=i-1
      close(15)

c remove initial data points
      do i=1+nremove,npts
         i2=i-nremove
         dat(i2)=dat(i) 
c         write(16,*)dt*(i2-1),dat(i2)
      enddo
      npts=npts-nremove

      return
c
 91   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR:opening file ',file(1:index(file,' ')-1)
      stop 
 93   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR: in file ',file(1:index(file,' ')-1)
      write(6,*)'       reading data ',i
      stop
 94   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR: in file ',file(1:index(file,' ')-1)
      write(6,*)'       dt in datafile ',dt_r,' .ne. given dt',dt
 95   write(6,*)'ERROR: in file ',file(1:index(file,' ')-1)
      write(6,*)'       npts in datafile ',npts,' .gt. given nmax',nmax
      stop
      end

      subroutine   dtrd (x,n,y,ndeg,slope,avex)
      implicit real*8 (a-h,o-z)                                         
      dimension x(1) , y(1)                                            
c*****this dtrd removes the mean and/or a linear trend                  
c***** x(i)- original series   , y(i)- calculated seies                 
c***** ndeg- code word  - if -1   no change
c                         if  0   only mean removed                      
c*****                  - if  1   both mean and linear trend removed     
c$B!V%i%s%@%`%G!<%?$N!"!"!W$N(Bp288$B;2>H(B
      an = n                                                            
      s1 = 0.0                                                          
      s2 = 0.0                                                          
      slope=12345.
      if ( ndeg ) 9,11,20                                              
 9    return
   11 do 12 i=1,n                                                       
   12 s1 = s1 + x(i)                                                  
      avex = s1 / an                                                    
      do 15  i=1,n                                                      
   15 y(i) = x(i) -avex                               
      return                                                            
   20 do 22 i=1,n                                                       
      s1 = s1 + x(i)                                            
   22 s2 = s2 + s1                                                      
      avei = 0.5*(an+1.0)                                             
      avex = s1 / an                                                    
      slope = -12.0*(s2-avei*s1)/(an*(an**2-1.0))     
      do 28 i=1,n                                                       
      ai = i                                                            
   28 y(i) = x(i)-avex-slope*(ai-avei )            
c      write(6,*)'DEBUG:Subroutine(drtr):',slope,avex
      return                                                            
      end                                                               

      subroutine rmeqcm(buf)
      character*80 buf
      write(6,'(a)')buf(1:80)
      do i=1,len(buf)
         if(buf(i:i).eq.'='.or.buf(i:i).eq.'"')buf(i:i)=' '
      enddo
      write(6,'(a)')buf(1:80)
      stop

      return
      end
