c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM.h"
      character*200 dfile,sfile
      eps=1.e-8
      nrobust=NROBUST4AVERAGE_INC
      read(5,*)idlogave
      read(5,*)num,numall
      read(5,*)freqmax
      read(5,'(a)')sfile
      read(5,'(a)')dfile
      open(10,file=sfile)
      open(20,file=dfile)
 5    continue
      if(num.eq.1)then
         ndum=0
         sumav=0.
         sumsq=0.
         datmax=-1.e10
         datmin=1.e10
      else
         read(10,*,err=99,end=99)
     +        freq,sumav,sumsq,ndum,datmin,datmax
         if(freq.gt.freqmax)goto 99
      endif
c     
      read(20,*,err=99,end=99)freq,dat
      if(idlogave.eq.1)then
         if(dat.le.0)then
            dat=999.
         else
            dat=log10(dat)
         endif
      endif
c     
      if(dat.ne.999.)then
         if(dat.lt.datmin)datmin=dat
         if(dat.gt.datmax)datmax=dat
      endif

      if(abs(dat-999.).lt.eps.or.abs(sumav-999.).lt.eps)then
         continue
      else
         ndum=ndum+1
         sumav=sumav+dat
         sumsq=sumsq+dat**2
      endif
c
      if(num.eq.numall)then
         if(sqrt_in.lt.0.)sqrt_in=0.
         if(ndum.eq.0)then
            sumav=999.
            sumsq=999.
         else if(ndum.eq.1)then
            sumsq=0.
         else if(ndum.ge.nrobust)then
            ndum=ndum-2
            fnum=float(ndum)
            dat=datmin
            sumav=sumav-dat
            sumsq=sumsq-dat**2
            dat=datmax
            sumav=sumav-dat
            sumsq=sumsq-dat**2
            sumav=sumav/fnum
            sqrt_in=sumsq-fnum*sumav**2
            if(sqrt_in.ge.0)then
               sumsq=sqrt(sqrt_in/(fnum-1.))
            else
               sumsq=999.
            endif
         else
            fnum=float(ndum)
            sumav=sumav/fnum
            sqrt_in=sumsq-fnum*sumav**2
            if(sqrt_in.ge.0)then
               sumsq=sqrt(sqrt_in/(fnum-1.))
            else
               sumsq=999.
            endif
         endif
      endif
      write(30,'(3e20.10,i5,2e15.6)')
     +     freq,sumav,sumsq,ndum,datmin,datmax
      goto 5
 99   continue
      close(10)
      close(20)
      stop
      end
