c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
      external bslnoise
      common /RKBLOCK/rk,rk_obs,eps,nst
      data re,ae/1.e-12,1.e-12/
      rkmin=0.01
      rkmax=2.40
      rkmax=3.0
      drk=0.005
      anoise_min=0.
      anoise_max=10.
      read(5,*)eps,nst
      do ark=rkmin,rkmax,drk
         rk=ark
         b=anoise_min
         c=anoise_max
         r=c
         call fzero(bslnoise, b, c, r, re, ae, iflag)
         write(6,*)rk,b,rk_obs ! rk,noise_level 
      enddo
      stop
      end

      function bslnoise(x)
      common /RKBLOCK/rk,rk_obs,eps,nst
      if(rk.le.1.4347)then
         rk_obs=rk/(1.-eps)   ! rk<=1.43$B$G$O(B rk$B$r2aBgI>2A(B => $BGHD9$O2a>.I>2A(B
      else
         rk_obs=rk/(1.+eps)   ! rk>=1.43$B$G$O(B rk$B$r2a>.I>2A(B => $BGHD9$O2aBgI>2A(B
      endif
c
      call cal_bsl(0.,rk,y0)
      call cal_bsl(1.,rk,y1)
      bslj0212n=(y0**2.+x/float(nst))/(y1**2.+x/float(nst)) 
c
      call cal_bsl(0.,rk_obs,y0_obs)
      call cal_bsl(1.,rk_obs,y1_obs)
      bslj0212 =(y0_obs**2.)/(y1_obs**2.) 
c
c      bslnoise=abs(bslj0212-bslj0212n)
      bslnoise=bslj0212-bslj0212n
      return
      end

      subroutine cal_bsl(fjisu,x,y)
      parameter(ny=1)
      complex cy0,cy1,cy, z
      dimension cy0(ny),cy1(ny),cy(2)
      kode=2
      z=cmplx(x,0.)
      call cbesj(z, fjisu,  kode, ny, cy0, nz, ierr)
      if(nz.ne.0 .or. ierr.ne.0)then
         write(6,*)'Error:nz or ierr in cbesj()',nz,ierr
         stop
      endif
      y=cy0(1)*1.0
      return
      end
