#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<SETPAR>"

# basic parameters
warning_flag=0
messagesh=$outputdir/message.sh
seismlogfile=$outputdir/seism.log
infile_mkcrcle_center=$outputdir/input.mkcrcle_center.z.d
infile_mkcrcle_circle=$outputdir/input.mkcrcle_circle.z.d
infile_mkcrcle_center_h=$outputdir/input.mkcrcle_center.h.d
infile_mkcrcle_circle_h=$outputdir/input.mkcrcle_circle.h.d
logfile_mkcrcle_center=$outputdir/logfile.mkcrcle_center.z.d
logfile_mkcrcle_circle=$outputdir/logfile.mkcrcle_circle.z.d
logfile_mkcrcle_center_h=$outputdir/logfile.mkcrcle_center.h.d
logfile_mkcrcle_circle_h=$outputdir/logfile.mkcrcle_circle.h.d
Z00file=$outputdir/Z00.d
Z0rfile=$outputdir/Z0r.d
Z1rfile=$outputdir/Z1r.d
R10file=$outputdir/R10.d
R0rfile=$outputdir/R0r.d
R1rfile=$outputdir/R1r.d
T10file=$outputdir/T10.d
T0rfile=$outputdir/T0r.d
T1rfile=$outputdir/T1r.d
udfile=$outputdir/wavud.d
ewfile=$outputdir/wavew.d
nsfile=$outputdir/wavns.d
cpwavdir=$outputdir/cpwav
originaldatadir=$datadir/originaldata

RMS_rates="0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8"

outputdir2=$outputdir/$num
infile_estspec=$outputdir2/infile.estspec.d
logfile_estspec=$outputdir2/logfile.estspec.d
infile_estspec_hv=$outputdir2/infile.estspec_hv.d
logfile_estspec_hv=$outputdir2/logfile.estspec_hv.d
infile_estspec_psd=$outputdir2/infile.estspec_psd.d
logfile_estspec_psd=$outputdir2/logfile.estspec_psd.d
logfile_prepro=$originaldatadir/prepro.log

spr_spacfile=$outputdir2/spr_spac.d
spr_h0file=$outputdir2/spr_h0.d
spr_h1file=$outputdir2/spr_h1.d
spr_ccafile=$outputdir2/spr_cca.d
spr_vfile=$outputdir2/spr_v.d
spr_hvfile=$outputdir2/spr_hv.d
sprh_cca_minus_L=$outputdir2/sprh_cca_minus_L.d
sprh_cca_minus_R=$outputdir2/sprh_cca_minus_R.d
sprh_spac_minus_L=$outputdir2/sprh_spac_minus_L.d
sprh_spac_minus_R=$outputdir2/sprh_spac_minus_R.d
sprh_spac_plus_L=$outputdir2/sprh_spac_plus_L.d
sprh_spac_plus_R=$outputdir2/sprh_spac_plus_R.d
vel_spacfile=$outputdir2/vel_spac.d
vel_h0file=$outputdir2/vel_h0.d
vel_h1file=$outputdir2/vel_h1.d
vel_ccafile=$outputdir2/vel_cca.d
vellwapx_ccafile=$outputdir2/vel_cca.lwapx.d
nsrlwapx_ccafile=$outputdir2/nsr_cca.lwapx.d
nsrlim_ccafile=$outputdir2/nsrlim_cca.d
nsrlim_lwapx_ccafile=$outputdir2/nsrlim_cca.lwapx.d
vel_vfile=$outputdir2/vel_v.d
vellwapx_vfile=$outputdir2/vel_v.lwapx.d
nsrlwapx_vfile=$outputdir2/nsr_v.lwapx.d
nsrlim_vfile0=$outputdir2/vmax_by_nsr.d
nsrlim_vfile=$outputdir2/nsrlim_v.d
nsrlim_lwapx_vfile=$outputdir2/nsrlim_v.lwapx.d
cohfile=$outputdir2/coh2.d
nsrfile=$outputdir2/nsr.d
#nsrfile_h_typer=$outputdir2/nsr_h_typer.d
nsrfile_h_typer=$outputdir2/nsr_h.d
nsrfile_h_typeb=$outputdir2/nsr_h_typeb.d
pow_noise_file=$outputdir2/pow_noise.d
pow_signal_file=$outputdir2/pow_signal.d
AmpRV_R=$outputdir2/AmpRV_R.d
powratio_R2L=$outputdir2/powratio_R2L.d
velh_cca_minus_L=$outputdir2/velh_cca_minus_L.d
velh_cca_minus_R=$outputdir2/velh_cca_minus_R.d
velh_spac_minus_L=$outputdir2/velh_spac_minus_L.d
velh_spac_minus_R=$outputdir2/velh_spac_minus_R.d
velh_spac_plus_L=$outputdir2/velh_spac_plus_L.d
velh_spac_plus_R=$outputdir2/velh_spac_plus_R.d

newnyquist=""
avedir=$outputdir/ave

if [ ! -d $outputdir ]
then
mkdir -p $outputdir
fi

if [ ! -d $outputdir2 ]
then
mkdir -p $outputdir2
fi

if [ ! -d $avedir ]
then
mkdir -p $avedir
fi

gnpltfile=plot.gnplt
gnpltfile_wave=plot_wave.gnplt

idcomp=`cat $seismfile | grep '^#COMP' | awk '{print $2}'`
idcomp0=$idcomp
delta_t=`cat $seismfile | grep '^#DT' | awk '{print $2}'`
CODES=`cat $seismfile | grep -v '^#' | awk '{if(/[0-9]/){print $3}}'`

i=1
for code in $CODES
do
codechar[$i]=$code
let i=i+1 
done

# FIX?
dt_wavplot=0.1  # sampling time interval decimated [s] for gnuplot 
freqmax_ave=50  # maximum frequency [Hz] for averaging 
nsrlim=0.05     #relative error of phase velocities to calculate the limit value of nsr
tpend=0.05      #relative length of tapers at both end applied in the preprocessing
idvmax_by_nsr=0 # [1/0] Output upper limit of phase velocity of Rayleigh waves (calculated by using NS ratios) when this id is set to 1
#xmax_for_gnuplot=50  # maximum frequnecy [Hz] for gnuplot  (automatically set if commented out)
#ymax_for_gnuplot=0.5 # maximum phase velocity [km/s] for gnuplot  (automatically set if commented out)
autologscale_x=1      # Automatic logscale in frequency axis

for code in $CODES;do
. script/chkfile.sh $datadir/$code
done
. script/chkfile.sh $seismfile

id_center=`cat $seismfile | grep -v '^#' | awk 'BEGIN{i=0}{
	   if(/[0-9]/){if($4==1){i=i+1}}}END{print i}'`
nseis=`cat $seismfile | grep -v '^#' | awk 'BEGIN{i=0}{
           if(/[0-9]/){if($4!=1){i=i+1}}}END{print i}'`
nseis_total=`cat $seismfile | grep -v '^#' | awk 'BEGIN{i=0}{
           if(/[0-9]/){i=i+1}}END{print i}'`

idhuddle=`cat $seismfile | grep -v '^#' | awk 'BEGIN{distsum=0;i=0}{x=$1;y=$2
if(/[0-9]/){i=i+1
if(i==1){x0=x;y0=y}else{dist=sqrt((x-x0)^2+(y-y0)^2);distsum=distsum+dist}}
}END{if(distsum==0&&i>1){print 1}else{print 0}}'`

# check seismfile
inputfile=$outputdir/input.chk_seism.d
if [ -f $inputfile ]
then
rm -f $inputfile
fi
echo $idhuddle                >   $inputfile
echo $nseis                  >>   $inputfile
echo $nseis_total            >>  $inputfile
cat $seismfile | grep -v '^#' | awk '{if(/[0-9]/){
if($4!=1){printf "%g\t%g\n",$1,$2}}}' >>  $inputfile
cat $seismfile | grep -v '^#' | awk '{if(/[0-9]/){
if($4==1){printf "%g\t%g\n",$1,$2}}}' >>  $inputfile
cat $inputfile | $bindir/chk_seism    > $seismlogfile
rm -f $inputfile
cat $seismlogfile | grep ERROR >& /dev/null
if test "$?" == "0"
then
echo ERROR detected in executing $bindir/chk_seism
echo abnormal exit $0
echo Check logfile in examining the array geometry: $seismlogfile  
exit 1
fi


if [ $idhuddle -eq 1 ]
then

warning_flag=1
echo "Huddle test (more than one sensors assigned at a single location)"

idpsd=1
idhv=0
idarray=0
idspec2pv=0

else 

#idpsd=0
idpsd=1

radius=`cat $seismlogfile | grep 'RADIUS:' | awk '{printf "%s",$2}'`

if [ -f $messagesh ]
then
rm -f $messagesh
fi

echo $idcalc $id_center $nseis $idcomp $radius | $bindir/chk_contents > $messagesh
. $messagesh

fi # idhuddle

if [ -d $originaldatadir ]
then
echo 
warning_flag=1
printf "NOTE: The data were apparently preprocessed before. The original data were moved to the directory $originaldatadir. The data in $datadir are those after preprocessing "
cat $logfile_prepro
if test "$idwavecheck" == ""; then
echo "Either all analysis or plot to follow will be applied on the waveforms after preprocessing. (You can opt to preprocess the original data anew by following dialogues.)"
fi
idwavecheck=2
else
idwavecheck=1
fi

# basic process 

ESTSPECHVSH=estspec_hv.sh
ESTSPECPSDSH=estspec_psd.sh

if   [ $idcomp0 -eq 1 ]
then
COMPS="u"
elif [ $idcomp0 -eq 2 ]
then
COMPS="n e"
elif [ $idcomp0 -eq 3 ]
then
COMPS="u n e"
fi

if   [ $idcomp -eq 1 ]
then
comps="u"
segmentfile=$segmentfile_z
if   [ $nseis -eq 1 -o $nseis -eq 2 ]
then
ESTSPECSH=estspec2st.sh
else
ESTSPECSH=estspec.sh
fi
elif [ $idcomp -eq 2 ]
then
comps="e n"
segmentfile=$segmentfile_h
ESTSPECSH=estspec_h.sh
elif [ $idcomp -eq 3 ]
then
comps="e n u"
segmentfile=$segmentfile_3c
ESTSPECSH=estspec_3c.sh
fi

ncode=0
for comp in $comps;do
for code in $CODES;do
let ncode=ncode+1
done;done
