#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<MKSEGMENT>"

# Check parameters
if test "$segment_duration" == ""
then
echo ERROR segment_duration not defined. STOP
exit 1
fi
if test "$delta_t" == ""
then
echo ERROR delta_t not defined. STOP
exit 1
fi

if [ -f $segmentfile ]
then
    echo File named $segmentfile already exists.
    yn=""
    while [ "$yn" != "y" -a "$yn" != "Y" -a "$yn" != "n" -a "$yn" != "N" ]
      do
      echo "The option \"automatic selection of data portions\" on."
      echo "The file $segmentfile will be overwritten."
      echo "Are you sure to proceed? [y/n]"
      echo "(Type \"n\" to exit. Restart the program run.sh and set the option \"automatic selection of data portions\" off.)"

      read yn
      if test "$yn" != "y" -a "$yn" != "Y" -a "$yn" != "n" -a "$yn" != "N" 
	  then
	  echo "Type [y/n]"
      elif test "$yn" == "N" -o "$yn" == "n"  
	  then
	  echo idmksegment=0 >> $datadir/$paramfile
	  echo Abort.
	  exit 1
      fi

    done
fi

#---------------------------------------------------------------------------------------
# Create a segment file, which takes the parts having the most frequent value of RMS+-1
#---------------------------------------------------------------------------------------

# create RMS files
for code in $CODES;do
for comp in $comps;do
$bindir/evalrms <<EOF
$segment_duration
$delta_t
0
0.5
0
$comp
$datadir/$code
$outputdir/$code.$comp.rms
EOF
done;done

# Repeat to create a segment file for each RMS value
tmpsegfile=$segmentfile.histogram
rm -f $tmpsegfile; touch $tmpsegfile
for RMS_rate in $RMS_rates
do
infile=input.tmp;rm -f $infile
echo 1000                         > $infile
echo $segment_duration            >> $infile
echo $delta_t                     >> $infile
echo 0                            >> $infile
echo 0.5                          >> $infile
echo $ncode                                           >> $infile
echo 0  $RMS_rate                                     >> $infile
for code in $CODES;do
for comp in $comps;do
echo $outputdir/$code.$comp.rms >> $infile
done;done
echo $segmentfile                                     >> $infile
cat $infile | $bindir/segment; rm -f $infile
cat $segmentfile | head -1  | awk '{
printf "%f\t%5.1f\n","'"$RMS_rate"'",$1}'             >> $tmpsegfile
done

# Find the most frequent value of RMS
cat $tmpsegfile| awk 'BEGIN{d0=0.}{printf "%f\t%5.1f\n", $1,$2-d0
d0=$2}' > $tmpsegfile.2
RMS_rate_best=`cat $tmpsegfile.2 | sort -k 2 -n | tail -1 | awk '{print $1}'`
rm -f $tmpsegfile.2 
RMS_rate_min=`echo $RMS_rate_best | awk '{printf "%f",$1-0.1}'`
RMS_rate_max=`echo $RMS_rate_best | awk '{printf "%f",$1+0.1}'`
echo Output $segmentfile
echo "[Segments with RMS values between $RMS_rate_min and $RMS_rate_max are selected]"

# Final process to make segment file
#echo 1000,$segment_duration,$delta_t,0,0.5            > $infile
echo 1000                         > $infile
echo $segment_duration            >> $infile
echo $delta_t                     >> $infile
echo 0                            >> $infile
echo 0.5                          >> $infile
echo $ncode                                           >> $infile
echo $RMS_rate_min  $RMS_rate_max                     >> $infile
for code in $CODES;do
for comp in $comps;do
echo $outputdir/$code.$comp.rms >> $infile
done;done
echo $segmentfile                                     >> $infile
cat $infile | $bindir/segment; rm -f $infile

echo NOTE: `cat $segmentfile | head -n 1` segments have been selected.

# Clean the temoraly RMS files
for code in $CODES;do
for comp in $comps;do
rm -f $outputdir/$code.$comp.rms
done;done
