#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo ""
echo "<mkgnplt_wave.sh>"
echo "NOTE: This script uses a program gnuplot to plot the waveforms. You can manually plot the same figures later, using a gnuplot macro, $gnpltfile_wave, which was created by this script and is found in $outputdir. To do this, type cd $outputdir & gnuplot $gnpltfile_wave" 

echo OUTPUT: $outputdir/$gnpltfile_wave
dir4plotwav=./wavplot
basename=${segmentfile##*/}
segpltfile=$basename.gnpltdat

cd $outputdir 

if [ ! -d $dir4plotwav ]
then
mkdir -p $dir4plotwav
fi

if [ -f $gnpltfile_wave ]
then
rm -f $gnpltfile_wave
fi
touch -f $gnpltfile_wave

if   [ $idcomp -eq 1 ]
then
ICOMPS=1
elif [ $idcomp -eq 2 ]
then
ICOMPS="2 3"
elif [ $idcomp -eq 3 ]
then
ICOMPS="1 2 3"
fi

ilast=0
for filecode in $CODES
do
for icomp in $ICOMPS
do
let ilast=ilast+1
done
done

hight1=`echo 0.6 $ilast | awk '{print $1/$2+0.12}'`
hight2=`echo 0.6 $ilast | awk '{print $1/$2}'`
width=0.9

# (1) make macro
i=1
for icomp in $ICOMPS
do
for filecode in $CODES
do
datafile1=../$filecode
datafile2=$dir4plotwav/$filecode

cat $datafile1 | awk 'BEGIN{
print "'"$icomp"'"
print "'"$delta_t"'"
print "'"$dt_wavplot"'"}{
print $0}' | $bindir/wavplot > $datafile2

begint_wave=`cat $datafile2 | sed -n '1,1p' | awk '{print $1}'`

if [ $i -eq 1 ]
then
# make blockdata
hduration=`cat $basename | grep -v '^#' | awk '{
if($1!=""){print $0}}' | sed -n '2,2p' | awk '{print $1/2}'`
#echo $basename  $segpltfile
cat $basename | grep -v '^#' | sed '1,3d' | awk 'BEGIN{
hduration="'"$hduration"'"*1.0
begint_wave="'"$begint_wave"'"*1.0}{
if($1!=""){print begint_wave+$0+hduration,0,hduration}}'  > $segpltfile
# start writing macro
echo set multiplot      > $gnpltfile_wave
echo set key right top >> $gnpltfile_wave
echo set size $width,$hight1 >> $gnpltfile_wave
#echo set autoscale y   >> $gnpltfile_wave
#echo set "format y \"%e\"" >> $gnpltfile_wave
echo set bmargin 3 >> $gnpltfile_wave
echo set tmargin 0 >> $gnpltfile_wave
echo set border 1  >> $gnpltfile_wave
echo set noytics    >> $gnpltfile_wave
echo "set xlabel \"Time [s]\"" >> $gnpltfile_wave
else
echo $i $hight1 $hight2 | awk '{
printf "set origin 0.0,%f\n",$3*($1-2)+$2}'  >> $gnpltfile_wave
echo set size $width,$hight2  >> $gnpltfile_wave
echo set bmargin 0 >> $gnpltfile_wave
echo set tmargin 0 >> $gnpltfile_wave
echo set format x \"\" >> $gnpltfile_wave
echo set xlabel \"\" >> $gnpltfile_wave
fi
if [ $i -eq $ilast ]
then
segduration=`cat $basename | grep -v '^#' | awk '{if($0!=""){print $0}}' | head -2 | tail -1`
echo set title "\"NORMALIZED WAVEFORMS\n(Resampled at $dt_wavplot [s] for plot only, by variable dt_wavplot in script/setpar.sh)\nPluses indicate selected portions\n($segmentfile)\nDuration of each segment $segduration [s] Total number of segments $nblock\nNumber of segments for averaging $nseg_segave (--> Repeat calculation $nummax times)\" font \"Times-Italic,9\"" >> $gnpltfile_wave
fi

echo set key outside right >> $gnpltfile_wave

if [ $icomp -eq 1 ]
then
idcompchar="[UD]"

elif [ $icomp -eq 2 ]
then
idcompchar="[EW]"
elif [ $icomp -eq 3 ]
then
idcompchar="[NS]"
fi

no_of_segments=`wc -l $segpltfile | awk '{print $1}'`

if test "$no_of_segments" == "0"
then
echo $datafile2 $filecode $segpltfile $idcompchar | awk '{
printf "plot \"%s\" w l lt 1 ti \"%s%s\"\n",$1,$2,$4,$3}' >> $gnpltfile_wave
else
echo $datafile2 $filecode $segpltfile $idcompchar | awk '{
printf "plot \"%s\" w l lt 1 ti \"%s%s\",\"%s\" w xerrorbars lt 2 ti \"\"\n",$1,$2,$4,$3}' >> $gnpltfile_wave
fi

let i=i+1
done
done
echo set nomultiplot >> $gnpltfile_wave
echo pause -1        >> $gnpltfile_wave


$GNUPLOT $gnpltfile_wave
cd -

