#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<MKCIRCLE_H>"
echo seismfile: $seismfile
# circle process
echo $nseis                  > $infile_mkcrcle_circle_h
cat $seismfile | grep -v '^#' | awk '{if(/[0-9]/){
if($4!=1){printf "%g\t%g\n%s/%s\n",$1,$2,"'"$datadir"'",$3}}}' >> $infile_mkcrcle_circle_h
echo 2                       >> $infile_mkcrcle_circle_h
echo 1                       >> $infile_mkcrcle_circle_h
echo $R0rfile                >> $infile_mkcrcle_circle_h
echo $R1rfile                >> $infile_mkcrcle_circle_h
echo $T0rfile                >> $infile_mkcrcle_circle_h
echo $T1rfile                >> $infile_mkcrcle_circle_h
cat $infile_mkcrcle_circle_h | $bindir/mkcrcl_uneven >& $logfile_mkcrcle_circle_h

cat $logfile_mkcrcle_circle_h | grep OUTPUT
cat $logfile_mkcrcle_circle_h | grep 'ERROR' >& /dev/null
if test "$?" == "0"
then
echo ERROR detected in executing $bindir/mkcrcl_uneven.
echo abnormal exit $0
echo See logfile: $logfile_mkcrcle_circle_h 
exit 1
fi

# center process
if [ $id_center -eq 1 ]
then
echo 1                      > $infile_mkcrcle_center_h
cat $seismfile | grep -v '^#' | awk '{if(/[0-9]/){if($4==1){printf "%g\t%g\n%s/%s\n",
$1,$2,"'"$datadir"'",$3}}}' >> $infile_mkcrcle_center_h
echo 2                      >> $infile_mkcrcle_center_h
echo 0                      >> $infile_mkcrcle_center_h
echo $R10file               >> $infile_mkcrcle_center_h
echo $T10file               >> $infile_mkcrcle_center_h
cat $infile_mkcrcle_center_h | $bindir/mkcrcl_center >& $logfile_mkcrcle_center_h

cat $logfile_mkcrcle_center_h | grep OUTPUT
cat $logfile_mkcrcle_center_h | grep 'ERROR' >& /dev/null
if test "$?" == "0"
then
echo ERROR detected in executing $bindir/mkcrcl_uneven.
echo abnormal exit $0
echo See logfile: $logfile_mkcrcle_center_h 
exit 1
fi

fi
