#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

#----------------
# Detect Directories
#----------------
DIRS=`ls -d $outputdir/[1-9]*`
ndirs=0
for dir in $DIRS
do
let ndirs=ndirs+1
done

echo 
echo Averaging over $ndirs segment clusters... 
echo "For the sake of robustness, the maximum and minimum values (plus non-numbers (ex. NaN)) are eliminated from the averaging process when the number of segment clusters exceeds NROBUST4AVERAGE_INC (defined in the file PARAM.h). Read the file $avedir/ave.info for details."

echo 
echo Averaging over $ndirs segment clusters... > $avedir/ave.info
echo "For the sake of robustness, the maximum and minimum values (plus non-numbers (ex. NaN)) are eliminated from the averaging process when the number of segment clusters exceeds NROBUST4AVERAGE_INC (defined in the file PARAM.h)." >> $avedir/ave.info
echo "Each average file has a six columns (frequency, average, standard deviation, number of segment clusters for average, the minimum and maximum values. If you want to change NROBUST4AVERAGE_INC, you should edit the file PARAM.h and recompile from the sources, by the simple command Install_xxx.sh. Phase velocities are averaged after eliminating and iterporating data portions with NO ROOT." >> $avedir/ave.info

avetmpfile=ave.tmp

VELFILES=""
NSRFILES=""
PSDFILES=""
AMPRATIOFILES=""
MSQCOHFILES=""
MSQCOH2NSRFILES=""
PHASEFILES=""
PSDNOISEFILES=""
#PSDSGNLFILES=""

freq_Nyquist=`cat $logfile_estspec_psd | grep 'Nyquist frequency' | tr ':' ' ' | awk '{printf "%s",$3}'`

echo                                               >>$avedir/ave.info
echo "*** Information on each segment cluster ***" >>$avedir/ave.info
echo "Segment duration:  $segment_duration [s]"    >>$avedir/ave.info
echo "dt: $delta_t [s]"                            >>$avedir/ave.info
echo "Nyquist Frequency: $freq_Nyquist [Hz]"       >>$avedir/ave.info
echo "Parameter freqmax_ave: $freqmax_ave [Hz]"    >>$avedir/ave.info

freqmax_ave=`echo $freqmax_ave $freq_Nyquist | awk '{if($1<=$2){print $1}else{print $2}}'`

if [ $idhuddle -eq 1 ]
then
printf "\nA huddle test was made in the analysis. Some files in this directory have names with the numbers corresponding to the data file described in the seismfile. The following table is the summary of the correspondence.\nNo.\tData file\n"       >> $avedir/ave.info
n=1
while [ $n -le $nseis_total ] 
do
echo $n ${codechar[$n]}|awk '{printf "%d.\t%s\n",$1,$2}'>>$avedir/ave.info
let n=n+1
done
fi

if [ $idarray -eq 1 ]
then

#----------------
# Detect File IDs
#----------------
FILES=`ls -d $outputdir/1/vel* | grep -v '.lint$'`
for file in $FILES
do
VELFILES="$VELFILES `basename $file`"
done

if [ $nseis -ne 1 -a $nseis -ne 2 ]
then
if [ $id_center -eq 1 ]
then
FILES=`ls -d $outputdir/1/nsr* | grep -v '.lint$'`
for file in $FILES
do
NSRFILES="$NSRFILES `basename $file`"
done
if [ $idvmax_by_nsr -eq 1 ];then
VELFILES="$VELFILES `basename $nsrlim_vfile0`"
fi
fi # id_center

fi # nseis

#----------------
# Average Velocities
#----------------

# create interpolated files
freq_interporate=`cat $logfile_estspec | grep 'Frequency interval' | tr ':' ' ' | awk '{printf "%s",$3}'`

ndir=1
for dir in $DIRS
do

for file in $VELFILES 
do
file0=$outputdir/$ndir/$file
if [ -f $file0 ] 
then
cat $file0 |grep -v 'NaN'|grep -v 'NAN'|grep -v 'NO ROOT' > $file0.tmp
$bindir/linearint2 <<EOF > $file0.lint
$file0.tmp  
$freqmax_ave
$freq_interporate
EOF
rm -f $file0.tmp
fi
done

for file in $NSRFILES AmpRV_R.d powratio_R2L.d 
do
file0=$outputdir/$ndir/$file
if [ -f $file0 ] 
then
cat $file0 |grep -v 'NaN '|grep -v 'NAN' | grep -v 'NO_ROOT' > $file0.tmp
$bindir/linearint2_log <<EOF > $file0.lint
$file0.tmp  
$freqmax_ave
$freq_interporate
EOF
rm -f $file0.tmp
fi
done

let ndir=ndir+1
done

# take averages
for file in $VELFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave <<EOF
0
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
EOF
mv -f fort.30 $avetmpfile
let ndir=ndir+1
done
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
echo OUTPUT: $avedir/$file
mv -f $avetmpfile $avedir/$file
done # dir

#----------------
# Power partition ratio of R/V coponent of Rayleigh waves
#----------------
if [ $idcomp == 3 ]
then
ndir=1
file=AmpRV_R.d
for dir in $DIRS
do
$bindir/calave <<EOF
1
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
EOF
mv -f fort.30 $avetmpfile
let ndir=ndir+1
done
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
fi

#----------------
# Average Power partion ratio of Rayleigh to Love waves
#----------------
if [ $id_center -eq 1 -a $idcomp == 3 ]
then
ndir=1
file=powratio_R2L.d
for dir in $DIRS
do
$bindir/calave <<EOF
1
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
EOF
mv -f fort.30 $avetmpfile
let ndir=ndir+1
done
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
fi

#----------------
# Average NSR
#----------------
if [ $id_center -eq 1 ]
then
for file in $NSRFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave <<EOF
1
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
EOF
mv -f fort.30 $avetmpfile
let ndir=ndir+1
done
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,average-1sigma,average+1sigma,number of data values,minimum,maximum
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
done
fi # id_center

fi # idarray


#----------------
# Average Power partion ratio of horizontal to vertical power spectral density
# Average PSD
#----------------
if [ $idhuddle -eq 1 ]
then

FILES=`ls -d $outputdir/1/MSQcoh* | grep -v '.lint$'`
for file in $FILES
do
MSQCOHFILES="$MSQCOHFILES `basename $file`"
done

FILES=`ls -d $outputdir/1/NSR* | grep -v '.lint$'`
for file in $FILES
do
MSQCOH2NSRFILES="$MSQCOH2NSRFILES `basename $file`"
done

FILES=`ls -d $outputdir/1/PSD_NOISE* | grep -v '.lint$'`
for file in $FILES
do
PSDNOISEFILES="$PSDNOISEFILES `basename $file`"
done

FILES=`ls -d $outputdir/1/AMPRATIO* | grep -v '.lint$'`
for file in $FILES
do
AMPRATIOFILES="$AMPRATIOFILES `basename $file`"
done

#FILES=`ls -d $outputdir/1/PSD_SIGNAL* | grep -v '.lint$'`
#for file in $FILES
#do
#PSDSGNLFILES="$PSDSGNLFILES `basename $file`"
#done

FILES=`ls -d $outputdir/1/PHASE* | grep -v '.lint$'`
for file in $FILES
do
PHASEFILES="$PHASEFILES `basename $file`"
done

fi

if [ $idpsd -eq 1 ]
then

FILES=`ls -d $outputdir/1/SD*.d`
tmpfile=$outputdir/scrach.tmp
if [ -f $tmpfile ]
then
rm -f $tmpfile
fi
touch -f $tmpfile
for file in $FILES
do
fileid=`basename $file | awk 'BEGIN{FS="_"}{print $1}'`
file0=`dirname $file`/"$fileid"_"$fileid".d
if [ -f $file0 ]
then
basename $file0 >> $tmpfile
fi
done
PSDFILES=`sort $tmpfile | uniq `
rm -f $tmpfile

fi # idpsd

if [ -f $logfile_estspec_hv ]
then
logfile_estspec0=$logfile_estspec_hv
elif [ -f $logfile_estspec_psd ]
then
logfile_estspec0=$logfile_estspec_psd 
else
echo "Error(mkave.sh): neither $logfile_estspec_hv nor $logfile_estspec_psd not found."
echo STOP.
exit 1
fi
freq_interporate=`cat $logfile_estspec0 | grep 'Frequency interval' | tr ':' ' ' | awk '{printf "%s",$3}'`

ndir=1
for dir in $DIRS
do
#for file in spr_hv.d $PSDFILES $MSQCOH2NSRFILES $PSDNOISEFILES $PSDSGNLFILES
for file in spr_hv.d $PSDFILES $MSQCOH2NSRFILES $PSDNOISEFILES $AMPRATIOFILES
do
file0=$outputdir/$ndir/$file
if [ -f $file0 ] 
then
cat $file0 |grep -v 'NaN '|grep -v 'NAN' | grep -v 'NO_ROOT' > $file0.tmp
$bindir/linearint2_log <<EOF > $file0.lint
$file0.tmp  
$freqmax_ave
$freq_interporate
EOF
rm -f $file0.tmp
fi
done
let ndir=ndir+1
done

ndir=1
for dir in $DIRS
do
for file in $MSQCOHFILES $PHASEFILES
do
file0=$outputdir/$ndir/$file
if [ -f $file0 ] 
then
cat $file0 |grep -v 'NaN'|grep -v 'NAN' | grep -v 'NO_ROOT' > $file0.tmp
$bindir/linearint2 <<EOF > $file0.lint
$file0.tmp  
$freqmax_ave
$freq_interporate
EOF
rm -f $file0.tmp
fi
done
let ndir=ndir+1
done

if [ $idhv -eq 1 ]
then

ndir=1
file=spr_hv.d
for dir in $DIRS
do
$bindir/calave <<EOF
1
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
EOF
mv -f fort.30 $avetmpfile
let ndir=ndir+1
done
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
fi # idhv

if [ $idpsd -eq 1 ]
then

#for file in $PSDFILES $MSQCOH2NSRFILES $PSDNOISEFILES $PSDSGNLFILES
for file in $PSDFILES $MSQCOH2NSRFILES $PSDNOISEFILES $AMPRATIOFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave <<EOF
1
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
EOF
mv -f fort.30 $avetmpfile
let ndir=ndir+1
done
echo OUTPUT: $avedir/$file
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
cat $avetmpfile | awk '{printf "%20.10e %20.10e %20.10e %20.10e %5d %15.6e%15.6e\n",$1,10^$2,10^($2-$3),10^($2+$3),$4,10^$5,10^$6}' > $avedir/$file
rm -f $avetmpfile
done

fi #idpsd

if [ $idhuddle -eq 1 ]
then

for file in $MSQCOHFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave <<EOF
0
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
EOF
mv -f fort.30 $avetmpfile
let ndir=ndir+1
done
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
echo OUTPUT: $avedir/$file
mv -f $avetmpfile $avedir/$file
done # dir

for file in $PHASEFILES
do
ndir=1
for dir in $DIRS
do
$bindir/calave_direc <<EOF
$ndir,$ndirs
$freqmax_ave
$avetmpfile
$outputdir/$ndir/$file.lint
EOF
mv -f fort.30 $avetmpfile
let ndir=ndir+1
done
# format of average file
# frequency, average,standard deviation,number of data values,minimum,maximum
echo OUTPUT: $avedir/$file
mv -f $avetmpfile $avedir/$file
done # dir


for file_amp in $AMPRATIOFILES
do
file_phase=`echo $file_amp | sed 's/AMPRATIO/PHASE/'`
file_inst=`echo $file_amp | sed 's/AMPRATIO/DIFINSTRES/'`
echo OUTPUT: $avedir/$file_inst
paste $avedir/$file_amp $avedir/$file_phase | awk '{print $1,$2,$9}' > $avedir/$file_inst
done



fi #idhuddle
