#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

# Shell script to create seismfile
#-----------------
# Default value 
#seismfile=seism.d
nseis=3
radius=0.1
id_cener=1
delta_t=0.01
idcomp=1
#-----------------

ask() {
    echo -n "$1"
    read answer
    if [ -n "$answer" ]
    then
        ret=$answer
    else
        ret=$2
    fi
}

#-----------------
# Input values

yn=""
while [ "$yn" != "y" -a "$yn" != "Y" ]
 do
    if [ -f mkseism.tmp ]
    then
	rm -f mkseism.tmp
    fi

    if test "$yn" == "N" -o "$yn" == "n"
    then
	echo Abort.
	exit 1
    fi

    touch  mkseism.tmp

    echo
    ask "Input the radius of the circular array (km) [$radius] >" $radius
    radius=$ret
    
    echo
    ask "Input the number of sensors that are placed around the circle [$nseis] >" $nseis
    nseis=$ret
    
    echo
    ask "Does the array have a sensor at the center? (y/n=1/0)[$id_cener] >" $id_cener
    id_cener=$ret

    echo
    echo "Input the data components you want to analyze." 
    ask " (1 ud only/ 2 horizontal (ns & ew) only/ 3 three components) [$idcomp] >" $idcomp 
    idcomp=$ret

    echo
    ask "Sampling time interval of the waveform data (s) [$delta_t] >" $delta_t
    delta_t=$ret
    
    echo -e "#COMP $idcomp [1 ud only/ 2 horizontal (ns & ew) only/ 3 three components]" >> mkseism.tmp
    echo -e "#DT   $delta_t [Sampling time interval of the waveform data (s)]" >> mkseism.tmp

    i=1
    az=0
    while [ $i -le $nseis ]
    do
        echo
	echo "Input the azimuth of the fist sensor around the circle (degrees)" 
	ask " [counterclockwise from the east (ExxN)] [$az]" $az
	az=$ret
	x=`echo $radius $az | awk '{pi=3.14159265;d2r=pi/180;azr=$2*d2r;print $1*cos(azr)}'`
	y=`echo $radius $az | awk '{pi=3.14159265;d2r=pi/180;azr=$2*d2r;print $1*sin(azr)}'`
	codename=`echo $i | awk '{printf "S%02d.d",$1}'`
	ask "Input the file name (pathname \"$datadir\" is not required) [$codename]" $codename
	codename=$ret
	echo -e "$x\t$y\t$codename\t0" >> mkseism.tmp
	let i=i+1
	az=`echo $az $nseis | awk '{print $1+360/$2}'`
    done
    
    if [ $id_cener -eq 1 ]
    then
	codename=`echo $i | awk '{printf "S%02d.d",$1}'`
        echo
	ask "Input the file name for the central sensor (directory path is not required) [$codename]" $codename
	codename=$ret
	echo -e "0\t0\t$codename\t1" >> mkseism.tmp
    fi

    echo ""
    echo "The contents of the temporarily created seismfile are ..."
    echo "---------------- from here -------------------"
    cat mkseism.tmp
    echo "----------------  to here -------------------"
    echo ""
    echo "Write these values into file :"$seismfile
    echo "OK? (y/n/a) [a] (Type \"n\" to exit the program and \"a\" to input the paremters again.)"
    read yn
done

if [ -f $seismfile ]
then
echo File named $seismfile already exists.
    yn=""
    while [ "$yn" != "y" -a "$yn" != "Y" -a "$yn" != "n" -a "$yn" != "N" ]
    do
      echo "Are you sure to overwrite it? [y/n] (Type \"n\" to exit the program.)"
      read yn
    done
    if test "$yn" == "N" -o "$yn" == "n"  
    then
	rm -f mkseism.tmp
	echo Abort.
	exit 1
    fi
fi

mv -f mkseism.tmp $seismfile
echo Seismfile $seismfile successfully created.
