#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

# Check parameters
if test "$smoothband" == ""
then
echo ERROR smoothband not defined. STOP
exit 1
fi

#ncomp_total=`echo $nseis_total \* $idcomp0 | bc -l` 
ncomp_total=`echo $nseis_total $idcomp0 | awk '{printf "%d", $1*$2}'` 

# Create Input file
echo "<ESTSPEC>"
echo 0                > $infile_estspec_psd
echo $outputdir2      >> $infile_estspec_psd
echo $ncomp_total     >> $infile_estspec_psd

for comp in $COMPS
do
n=1
while [ $n -le $nseis_total ] 
do
echo $n $comp | awk '{
printf "%s/SD%d%s.d\n","'"$cpwavdir"'",$1,$2}' >>$infile_estspec_psd
let n=n+1
done
done


jc=1
while [ $jc -le $idcomp0 ]
do
js=1
while [ $js -le $nseis_total ]
do
ic=1
while [ $ic -le $idcomp0 ]
do
is=1
while [ $is -le $nseis_total ]
do

if [ $idhuddle -eq 1 ]
then
if   [ $js -eq 1 -a $ic -eq $jc ]
then
printf "1 " >>$infile_estspec_psd
elif [ $ic -eq $jc -a $is -eq $js ]
then
printf "1 " >>$infile_estspec_psd
else
printf "0 " >>$infile_estspec_psd          
fi
else 
if [ $ic -eq $jc -a $is -eq $js ]
then
printf "1 " >>$infile_estspec_psd
else
printf "0 " >>$infile_estspec_psd           
fi
fi
let is=is+1
done
let ic=ic+1
done
printf "\n" >>$infile_estspec_psd           
let js=js+1
done
let jc=jc+1
done

echo $smoothband >> $infile_estspec_psd
cat  $segmentfile |grep -v '^#'| awk 'BEGIN{
print "'"$num"'", "'"$nseg_segave"'"}{
if($1!=""){print $0}}' | $bindir/extrctsgments >> $infile_estspec_psd  

for file in $FILES $segmentfile; do
. script/chkfile.sh $file
done

cat  $infile_estspec_psd | grep -v '^#' | $bindir/estspec 
mv -f fort.7 $logfile_estspec_psd
cat $logfile_estspec_psd | grep 'ERROR' >& /dev/null
if test "$?" == "0"
then
echo ERROR detected in executing $bindir/estspec.
echo abnormal exit $0
echo See logfile: $logfile_estspec_psd
exit 1
fi
