#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

# Check parameters
if test "$smoothband" == ""
then
echo ERROR smoothband not defined. STOP
exit 1
fi

# Create Input file
echo "<ESTSPEC>"
echo 1 > $infile_estspec
echo $outputdir2 >> $infile_estspec

if [ $id_center -eq 1 ]
then

FILES="$R10file $R0rfile $R1rfile $T10file $T0rfile $T1rfile $Z00file $Z0rfile $Z1rfile $segmentfile"
echo 9 >> $infile_estspec
echo $R10file >> $infile_estspec
echo $R0rfile >> $infile_estspec
echo $R1rfile >> $infile_estspec
echo $T10file >> $infile_estspec
echo $T0rfile >> $infile_estspec
echo $T1rfile >> $infile_estspec
echo $Z00file >> $infile_estspec
echo $Z0rfile >> $infile_estspec
echo $Z1rfile >> $infile_estspec

echo 1 1 1 1 1 0 0 0 0 >> $infile_estspec
echo 1 1 1 0 0 0 0 0 0 >> $infile_estspec
echo 0 1 1 0 1 1 0 0 0  >> $infile_estspec
echo 0 1 0 0 1 1 0 0 0  >> $infile_estspec
echo 0 1 0 1 1 1 0 0 0  >> $infile_estspec
echo 0 1 0 0 1 1 0 0 0  >> $infile_estspec
echo 0 0 0 0 0 0 1 1 0  >> $infile_estspec
echo 0 0 0 0 0 0 1 1 0  >> $infile_estspec
echo 0 0 1 0 0 1 0 0 1  >> $infile_estspec

else

FILES="$R0rfile $R1rfile $T0rfile $T1rfile $segmentfile"
echo 6 >> $infile_estspec
echo $R0rfile >> $infile_estspec
echo $R1rfile >> $infile_estspec
echo $T0rfile >> $infile_estspec
echo $T1rfile >> $infile_estspec
echo $Z0rfile >> $infile_estspec
echo $Z1rfile >> $infile_estspec
echo  1 1 0 0 0 0  >> $infile_estspec
echo  1 1 1 1 0 0  >> $infile_estspec
echo  1 0 1 1 0 0  >> $infile_estspec
echo  1 0 1 1 0 0  >> $infile_estspec
echo  0 0 0 0 1 0  >> $infile_estspec
echo  0 1 0 1 0 1  >> $infile_estspec

fi

for file in $FILES; do
. script/chkfile.sh $file
done

echo $smoothband >> $infile_estspec
cat  $segmentfile |grep -v '^#'| awk 'BEGIN{
print "'"$num"'", "'"$nseg_segave"'"}{
if($1!=""){print $0}}' | $bindir/extrctsgments  >> $infile_estspec  

cat  $infile_estspec | grep -v '^#' | $bindir/estspec 
mv -f fort.7 $logfile_estspec
cat $logfile_estspec | grep 'ERROR' >& /dev/null
if test "$?" == "0"
then
echo ERROR detected in executing $bindir/estspec.
echo abnormal exit $0
echo See logfile: $logfile_estspec
exit 1
fi
