#!/bin/bash 
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

###################################################
# Don't touch from here
###################################################

#----------------
# Initilize
#----------------
num=1
#cp $paramfile $paramfile_default
.  $paramfile

if [ $idcalc -eq 1 ]
then
idmkcrcle=1
idestspec=1
idspecratio=1
idspec2pv=1
idave=1
iddelete=1
else
idprepro=0
idmksegment=0
idmkcrcle=0
idestspec=0
idspecratio=0
idspec2pv=0
idave=0
iddelete=0
fi

# for test
#idcalc=0
#idprepro=0
#idmksegment=0
#idmkcrcle=0
#idestspec=0
#idspecratio=0
#idspec2pv=0
#idave=0
#idgnplt=1
#iddelete=0

. ./script/setpar.sh

if test "$warning_flag" == "1"
then
yn=""
while [ "$yn" != "y" -a "$yn" != "Y" -a "$yn" != "n" -a "$yn" != "N" ]
do
           echo 
           echo "Do you really want to start running the program? [y/n] "
           yn="y"
#           read yn
done
if test "$yn" == "n" -o "$yn" == "N" 
then
echo exit 
exit 1
fi
fi # warning_flag

mv -f $paramfile $datadir

#----------------
# Automatic Detection of Preferable Data Portions 
#----------------
while [ $idwavecheck -ge 1 ]
do

if [ $idmksegment -eq 1 ]
then

. ./script/mksegment.sh

else

if [ $idcalc -eq 1 ]
then
. ./script/chksegment.sh
fi

fi

#----------------
# Obtain the parameters for iteration
#----------------
. script/chkfile.sh $segmentfile
nblock=`cat $segmentfile | grep -v '^#' | head -1`
nummax=`echo $nblock  $nseg_segave | awk '{
        if($2==0){nummax=1}else{nummax=$1/$2}
        if(nummax<1){nummax=1}; printf "%d\n",nummax}'`

#----------------
# Plot waves with selected portions
#----------------
if [ $idgnplt -eq 1 ]
then
. ./script/mkgnplt_wave.sh 
fi

if test "$nseg_segave" != "0"
then
if [ $nblock -lt $nseg_segave ]
then
echo "Error: The number of data segments over which averages are taken exceeded the total number of data segments. Calculation can not be conducted. STOP."
exit 1
fi
fi

#----------------
# edit waves
#----------------
if [ $idprepro -eq 1 ]
then

echo 
echo "<PREPROCESSING THE DATA>"

yn=""
while [ "$yn" != "y" -a "$yn" != "Y" -a "$yn" != "n" -a "$yn" != "N" ]
do
           if [ $idwavecheck -eq 1 ];then
	       echo 
	       echo "Do you want to preprocess the waveforms? [y/n] "
	       echo "[This includes elimination of the trend, application of tapers (and bandpass filtering and decimation if necessary)]"
	       echo 
               echo "NOTE: The original data will be moved to a directory named \"originaldata\", which will be automatically created by BIDO under the directory where the original data files are currently stored. Instead, new files with the same names as those of the original data will be created to store the preprocessed data. (The seismfile will also be moved to the directory \"originaldata\" as well, and newly created by BIDO under the directory where the original seismfiles are currently stored. This is necessary because the preprocessing possibly involved decimation.) The original data files will not be overwritten (destroyed) by BIDO. It is strongly recommended, however, to create backup of the original data files to avoid their accidental destruction."
	   else
               printf "The original data are in the directory $originaldatadir. The data in $datadir are those after preprocessing "
	       cat $logfile_prepro
	       echo 
	       echo "Do you want to preprocess the original waveforms anew? [y/n]"
	       echo 
               echo "NOTE: The original data in the directory $originaldatadir  will be preprocessed and stored anew in $datadir after the preprocessing. The data files are currently stored in $datadir will be overwritten [The original data files in the directory $originaldatadir will not be overwritten (destroyed) by BIDO]."
	   fi
           echo "Type \"n\" to skip preprocessing."
           read yn
done

if test "$yn" == "n" -o "$yn" == "N" 
then
idwavecheck=0
else 
. ./script/prepro.sh 
let idwavecheck=idwavecheck+1
fi

else # idprepro

idwavecheck=0

fi  # idprepro

done # idwavecheck



#----------------
# Preliminary Editiion of Waveform Data
#----------------
if [ $idmkcrcle -eq 1 ]
then

if [ $idarray -eq 1 ]
then

. ./script/mkcrcle.sh

if [ $idcomp -ge 2 ]
then
. ./script/mkcrcle_h.sh
fi

fi #idarray

if [ $idhv -eq 1 ]
then
. ./script/mkwav3c.sh
fi

fi # idmkcrcle

if [ $idcalc -eq 0 ];then

nummax=0

else
#----------------
# Delete Previous results
#----------------
if [ -d $outputdir/1 ];	then
    outputdir_prev_num=`ls -d $outputdir/[1-9]*`
fi
if [ -d $outputdir/ave ];then
    outputdir_prev_ave=$outputdir/ave
fi
if test "$outputdir_prev_num" != "" -o "$outputdir_prev_ave" != ""; then
echo ""

echo "* Preexisting directori(es) detected (created in a previous calculation?):" 
echo $outputdir_prev_num $outputdir_prev_ave
echo "NOTE: These directories are removed to proceed with the current analysis."
echo ""
fi
for dir in $outputdir_prev_num $outputdir_prev_ave;do
    rm -rf $dir
done

if [ $idpsd -eq 1 ];then
    . ./script/cpwav.sh
fi

fi # idcalc

#========================================
# Do-While Loop STARTS
#========================================
while [ $num -le $nummax ]
do
echo 
echo "### Step $num (Total $nummax) ###"
. ./script/setpar.sh

#----------------
# Spectral estimation
#----------------

if [ $idestspec -eq 1 ]
then

if [ $idarray -eq 1 ]
then
. ./script/$ESTSPECSH
fi

if [ $idhv -eq 1 ]
then
. ./script/$ESTSPECHVSH
fi

if [ $idpsd -eq 1 ]
then
. ./script/$ESTSPECPSDSH
fi

fi # idestspec

#----------------
# Post Process
#----------------
# Take Spectarl Ratio
if [ $idspecratio -eq 1 ]
then

if [ $idarray -eq 1 ]
then

if   [ $idcomp -eq 1 ]
then
. ./script/specratio.sh
elif [ $idcomp -eq 2 ]
then
. ./script/specratio_h.sh
elif [ $idcomp -eq 3 ]
then
. ./script/specratio.sh
. ./script/specratio_h.sh
fi

fi # idarray 

if [ $idhv -eq 1 ]
then
. ./script/specratio_hv.sh
fi

if [ $idhuddle -eq 1 ]
then
. ./script/specratio_huddle.sh
fi

fi # idspecratio


# Conversion from SPR to Phase Velocity
if [ $idspec2pv -eq 1 ]
then

if   [ $idcomp -eq 1 ]
then
. ./script/spec2pv.sh
elif [ $idcomp -eq 2 ]
then
. ./script/spec2pv_h.sh
elif [ $idcomp -eq 3 ]
then
. ./script/spec2pv.sh
. ./script/spec2pv_h.sh
fi

fi # idspec2pv

let num=num+1
done # num
#========================================
# Do-While Loop ENDS
#========================================

if [ $idave -eq 1 ]
then

. ./script/mkave.sh

fi

#----------------
# Plot Analysis Results
#----------------

if [ $idgnplt -eq 1 ]
then
. ./script/mkgnplt.sh 
fi

if [ $iddelete -eq 1 ]
then
. ./script/mkdelete.sh
fi

