#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<CHKSEGMENT>"

if [ ! -f $segmentfile ]
then

echo "ERROR: the segment file $segmentfile not found. The option \"automatic selection of data portion\" is off. You should do either of the following:"
echo "i) Manually create a segment file and name it $segmentfile. See the user manual for the format."
echo "ii) Restart the program run.sh and set the option \"automatic selection of data portions\" on."
echo abnormal exit $0
exit 1

fi

logfile_chksegment=$outputdir/chk_segment.log
if [ -f $logfile_chksegment ]
then
rm -f $logfile_chksegment 
fi
cat  $segmentfile |grep -v '^#' | awk 'BEGIN{print "'"$segment_duration"'"
}{print $0}' | $bindir/chk_segment > $logfile_chksegment 

cat  $logfile_chksegment | grep 'ERROR' >& /dev/null

if test "$?" == "0"
then

echo ERROR detected in the segmentfile $segmentfile
echo "See the logfile $logfile_chksegment for the detail of the error(s). "
echo See the user manual for the format. 
echo abnormal exit $0
exit 1

else

rm -f $logfile_chksegment 

fi

echo Segmentfile :$segmentfile ... Checked.

