c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include"PARAM.h"
c subroutine requested slatec/fzero
      common/OBSERVED/obs
      common/RDSR/r2r
      external bslj0,bslj02,bslj12,bslj0212,bslj012,bslj1212,
     +     bslj1111,cca_m_l,spac_m_l,spac_p_l
      data freq0,re,ae/-1.e3,1.e-7,1.e-7/
c      data freq0,re,ae/-1.e3,1.e-10,1.e-10/
      save RDSR

      read(5,*)itype,radius,dfmin,freq_max

      if(itype.eq.1)then ! spac
         xmin=0.
         xmax=3.83
      else if(itype.eq.2)then ! Henstridge J0^2
         xmin=0.
         xmax=2.40
      else if(itype.eq.3)then ! Henstridge J1^2
         xmin=0.
         xmax=1.84
      else if(itype.eq.4)then ! new J0/J1^2
         xmin=0.001
         xmax=3.83
      else if(itype.eq.5)then ! new J0^2/J1^2
         xmin=0.001
         xmax=2.40
      else if(itype.eq.10)then ! LOVE or RAYL J1^2/J1^2
         read(5,*)radius2
         if(radius.le.radius2)then
            write(6,*)'ERROR:radius.le.radius2:',radius,radius2
            stop
         endif
         r2r=radius2/radius
         xmin=0.001
         xmax=3.83
      else if(itype.eq.11)then ! LOVE or RAYL J1/J1
         read(5,*)radius2
         if(radius.le.radius2)then
            write(6,*)'ERROR:radius.le.radius2:',radius,radius2
            stop
         endif
         r2r=radius2/radius
         xmin=0.001
         xmax=3.83
      else if(itype.eq.21)then ! CCA-L,R
         xmin=0.001
         xmax=3.7  ! functionT˕sAƂȂƂB
      else if(itype.eq.22)then ! SPAC-L,R
         xmin=0.001
         xmax=3.5 ! ڂ̋ɏ(ŏ)
      else if(itype.eq.23)then ! SPAC+L,R
         xmin=0.001
         xmax=5.1 ! ڂ̋ɏ(ŏ)
      else 
         write(6,*)'ERROR: no list of itype ',itype
         stop
      endif

c read & inversion
 10   read(5,*,err=99,end=99)freq,obs

      if(freq-freq0.le.dfmin)then
         goto 90      
      else
         freq0=freq
      endif
      b=xmin
      c=xmax
      r=c

c------------------------<----------------------------------------------
      if(itype.eq.1)then
         call fzero(bslj0, b, c, r, re, ae, iflag)
      else if(itype.eq.2)then
         call fzero(bslj02, b, c, r, re, ae, iflag)
      else if(itype.eq.3)then
         call fzero(bslj12, b, c, r, re, ae, iflag)
      else if(itype.eq.4)then
         call fzero(bslj012, b, c, r, re, ae, iflag)
      else if(itype.eq.5)then
         call fzero(bslj0212, b, c, r, re, ae, iflag)
      else if(itype.eq.10)then
         call fzero(bslj1212, b, c, r, re, ae, iflag)
      else if(itype.eq.11)then
         call fzero(bslj1111, b, c, r, re, ae, iflag)
      else if(itype.eq.21)then
         call fzero(cca_m_l, b, c, r, re, ae, iflag)
      else if(itype.eq.22)then
         call fzero(spac_m_l, b, c, r, re, ae, iflag)
      else if(itype.eq.23)then
         call fzero(spac_p_l, b, c, r, re, ae, iflag)
      endif
      call wn2pv(b,freq,radius,pv)
      if(iflag.eq.3)then        !  singular
         write(6,*)freq,pv,' SINGULAR_POINT'
      else if(iflag.eq.4.or.iflag.eq.5)then ! no root
         write(6,*)freq, 999.,' NO_ROOT ',iflag, obs
      else
         write(6,*)freq,pv,pv/(freq*radius)
      endif

c----------------------------------------------------------------------

 90   continue
      if(freq.ge.freq_max)goto 99
      goto 10
 99   continue
      stop
      end

      function bslj0(x)
      common/OBSERVED/obs
      fjisu=0.
      call cal_bsl(fjisu,x,y)
      bslj0=y-obs
      return
      end

      function bslj02(x)
      common/OBSERVED/obs
      fjisu=0.
      call cal_bsl(fjisu,x,y)
      bslj02=y**2.-obs
      return
      end

      function bslj12(x)
      common/OBSERVED/obs
      fjisu=1.
      call cal_bsl(fjisu,x,y)
      bslj12=y**2.-obs
      return
      end

      function bslj0212(x)
      common/OBSERVED/obs
      fjisu=0.
      call cal_bsl(fjisu,x,y0)
      fjisu=1.
      call cal_bsl(fjisu,x,y1)
      bslj0212=y0**2/y1**2 - obs
      return
      end

      function bslj012(x)
      common/OBSERVED/obs
      fjisu=0.
      call cal_bsl(fjisu,x,y0)
      fjisu=1.
      call cal_bsl(fjisu,x,y1)
      bslj012=y0/y1**2 - obs
      return
      end

      function bslj1212(x)
      common/OBSERVED/obs
      common/RDSR/r2r
      fjisu=1.
      call cal_bsl(fjisu,x,y0)
      fjisu=1.
      x_in=r2r*x
      call cal_bsl(fjisu,x_in,y1)
      bslj1212=y0**2/y1**2 - obs
      return
      end

      function bslj1111(x)
      common/OBSERVED/obs
      common/RDSR/r2r
      fjisu=1.
      call cal_bsl(fjisu,x,y0)
      fjisu=1.
      x_in=r2r*x
      call cal_bsl(fjisu,x_in,y1)
      bslj1111=y0/y1 - obs
      return
      end

      function cca_m_l(x)
      common/OBSERVED/obs
      fjisu=0.
      call cal_bsl(fjisu,x,y0)
      fjisu=2.
      call cal_bsl(fjisu,x,y2)
      cca_m_l=(y0-y2)/(y0+y2) - obs
      return
      end

      function spac_m_l(x)
      common/OBSERVED/obs
      fjisu=0.
      call cal_bsl(fjisu,x,y0)
      fjisu=2.
      call cal_bsl(fjisu,x,y2)
      spac_m_l=(y0-y2) - obs
      return
      end

      function spac_p_l(x)
      common/OBSERVED/obs
      fjisu=0.
      call cal_bsl(fjisu,x,y0)
      fjisu=2.
      call cal_bsl(fjisu,x,y2)
      spac_p_l=(y0+y2) - obs
      return
      end

      subroutine wn2pv(wn,freq,radius,pv)
      pv=PI2*freq*radius/wn
      return
      end

      subroutine cal_bsl(fjisu,x,y)
      parameter(ny=1)
      complex cy0,cy1,cy, z
      dimension cy0(ny),cy1(ny),cy(2)
      kode=2
      z=cmplx(x,0.)
      call cbesj(z, fjisu,  kode, ny, cy0, nz, ierr)
      if(nz.ne.0 .or. ierr.ne.0)then
         write(6,*)'Error:nz or ierr in cbesj()',nz,ierr
         stop
      endif
      y=cy0(1)*1.0
      return
      end
