c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
      dimension dat(4*15)
      complex R10_R0r,R10_R10,R10_R1r,R10_T0r,R1r_R0r,
     +     R1r_R1r,R1r_T0r,R10_T10,R1r_T1r,T10_R0r,
     +     T10_T0r,T10_T1r,T1r_R0r,T1r_T0r,T1r_T1r,
     +     rhox2,rhoy,rhospac_mr,rhospac_pl,
     +     rho1,rho2,rhospac_pmr,rhospac_pml,
     +     bunshi,bunbo,eps_h

      read(5,*)id,nseis

      if(id.eq.1)then  ! type R
         ncol=4*7
      else if(id.eq.2)then ! type B
         ncol=4*15
      endif

 10   read(5,*,err=99,end=99)(dat(i),i=1,ncol)

      icol0=0
      if(id.eq.1)then  ! type R
         R10_R0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R10_R10=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R10_R1r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R10_T0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R1r_R0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R1r_R1r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R1r_T0r=complex(dat(icol0+2),dat(icol0+3))

         iderr=0
         if(R10_R10.ne.0.)then
            rhox2=R1r_R1r/R10_R10
            rhoy=R10_R1r/R10_R10
         else
            iderr=1
         endif

         if(R10_R0r.ne.0.)then
            rhospac_mr=R1r_R0r/R10_R0r
         else
            iderr=1
         endif

         if(R10_T0r.ne.0.)then
            rhospac_pl=R1r_T0r/R10_T0r
         else
            iderr=1
         endif

         bunshi=rhospac_mr*rhospac_pl
     +        -(rhospac_mr+rhospac_pl)*rhoy+rhox2
         bunbo=(rhospac_mr+rhospac_pl)*rhoy-rhox2+2./nseis

         if(bunbo.ne.0.)then
            eps_h=bunshi/bunbo
         else
            iderr=1
         endif

      else if(id.eq.2)then ! type B
         R10_R0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R10_R10=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R10_R1r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R10_T0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R1r_R0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R1r_R1r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R1r_T0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R10_T10=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         R1r_T1r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         T10_R0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         T10_T0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         T10_T1r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         T1r_R0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         T1r_T0r=complex(dat(icol0+2),dat(icol0+3))
         icol0=icol0+4
         T1r_T1r=complex(dat(icol0+2),dat(icol0+3))


         iderr=0
         if(R10_R10.ne.0.)then
            rho1=R10_R1r/R10_R10+T10_T1r/R10_R10
         else
            iderr=1
         endif

         if(R10_T10.ne.0.)then
            rho2=R1r_R1r/R10_R10+2.*R1r_T1r/R10_T10+T1r_T1r/R10_R10
         else
            iderr=1
         endif

         if(T10_R0r.ne.0. .and. R10_R0r.ne.0.)then
            rhospac_pmr=T1r_R0r/T10_R0r+R1r_R0r/R10_R0r
         else
            iderr=1
         endif

         if(R10_T0r.ne.0. .and. T10_T0r.ne.0.)then
            rhospac_pml=R1r_T0r/R10_T0r+T1r_T0r/T10_T0r
         else
            iderr=1
         endif

         bunshi=rhospac_pmr*rhospac_pml
     +        -(rhospac_pmr+rhospac_pml)*rho1+rho2
         bunbo=(rhospac_pmr+rhospac_pml)*rho1-rho2+4./float(nseis)

         if(bunbo.ne.0)then
            eps_h=bunshi/bunbo
         else
            iderr=1
         endif

      endif
      
      if(iderr.ne.1)then
         if(real(eps_h).gt.0.)write(6,*)dat(1),real(eps_h)
      endif

      goto 10
 99   continue


      stop
      end

