c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM.h"
c x,y$B$O(BEW, NS$B$KBP1~(B.
      parameter(maxseis=MAXSIEIS_INC,maxorder=MAXORDER_INC)
      parameter(jfilemax=100)  ! appropriately large number
      implicit real*8 (a-h,o-z)                                         
      complex*16 ai,cw,cwi,cwj
      dimension  x(maxseis),y(maxseis),d(maxseis)
     +     ,dtan(maxseis),drad(maxseis),dx(maxseis),dy(maxseis)
     +     ,ri(maxseis),rate(maxseis),tht(maxseis)
c
      complex s(maxseis),e(maxseis),work(maxseis),element
      complex u(maxseis,maxseis),v(maxseis,maxseis)
      complex a(maxseis,maxseis), ainv(maxseis,maxseis)
      complex ctmp(maxseis,maxseis)
      integer job,info
      character*200 buf,seisfile(maxseis),ofile(0:jfilemax)
      character*80 cline
      nopen0=10
      ai=(0.d0,1.d0)
      call rseis(5,nseis,x,y,x0,y0,rr,ri,rate,seisfile)
      read(5,*)ncomp
      read(5,*)morder
      call calorder(nseis,morder,mordermax)
      write(6,*)'read ncomp   : ',ncomp
      if(ncomp.ne.1)then
         write(6,*)'ERROR ncomp:',ncomp
         stop
      endif

      do icomp=1,ncomp
         do iorder=0,morder
            jfile=(icomp-1)*(mordermax+1)+(iorder+1)
c            read(5,'(a)')ofile(jfile)
            do iseis=1,nseis
c ----------------------------------------------------------------------
c               deg=atan360(x(iseis)-x0,y(iseis)-y0)
               deg=atan360(x(iseis),y(iseis))
c     x(=EW)$B<4$K4X$7$F(B0$BEY$+$i;O$^$C$FH?;~7W<~$j$r@5$H$9$k!#(B
c ----------------------------------------------------------------------
               tht(iseis)=D2R*deg
            enddo
         enddo
      enddo
c----------------------------------------------------------------------
c kernel
c----------------------------------------------------------------------
c kernel$B:n@.$K$D$$$F$O(Bmorder$B$N;XDj$K$h$i$:(Bnseis$B$K1~$8$?:GBg<!?t$^$G(B
c $B5a$a$k$3$H$H$9$k(B. 
c ($BBn1[<!?t$OK\<AE*$KITL@$J$N$G$=$N$[$&$,8m:9$,>/$J$$$H9M$($k(B.)
      do iseis=1,nseis
         a(iseis,1)= 1.
         do iorder=1,mordermax
            a(iseis,2*iorder  )= 2.*cos(dble(iorder)*tht(iseis))
            a(iseis,2*iorder+1)=-2.*sin(dble(iorder)*tht(iseis))
         enddo
      enddo
      ip=2*mordermax+1

c nseis > mordermax*2+1$B$N>l9g$O<!$N<!?t$N<B?tIt$@$15a$a$k$3$H$H$9$k!#(B
      if(nseis-ip.eq.1)then
         ip=ip+1
         do iseis=1,nseis
            a(iseis,ip)= 2.*cos(dble(ip)*tht(iseis))
         enddo
      endif
c----------------------------------------------------------------------
c $BJ#AG9TNs$r07$&I,MW$O$J$$$,(B, $B>-Mh$N3HD%@-$r9MN8$7$F(Bcsvds()$B$rE,MQ$7$F$*$/(B
c
c         input  ctmp (--> destroyed)
c         output s:diagonals including sigular values
c                e:ordinarily contains zeros
c                u:matrix of N left singular vectors when JOBA=1
c                v:matrix of right singular vectors when JOBB=1
c                info:The singular values (and their corresponding
c                 singular vectors) S(INFO+1),S(INFO+2),...,S(M)
c                 are correct (here M=MIN(N,P)).  Thus if info.eq.0, 
c                 all the singular values and their vectors are correct.
      job=11 
c     call csvdc (ctmp,maxseis,ip,nseis, 
      call csvdc (a,maxseis,ip,nseis, 
     +     s,e,u,maxseis,v,maxseis,work,job,info)  
c----------------------------------------------------------------------
c  $B$H$j$"$($:%@%s%W$O$J$7(B
      dmp=0.
      krank=ip
      do iseis=1,nseis
         do iorder=1,ip
            element=(0.,0.)
            do ll=1,krank
               element=element+v(iorder,ll)*conjg(u(iseis,ll))/
     +              (s(ll)+dmp)
            enddo
            ainv(iorder,iseis)=conjg(element)
         enddo
      enddo
      write(6,*)'Inverse Matrix:'
      do iorder=1,ip
         write(6,'(10f10.4)')
     +        (real(ainv(iorder,iseis)),iseis=1,nseis)
      enddo

c----------------------------------------------------------------------
c output
c----------------------------------------------------------------------
c      iorder=0
c      do iseis=1,nseis
c         arl=ainv(1,iseis)
c         aim=0.
c         write(6,'(a,2i5,2e20.8,a)')
c     +        ' cohcca ',
c     +        iorder,iseis,arl,aim,
c     +        ' '//seisfile(iseis)(1:index(seisfile(iseis),' ')-1)
c      enddo
c
c      do iorder=1,morder
c         do iseis=1,nseis
c            arl=ainv(2*iorder  ,iseis)
c            aim=ainv(2*iorder+1,iseis)
c            write(6,'(a,2i5,2e16.5,a)')
c     +        ' cohcca ',
c     +           iorder,iseis,arl,aim,
c     +        ' '//seisfile(iseis)(1:index(seisfile(iseis),' ')-1)
c         enddo
c      enddo

      iorder=0
      do iseis=1,nseis
      do jseis=1,nseis
         arli=ainv(1,iseis)
         aimi=0.
         arlj=ainv(1,jseis)
         aimj=0.
         cwi=arli+ai*aimi
         cwj=arlj+ai*aimj
         cw=cwi*dconjg(cwj)
         arl=dreal(cw)
         aim=dimag(cw)          
         write(6,'(a,3i5,2e20.8,2a)')
     +        ' cohcca ',
     +        iorder,iseis,jseis,arl,aim,
     +        ' '//seisfile(iseis)(1:index(seisfile(iseis),' ')-1),
     +        ' '//seisfile(jseis)(1:index(seisfile(jseis),' ')-1)
      enddo
      enddo

      do iorder=1,morder
         do iseis=1,nseis
         do jseis=1,nseis
            arli=ainv(2*iorder  ,iseis)
            aimi=ainv(2*iorder+1,iseis)
            arlj=ainv(2*iorder  ,jseis)
            aimj=ainv(2*iorder+1,jseis)
            cwi=arli+ai*aimi
            cwj=arlj+ai*aimj
            cw=cwi*dconjg(cwj)
            arl=dreal(cw)
            aim=dimag(cw)          
            write(6,'(a,3i5,2e16.5,2a)')
     +           ' cohcca ',
     +           iorder,iseis,jseis,arl,aim,
     +           ' '//seisfile(iseis)
     +           (1:index(seisfile(iseis),' ')-1),
     +           ' '//seisfile(jseis)
     +           (1:index(seisfile(jseis),' ')-1)
         enddo
         enddo
      enddo
      
      stop
      end

      subroutine rseis(ifile,nseis,x,y,x0,y0,rr,ri,rate,seisfile)
      implicit real*8 (a-h,o-z)                                         
      parameter(maxseis=MAXSIEIS_INC)
      dimension x(maxseis),y(maxseis),ri(maxseis),rate(maxseis)
      dimension xorg(maxseis),yorg(maxseis)
      character*200 seisfile(maxseis)
      eps=RADIUS_ERROR_LEVEL
      read(ifile,*)nseis
      do i=1,nseis
         read(ifile,*)x(i),y(i)
         xorg(i)=x(i)
         yorg(i)=y(i)
         write(6,*)x(i),y(i)
         read(ifile,'(a)')seisfile(i)
         seisfile(i)=seisfile(i)(1:index(seisfile(i),' ')-1)
         write(6,'(2a)')'INPUT: ',
     +        seisfile(i)(1:index(seisfile(i),' ')-1)
      enddo
     
      if(nseis.eq.1)then
         write(6,*)'Notice: nseis=',nseis
         read(ifile,*)rr
         x0=x(1)
         y0=y(1)
         rate(1)=0.
         ri(1)=rr
      else if(nseis.eq.2)then
         iderrinradius=0
         write(6,*)'Notice: nseis=',nseis
         read(ifile,*)rr1
         read(ifile,*)rr2
         x0=999.
         y0=999.
         rr=(rr1+rr2)/2.
         ri(1)=rr1
         ri(2)=rr2
         write(6,*)'    SeisNo CorrectedXY Actual radius   error rate'
         do i=1,nseis
            rate(i)=(ri(i)-rr)/rr
            write(6,*)'radius() ',i,x(i),y(i),ri(i),rate(i)
            if(abs(rate(i)).gt.eps)then
               iderrinradius=1
            endif
         enddo
         if(iderrinradius.eq.1)then
            write(6,*)'ERROR: in radius.'
            write(6,*)'Error(s) exceeds a limit value ',eps
            write(6,*)'(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
            stop
         endif
      else
c     calculation of the central position (x0,y0)
         call crctcntr(nseis,x,y,x0,y0,rr)
         write(6,*)'CENTER: (',x0,y0,')',' RADIUS: ',rr
         iderrinradius=0
         write(6,*)'    SeisNo CorrectedXY Actual radius   error rate'
c         do i=1,nseis
c            write(6,*)'DEBUG:',x(i),y(i),dsqrt(x(i)**2+y(i)**2)
c         enddo
         do i=1,nseis
            ri(i)=dsqrt((xorg(i)-x0)**2+(yorg(i)-y0)**2)
            rate(i)=(ri(i)-rr)/rr
            write(6,*)'radius() ',i,x(i),y(i),ri(i),rate(i)
            if(abs(rate(i)).gt.eps)then
               iderrinradius=1
            endif
         enddo
         if(iderrinradius.eq.1)then
            write(6,*)'ERROR: in radius.'
            write(6,*)'Error(s) exceeds a limit ',eps
            write(6,*)'(can be set as RADIUS_ERROR_LEVEL in PARAM.sh)'
            stop
         endif
      endif
      return
      end

      subroutine calorder(nseis,morder,mordermax)
      mordermax=0
 10   continue
      if(nseis.lt.2*mordermax+1)then
         mordermax=mordermax-1
      else
         mordermax=mordermax+1
         goto 10
      endif
      write(6,*)'Order :',morder,' (Max order:',mordermax,')'
      if(morder.gt.mordermax)then
         write(6,*)'ERROR: Morder is set to ',morder
         write(6,*)'possible morder is less than: ',mordermax
         write(6,*)'STOP'
         stop
      endif
      return
      end

      subroutine crctcntr(nseis,x,y,x0,y0,rr)
c $B1_7A%"%l%$$K$*$$$F(B2,3,4$BHVL\$NCO?L7WG[CV$+$iCf?4E@!"H>7B$r7W;;$9$k(B
c $B%k!<%A%s(B(Sat May 11 09:31:59 JST 2002)$B!#(B
      implicit real*8 (a-h,o-z)                                         
      dimension x(*),y(*)
      if(nseis.lt.3)then
         write(6,*)'ERROR in crctcntr():nseis ',nseis
         stop
      endif
      if(y(1)-y(2).ne.0.d0)then
         x12=(x(1)+x(2))/2.d0
         y12=(y(1)+y(2))/2.d0
         a12=-(x(1)-x(2))/(y(1)-y(2))
         if(y(1)-y(3).ne.0.d0)then
            x13=(x(1)+x(3))/2.d0
            y13=(y(1)+y(3))/2.d0
            a13=-(x(1)-x(3))/(y(1)-y(3))
         else
            x13=(x(2)+x(3))/2.d0
            y13=(y(2)+y(3))/2.d0
            a13=-(x(2)-x(3))/(y(2)-y(3))
         endif
      else
         x12=(x(2)+x(3))/2.d0
         y12=(y(2)+y(3))/2.d0
         a12=-(x(2)-x(3))/(y(2)-y(3))
c
         x13=(x(1)+x(3))/2.d0
         y13=(y(1)+y(3))/2.d0
         a13=-(x(1)-x(3))/(y(1)-y(3))
      endif
c
      x0=(a12*x12-a13*x13+y13-y12)/(a12-a13)
      y0=a12*(x0-x12)+y12
      rr=dsqrt((x(1)-x0)**2+(y(1)-y0)**2)
c
      do i=1,nseis
         x(i)=x(i)-x0
         y(i)=y(i)-y0
      enddo
      return
      end

      real*8 function  atan360(x,y)
      implicit real*8 (a-h,o-z)                                         
      pi=acos(-1.d0)
      if(y.eq.0.d0.and.x.ge.0.d0)then
         atan360=0.d0
         return
      else if(y.eq.0.d0.and.x.lt.0.d0)then
         atan360=180.d0
         return
      endif
      if(x.eq.0.d0.and.y.gt.0.d0)then
         atan360=90.d0
         return
      else if(x.eq.0.d0.and.y.lt.0.d0)then
         atan360=270.d0
         return
      endif
      atan360=180.d0/pi*atan(y/x)
      if(x.lt.0)then
         atan360=atan360+180.d0
      else if(x.gt.0.and.y.lt.0)then
         atan360=atan360+360.d0
      endif
 10   continue
      if(atan360.ge.0.d0.and.atan360.lt.360.d0)then
         return
      else if(atan360.lt.0.d0)then
         atan360=atan360+360.d0
      else if(atan360.ge.360.d0)then
         atan360=atan360-360.d0
      endif
      goto 10
      end

