ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     aggolomerative hierarchical clustering method by Ward (1963)
c     approach, which is based on the concept described
c     in the text of Spath (1980)
c     H. Spath, 1980, luster analysis algorithms for data reduction of 
c     objects, chapter4, Ellis Horwood Ltd., 226p.
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#define NMAC_INC 10000
      parameter(nmax=NMAC_INC)
      implicit real*8 (a-h,o-z)
      dimension d(nmax,nmax),na(nmax),nb(nmax),h(nmax)
      dimension ngid(nmax),no_ngid(nmax)
      dimension rave_ngid(nmax),rstd_ngid(nmax),r(nmax)
      
c------------
c input
c------------
      read(5,*)h0
      i=1
 1    read(5,*,err=99,end=99)r(i)
      i=i+1
      goto 1
 99   continue
      m=i-1

      do i=1,m
         do j=1,m
c           d(i,j)=abs(r(i)-r(j))
c            d(i,j)=abs(r(i)-r(j))/amin1(r(i),r(j))
c            d(i,j)=abs(r(i)-r(j))/amax1(r(i),r(j))
            d(i,j)=abs(r(i)-r(j))/((r(i)+r(j))/2.0d0)
         enddo
      enddo
      
c      m1=m-1
c      do i=1,m1
c         i1=i+1
c         read(5,*)(d(i,j),j=i1,m)
c         write(6,'(10f9.2)')(d(i,j),j=i1,m)
c      enddo
      
c------------
c initialize      
c------------
      m1=m-1
      do i=1,m1
         i1=i+1
         do j=i1,m
            d(j,i)=d(i,j)
         enddo
      enddo
      do i=1,m
         ngid(i)=-1
      enddo
      
c------------
c process
c------------
      call agglomhc(m,d,na,nb,h)
      call mkclstr(m,m1,na,nb,h,h0,ngid,igidmax)

c-------------
c statistics
c-------------
      do igid=1,igidmax
         nd=0
         sum=0
         sum2=0
         do i=1,m
            if(ngid(i).eq.igid)then
               nd=nd+1
               sum=sum+r(i)
               sum2=sum2+r(i)**2
            endif
         enddo
         ave=sum/dble(nd)
         if(nd.ge.2)then
            var=(sum2-dble(nd)*ave**2)/(nd-1)
            std=dsqrt(var)
         else
            std=0.d0
         endif
         rave_ngid(igid)=ave
         rstd_ngid(igid)=std
         no_ngid(igid)=nd
      enddo
      
c-------------
c output
c-------------
      do i=1,m
         write( 6,'(3i5,2f10.6)')i,ngid(i),no_ngid(ngid(i)),
     +        rave_ngid(ngid(i)),rstd_ngid(ngid(i))
      enddo
      
      stop
      end

      subroutine agglomhc(m,d,p,q,dpq)
      parameter(nmax=NMAC_INC)
      implicit real*8 (a-h,o-z)
      dimension d(nmax,nmax),dpq(nmax),p(nmax),q(nmax),mw(nmax)
      integer p,q,mw
      m1=m+1
      
c initializing a distance matrix for the m objects
      call mkini(m,mw,d)
      
c updating loop of the distance matrix            
      do l=1,m-1 

c find the minimal distance component [eq.(4.2.2)]
         call detmin(m,d,p(l),q(l),dpq(l))
         do i=1,m
            if(i.ne.p(l).or.j.ne.q(l))then
               
c merging procedure for Cp and Cq
               
c distance defined by eq.(4.2.4) for test
               d(p(l),i)=min(d(p(l),i),d(q(l),i))
c distance defined by eq.(4.2.12) [Ward, 1963]
c               d(p(l),i)=((mw(p(l))+mw(i))*d(p(l),i)
c     +              +(mw(q(l))+mw(i))*d(q(l),i)
c     +              -mw(i)*dpq(l))/dble(mw(i)+mw(p(l))+mw(q(l)))
c overwrite the p-th column by the p-th row updated
               d(i,p(l))=d(p(l),i)
            endif
         enddo
c deleting merged cluster Cq
c updating the number of objects in Cp         
         d(q(l),m1)=-1.d0
         mw(p(l))=mw(p(l))+mw(q(l))
         
      enddo
      
      return
      end

      subroutine mkini(m,mw,d)
      parameter(nmax=NMAC_INC)
      real*8 d(nmax,nmax)
      integer mw(nmax)
      m1=m+1
      do i=1,m
         mw(i)=1
         d(i,i)=1.d30
      enddo
      call mksymmat(m,d)
      do i=1,m
         d(i,m1)=1.d0
      enddo
      return
      end
      
      subroutine mksymmat(m,d)
      parameter(nmax=NMAC_INC)
      real*8 d(nmax,nmax)
      do i=1,m-1
         do j=i+1,m
            d(j,i)=d(i,j)
         enddo
      enddo
      return
      end
      
      subroutine detmin(m,d,p,q,dmin)
      parameter(nmax=NMAC_INC)
      implicit real*8 (a-h,o-z)
      dimension d(nmax,nmax)
      integer p,q
      m1=m+1
      dmin=1.d30
      do i=1,m-1
         if(d(i,m1).gt.0.d0)then
            do j=i+1,m
               if(d(j,m1).gt.0.d0.and.d(i,j).le.dmin)then
                  p=i
                  q=j
                  dmin=d(p,q)
               endif
            enddo
         endif
      enddo
      return
      end
      
      subroutine mkclstr(m,m1,na,nb,h,h0,ngid,igidmax)
      parameter(nmax=NMAC_INC)
      implicit real*8 (a-h,o-z)
      dimension na(nmax),nb(nmax),h(nmax)
      dimension ngid(nmax),ngid_dum(nmax),ng(nmax)
      do i=1,m
         ngid_dum(i)=-1
      enddo
      do i=1,m1
         if(h(i).gt.h0)goto 10
      enddo
 10   continue
      m0=i-1
      igidmax=1
      do igid=1,m0
         
         do i=1,m0
            if(ngid(i).eq.-1)then
               i1=i
               goto 15
            endif
         enddo
 15      ngnum=0
         call addng(ngnum,ng,na(i1))
         call addng(ngnum,ng,nb(i1))
         
         i=1
 20      continue
         if(ngid(i).eq.-1)then
            idok=0
            do ignum=1,ngnum
               if(na(i).eq.ng(ignum))idok=1
               if(nb(i).eq.ng(ignum))idok=1
            enddo
            if (idok.eq.1)then
               igidmax=igid
               ngid(i)=igid
               call addng(ngnum,ng,na(i))
               call addng(ngnum,ng,nb(i))
               i=0
            endif
         endif
         if(i.lt.m0)then
            i=i+1
            goto 20
         endif
      enddo

c------------------------
c asign the cluster number to each data point 
c------------------------
c      do i=1,m1
c         write(6,*)'debug:',i,na(i),nb(i),ngid(i)
c      enddo
     
      do i=1,m1
         if(ngid(i).ne.-1)then
            ngid_dum(na(i))=ngid(i)
            ngid_dum(nb(i))=ngid(i)
         endif
      enddo
c      write(6,*)'igidmax=',igidmax
c      do i=1,m
c         write(6,*)i,ngid_dum(i)
c      enddo
      
      do i=1,m
         ngid(i)=ngid_dum(i)
      enddo
      j=1
      do i=1,m
         if(ngid(i).eq.-1)then
            ngid(i)=igidmax+j
            j=j+1
         endif
      enddo
      igidmax=1
      do i=1,m
         if(ngid(i).ge.igidmax)then
            igidmax=ngid(i)
         endif
      enddo
      return
      end

      subroutine addng(ngnum,ng,nadd)
      parameter(nmax=NMAC_INC)
      implicit real*8 (a-h,o-z)
      dimension ng(nmax)
      idok=0
      do i=1,ngnum
         if(ng(i).eq.nadd)idok=1
      enddo
      if(idok.eq.1)then
         return
      else
         ngnum=ngnum+1
         ng(ngnum)=nadd
         return
      endif
      end
      
      
