c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM_PREPROCESS.h"
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)                                         
      character file1*200,outfile*200,comp*1
      common /DATBLK/dat(nmax)
      dimension rmsvalue(nmax)
      dimension rmsvalue_sort(nmax)

      read(5,*)duration
      read(5,*)dt
      read(5,*)beg_org
      beg=beg_org
      read(5,*)ovlpratio
      read(5,*)nremove
      read(5,'(a)')comp
      read(5,'(a)')file1
      read(5,'(a)')outfile
      if(comp.eq.'u')idcomp=1
      if(comp.eq.'e')idcomp=2
      if(comp.eq.'n')idcomp=3
      open(17,file=outfile)
      nlen=int(duration/dt+0.5)
      call rfile(npts,nremove,idcomp,dt,file1)
c      write(6,*)'npts=',npts
      call dtrd(dat,npts,dat,1,slope,ave) !Remove Trend
c      call rms(dt,rmsvalue0,1,npts)
c      write(6,*)'rms all',rmsvalue0
      tstep=duration*(1.-ovlpratio)

      i=1
      do iblock=1,1000000
         nbeg=int(beg/dt+0.5)
         nend=nbeg+nlen-1
         if(nend.gt.npts)goto 10
         call rms(dt,rmsvalue(iblock),nbeg,nend)
         beg=beg+tstep
         i=i+1
 10   enddo
      nblock=i-1

c---------------------------------------------------------------
c robust estimate of overall rms [Segments having RMS values 
c in order smaller than 10% or larger than 90% will be exculded].
      cutoff_ratio_begin=0.1 ! 
      cutoff_ratio_end=0.9
c---------------------------------------------------------------
      call sort(rmsvalue,nblock,rmsvalue_sort)
c      do iblock=1,nblock
c         write(6,*)iblock,rmsvalue(iblock),rmsvalue_sort(iblock)
c      enddo
      iblocks=int(nblock*cutoff_ratio_begin+0.5)
      iblocke=int(nblock*cutoff_ratio_end+0.5)
      rmsvalue0=0.
      do iblock=iblocks,iblocke
         rmsvalue0=rmsvalue0+rmsvalue_sort(iblock)
      enddo
      rmsvalue0=rmsvalue0/float(iblocke-iblocks+1)
c---------------------------------------------------------------

      beg=beg_org
      write(17,*)duration,dt,beg,ovlpratio
      do iblock=1,nblock
         nbeg=int(beg/dt+0.5)
         write(17,*)beg,rmsvalue(iblock)/rmsvalue0
         beg=beg+tstep
      enddo

      close(17)
      stop
      end

      subroutine rms(dt,rmsvalue,nbeg,nend)
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)                                         
      common /DATBLK/dat(nmax)
      sum=0.
      do i=nbeg,nend
         sum=sum+dat(i)**2
      enddo
      tt=dt*(nend-nbeg)
      rmsvalue=sqrt(sum/tt)
      return
      end

      subroutine wfile(file)
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)                                         
      common /DATBLK/dat(nmax)
      character*200 file
c
      common /SACBLK/fhd,nhd,khd
      real fhd(70),d_sac
      integer nhd(40)
      character khd(48)*4

      open(1,file=file,access='direct',recl=4)
      do i=1,70
      write(1,rec=i)fhd(i)
      enddo
      do i=1,40
      write(1,rec=i+70)nhd(i)
      enddo
      do i=1,48
      write(1,rec=i+110)khd(i)
      enddo
      do i=1,nhd(10)
         d_sac=dat(i)*1.
         write(1,rec=i+158)d_sac
      enddo
      return
 91   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR:opening file ',file(1:index(file,' ')-1)
      stop 
 93   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR: in file ',file(1:index(file,' ')-1)
      write(6,*)'       writing data ',i
      stop
      end

      subroutine rfile(npts,nremove,idcomp,dt,file)
      parameter(nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)                                         
      character*200 file
      character*80 buf
      common /DATBLK/dat
      dimension dat(nmax)
      open(15,file=file,status='old',err=91)
c      do i=1,28
c         read(15,*)
c      enddo
      i=1
c 10   read(15,*,err=89,end=89)buf,dum,dum,dat(i)
      if(idcomp.eq.1)then
 10      read(15,*,err=89,end=89)buf,dat(i)
         i=i+1
         goto 10
 89      continue
      else if(idcomp.eq.2)then
 11      read(15,*,err=90,end=90)buf,dum,dat(i)
         i=i+1
         goto 11
 90      continue
      else if(idcomp.eq.3)then
 12      read(15,*,err=88,end=88)buf,dum,dum,dat(i)
         i=i+1
         goto 12
 88      continue
      endif
      npts=i-1
      close(15)

c remove initial data points
      do i=1+nremove,npts
         i2=i-nremove
         dat(i2)=dat(i) 
c         write(16,*)dt*(i2-1),dat(i2)
      enddo
      npts=npts-nremove

      return
c
 91   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR:opening file ',file(1:index(file,' ')-1)
      stop 
 93   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR: in file ',file(1:index(file,' ')-1)
      write(6,*)'       reading data ',i
      stop
 94   write(6,'(a)')'Program evalrms.'
      write(6,*)'ERROR: in file ',file(1:index(file,' ')-1)
      write(6,*)'       dt in datafile ',dt_r,' .ne. given dt',dt
 95   write(6,*)'ERROR: in file ',file(1:index(file,' ')-1)
      write(6,*)'       npts in datafile ',npts,' .gt. given nmax',nmax
      stop
      end

      subroutine   dtrd (x,n,y,ndeg,slope,avex)
      implicit real*8 (a-h,o-z)                                         
      dimension x(1) , y(1)                                            
c*****this dtrd removes the mean and/or a linear trend                  
c***** x(i)- original series   , y(i)- calculated seies                 
c***** ndeg- code word  - if -1   no change
c                         if  0   only mean removed                      
c*****                  - if  1   both mean and linear trend removed     
c$B!V%i%s%@%`%G!<%?$N!"!"!W$N(Bp288$B;2>H(B
      an = n                                                            
      s1 = 0.0                                                          
      s2 = 0.0                                                          
      slope=12345.
      if ( ndeg ) 9,11,20                                              
 9    return
   11 do 12 i=1,n                                                       
   12 s1 = s1 + x(i)                                                  
      avex = s1 / an                                                    
      do 15  i=1,n                                                      
   15 y(i) = x(i) -avex                               
      return                                                            
   20 do 22 i=1,n                                                       
      s1 = s1 + x(i)                                            
   22 s2 = s2 + s1                                                      
      avei = 0.5*(an+1.0)                                             
      avex = s1 / an                                                    
      slope = -12.0*(s2-avei*s1)/(an*(an**2-1.0))     
      do 28 i=1,n                                                       
      ai = i                                                            
   28 y(i) = x(i)-avex-slope*(ai-avei )            
c      write(6,*)'DEBUG:Subroutine(drtr):',slope,avex
      return                                                            
      end                                                               

      subroutine rmeqcm(buf)
      character*80 buf
      write(6,'(a)')buf(1:80)
      do i=1,len(buf)
         if(buf(i:i).eq.'='.or.buf(i:i).eq.'"')buf(i:i)=' '
      enddo
      write(6,'(a)')buf(1:80)
      stop

      return
      end


      SUBROUTINE SORT(X,N,Y)
C
C     PURPOSE--THIS SUBROUTINE SORTS (IN ASCENDING ORDER)
C              THE N ELEMENTS OF THE SINGLE PRECISION VECTOR X
C              AND PUTS THE RESULTING N SORTED VALUES INTO THE
C              SINGLE PRECISION VECTOR Y.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                OBSERVATIONS TO BE SORTED. 
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X. 
C     OUTPUT ARGUMENTS--Y      = THE SINGLE PRECISION VECTOR
C                                INTO WHICH THE SORTED DATA VALUES
C                                FROM X WILL BE PLACED.
C     OUTPUT--THE SINGLE PRECISION VECTOR Y
C             CONTAINING THE SORTED
C             (IN ASCENDING ORDER) VALUES
C             OF THE SINGLE PRECISION VECTOR X.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--THE DIMENSIONS OF THE VECTORS IL AND IU 
C                   (DEFINED AND USED INTERNALLY WITHIN
C                   THIS SUBROUTINE) DICTATE THE MAXIMUM
C                   ALLOWABLE VALUE OF N FOR THIS SUBROUTINE.
C                   IF IL AND IU EACH HAVE DIMENSION K,
C                   THEN N MAY NOT EXCEED 2**(K+1) - 1.
C                   FOR THIS SUBROUTINE AS WRITTEN, THE DIMENSIONS
C                   OF IL AND IU HAVE BEEN SET TO 36,
C                   THUS THE MAXIMUM ALLOWABLE VALUE OF N IS
C                   APPROXIMATELY 137 BILLION.
C                   SINCE THIS EXCEEDS THE MAXIMUM ALLOWABLE
C                   VALUE FOR AN INTEGER VARIABLE IN MANY COMPUTERS,
C                   AND SINCE A SORT OF 137 BILLION ELEMENTS
C                   IS PRESENTLY IMPRACTICAL AND UNLIKELY,
C                   THEN THERE IS NO PRACTICAL RESTRICTION
C                   ON THE MAXIMUM VALUE OF N FOR THIS SUBROUTINE.
C                   (IN LIGHT OF THE ABOVE, NO CHECK OF THE 
C                   UPPER LIMIT OF N HAS BEEN INCORPORATED
C                   INTO THIS SUBROUTINE.)
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     COMMENT--THE SMALLEST ELEMENT OF THE VECTOR X
C              WILL BE PLACED IN THE FIRST POSITION
C              OF THE VECTOR Y,
C              THE SECOND SMALLEST ELEMENT IN THE VECTOR X
C              WILL BE PLACED IN THE SECOND POSITION
C              OF THE VECTOR Y, ETC.
C     COMMENT--THE INPUT VECTOR X REMAINS UNALTERED.
C     COMMENT--IF THE ANALYST DESIRES A SORT 'IN PLACE',
C              THIS IS DONE BY HAVING THE SAME
C              OUTPUT VECTOR AS INPUT VECTOR IN THE CALLING SEQUENCE. 
C              THUS, FOR EXAMPLE, THE CALLING SEQUENCE
C              CALL SORT(X,N,X)
C              IS ALLOWABLE AND WILL RESULT IN
C              THE DESIRED 'IN-PLACE' SORT.
C     COMMENT--THE SORTING ALGORTHM USED HEREIN
C              IS THE BINARY SORT.
C              THIS ALGORTHIM IS EXTREMELY FAST AS THE
C              FOLLOWING TIME TRIALS INDICATE.
C              THESE TIME TRIALS WERE CARRIED OUT ON THE
C              UNIVAC 1108 EXEC 8 SYSTEM AT NBS
C              IN AUGUST OF 1974.
C              BY WAY OF COMPARISON, THE TIME TRIAL VALUES
C              FOR THE EASY-TO-PROGRAM BUT EXTREMELY
C              INEFFICIENT BUBBLE SORT ALGORITHM HAVE
C              ALSO BEEN INCLUDED--
C              NUMBER OF RANDOM        BINARY SORT       BUBBLE SORT
C               NUMBERS SORTED
C                N = 10                 .002 SEC          .002 SEC
C                N = 100                .011 SEC          .045 SEC
C                N = 1000               .141 SEC         4.332 SEC
C                N = 3000               .476 SEC        37.683 SEC
C                N = 10000             1.887 SEC      NOT COMPUTED
C     REFERENCES--CACM MARCH 1969, PAGE 186 (BINARY SORT ALGORITHM
C                 BY RICHARD C. SINGLETON).
C               --CACM JANUARY 1970, PAGE 54.
C               --CACM OCTOBER 1970, PAGE 624.
C               --JACM JANUARY 1961, PAGE 41.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL BUREAU OF STANDARDS
C                 WASHINGTON, D. C. 20234
C                 PHONE--301-921-2315
C     ORIGINAL VERSION--JUNE      1972. 
C     UPDATED         --NOVEMBER  1975. 
C
C---------------------------------------------------------------------
C
      implicit real*8 (a-h,o-z)                                         
      DIMENSION X(1),Y(1)
      DIMENSION IU(36),IL(36) 
C
      IPR=6
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)GOTO 50
      IF(N.EQ.1)GOTO 55
      HOLD=X(1)
      DO 60 I=2,N
      IF(X(I).NE.HOLD)GOTO 90
   60 CONTINUE
      WRITE(IPR, 9)HOLD
      DO 61 I=1,N
      Y(I)=X(I)
   61 CONTINUE
      RETURN
   50 WRITE(IPR,15) 
      WRITE(IPR,47)N
      RETURN
   55 WRITE(IPR,18) 
      Y(1)=X(1)
      RETURN
   90 CONTINUE
    9 FORMAT(1H ,108H***** NON-FATAL DIAGNOSTIC--THE FIRST  INPUT ARGUME
     1NT (A VECTOR) TO THE SORT   SUBROUTINE HAS ALL ELEMENTS = ,E15.8,6
     1H *****)
   15 FORMAT(1H , 91H***** FATAL ERROR--THE SECOND INPUT ARGUMENT TO THE
     1 SORT   SUBROUTINE IS NON-POSITIVE *****)
   18 FORMAT(1H ,100H***** NON-FATAL DIAGNOSTIC--THE SECOND INPUT ARGUME
     1NT TO THE SORT   SUBROUTINE HAS THE VALUE 1 *****)
   47 FORMAT(1H , 35H***** THE VALUE OF THE ARGUMENT IS ,I8   ,6H *****)
C
C-----START POINT-----------------------------------------------------
C
C     COPY THE VECTOR X INTO THE VECTOR Y
      DO 10 0I=1,N
      Y(I)=X(I)
  100 CONTINUE
C
C     CHECK TO SEE IF THE INPUT VECTOR IS ALREADY SORTED
C
      NM1=N-1
      DO 200 I=1,NM1
      IP1=I+1
      IF(Y(I).LE.Y(IP1))GOTO 200
      GOTO 250
  200 CONTINUE
      RETURN
  250 M=1 
      I=1 
      J=N 
  305 IF(I.GE.J)GOTO 370
  310 K=I 
      MID=(I+J)/2
      AMED=Y(MID)
      IF(Y(I).LE.AMED)GOTO 320 
      Y(MID)=Y(I)
      Y(I)=AMED
      AMED=Y(MID)
  320 L=J 
      IF(Y(J).GE.AMED)GOTO 340 
      Y(MID)=Y(J)
      Y(J)=AMED
      AMED=Y(MID)
      IF(Y(I).LE.AMED)GOTO 340 
      Y(MID)=Y(I)
      Y(I)=AMED
      AMED=Y(MID)
      GOTO 340
  330 Y(L)=Y(K)
      Y(K)=TT
  340 L=L-1
      IF(Y(L).GT.AMED)GOTO 340 
      TT=Y(L)
  350 K=K+1
      IF(Y(K).LT.AMED)GOTO 350 
      IF(K.LE.L)GOTO 330
      LMI=L-I
      JMK=J-K
      IF(LMI.LE.JMK)GOTO 360
      IL(M)=I
      IU(M)=L
      I=K 
      M=M+1
      GOTO 380
  360 IL(M)=K
      IU(M)=J
      J=L 
      M=M+1
      GOTO 380
  370 M=M-1
      IF(M.EQ.0)RETURN
      I=IL(M)
      J=IU(M)
  380 JMI=J-I
      IF(JMI.GE.11)GOTO 310
      IF(I.EQ.1)GOTO 305
      I=I-1
  390 I=I+1
      IF(I.EQ.J)GOTO 370
      AMED=Y(I+1)
      IF(Y(I).LE.AMED)GOTO 390 
      K=I 
  395 Y(K+1)=Y(K)
      K=K-1
      IF(AMED.LT.Y(K))GOTO 395 
      Y(K+1)=AMED
      GOTO 390
      END 
