c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include "PARAM.h"
      program main
      parameter(maxseis=MAXSIEIS_INC,nmax=NMAX_INC,
     +     maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      complex*16 ai,cu
      character*200 ofile,buf
      common/PARABLOCK/ai,gain,u,freql,dt,df,TT,
     +     Nconst,
     +     idrimag,idtrd,iddtwin,itype_dtwin,nseis,nblock,kpoint
     +     ,lx,lx2,lw,nfold,nwidth,nb(maxb),ne(maxb)
     +     ,idcalc(maxseis,maxseis),normal_ok(maxseis,maxb)
      common/DATABLOCK/drl(nmax),dim(nmax),cu(nmax)
      character*200 outputdir,openfile,seisfile(maxseis)
      common/FLBLOCK/seisfile,openfile,outputdir

      call rpara()
      write(7,2001)
 2001 format('#                   Data Statictics',/,
     +     '# Seis SegmentNo   Average       Variance       Trend')
c read complex time sequence 

      do iseis=1,nseis
         do ib=1,nblock
            kpoint=ne(ib)-nb(ib)+1
            open(15,file=seisfile(iseis),status='old')
            do i=1,nb(ib)-1
               read(15,*,err=999,end=999)
            enddo
            if(idrimag.eq.1)then
               do i=1,kpoint
                  read(15,*,err=999,end=999)dummy,drl(i),dim(i)
               enddo
            else if(idrimag.eq.0)then
               do i=1,kpoint
                  read(15,*,err=999,end=999)dummy,drl(i)
                  dim(i)=0.
               enddo
            endif
            close(15)
c fft
            call mkfft(iseis,ib)
            
c write spectra
            call fname(iseis,ib,10)
            open(15,file=openfile)
            do i=1,nfold
               write(15,'(4g18.8)')df*(i-1),abs(cu(i)),cu(i)
            enddo
            close(15)
         enddo
      enddo

      
c write statistics of normality tests
      write(7,2009)
      do iseis=1,nseis
         iok=0
         do ib=1,nblock
            iok=iok+normal_ok(iseis,ib)
         enddo
         write(7,2010)
     +        seisfile(iseis)(1:index(seisfile(iseis),' ')-1),
     +        iok,dble(iok)/dble(nblock)*100.d0
      enddo
      write(7,*)
 2009 format(/,'* The number of segments passing the normality test')
 2010 format(a,':',i5,' (',f5.1,' %)')

c main processing      
      call cal_cross()
      call output()

      close(7)
      stop
 999  continue
      write(6,*)'ERROR in reading file:',seisfile(iseis)
     +     (1:index(seisfile(iseis),' ')-1),' ',dummy
      write(6,*)'Check i) the data format and '
      write(6,*)'ii) if the number of data points is larger than '//
     +     'that required for the calculation.'
      write(7,*)'ERROR in reading file:',seisfile(iseis)
     +     (1:index(seisfile(iseis),' ')-1),' ',dummy
      write(7,*)'Check i) the data format and '
      write(7,*)'ii) if the number of data points is larger than '//
     +     'that required for the calculation.'
      end

      subroutine mkfft(iseis,ib)
      parameter(maxseis=MAXSIEIS_INC,maxb=MAXNSEGMENT_INC,
     +     nmax=NMAX_INC)
      implicit real*8 (a-h,o-z)                                         
      complex*16 ai,cu
      common/PARABLOCK/ai,gain,u,freql,dt,df,TT,
     +     Nconst,
     +     idrimag,idtrd,iddtwin,itype_dtwin,nseis,nblock,kpoint
     +     ,lx,lx2,lw,nfold,nwidth,nb(maxb),ne(maxb)
     +     ,idcalc(maxseis,maxseis),normal_ok(maxseis,maxb)
      common/DATABLOCK/drl(nmax),dim(nmax),cu(nmax)
      sum=0.d0
      sum2=0.d0
      sumim=0.d0
      sum2im=0.d0
      do i=1,kpoint
         sum=sum+drl(i)
         sum2=sum2+drl(i)*drl(i)
         sumim=sumim+dim(i)
         sum2im=sum2im+dim(i)*dim(i)
      enddo
      sum=sum/dble(kpoint)
      sum2=(sum2-dble(kpoint)*sum*sum)/(dble(kpoint)-1)
      sumim=sumim/dble(kpoint)
      sum2im=(sum2im-dble(kpoint)*sumim*sumim)/(dble(kpoint)-1)
c     
c for the real part      
      call dtrd(drl,kpoint,drl,idtrd,slope,avex) !Remove Trend
      write(7,2005)iseis,ib,avex,sum2,slope
 2005 format('#',i5,1x,i5,3x,3g15.6,'(real)')

c-----------------------
c added on 20151112
c-----------------------
c     calculation of moments for the real part
      call moment(kpoint,drl, sumu,dummy,sumu2,askewu,akrtu) 

c     Jarque-Bera statistics
      ajbu=dble(kpoint)*(askewu*askewu/6.d0+akrtu*akrtu/24.d0)

c     Jarque-Bera statistics improved by Nakagawa (2009)
      ajbdu=askewu*askewu/6.d0+(akrtu+3.d0)*(akrtu+3.d0)/24.d0

      call jbtest(1,2,kpoint,ajbu, idok_jb)  ! 99% level
      call jbtest(2,2,kpoint,ajbdu,idok_jbd) ! 99% level
      normal_ok(iseis,ib)=idok_jbd

      write(7,2015)iseis,ib,sumu,sumu2,askewu,akrtu,
     +     ajbu,idok_jb,ajbdu,idok_jbd
 2015 format('#',i5,1x,i5,3x,2g13.4,2f11.4,f15.4,i3,f15.4,i3,
     +     ' (ave/var/skew/kurt/JB/JBD)')
c-----------------------

c for the imaginary part      
      call dtrd(dim,kpoint,dim,idtrd,slope,avex) !Remove Trend
      write(7,2007)iseis,ib,avex,sum2im,slope
 2007 format('#',i5,1x,i5,3x,3g15.6,'(imaginary)')

      
c     DataWindow(TAPER)
      if(iddtwin.eq.1)then
         call dtwin(drl,drl,kpoint,nmax,nwidth,itype_dtwin) 
         call dtwin(dim,dim,kpoint,nmax,nwidth,itype_dtwin) 
      endif

c     Zero padding
      do it=kpoint+1,lx         !Zero
         drl(it)=0.d0
         dim(it)=0.d0
      enddo

      ipoint=0
      do it=1,lx                               
         ipoint=ipoint+1
         cu(ipoint)=dcmplx(drl(it),dim(it))
      enddo

      do ite=1,lx
         ipoint=ipoint+1
         cu(ipoint)=dcmplx(0.d0,0.d0)  
      enddo

      call fast(lx2,cu,nmax,-1)    
      
      do it=1,nfold
         cu(it)=cu(it)*dt
      enddo
      return
      end
      
      subroutine cal_cross()
      parameter(maxseis=MAXSIEIS_INC,nmax=NMAX_INC,
     +     maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      complex*16 ai,cu,cssw(maxseis,maxseis,nmax),cs,css
      dimension ssw2(maxseis,maxseis,nmax)
      common/PARABLOCK/ai,gain,u,freql,dt,df,TT,
     +     Nconst,
     +     idrimag,idtrd,iddtwin,itype_dtwin,nseis,nblock,kpoint
     +     ,lx,lx2,lw,nfold,nwidth,nb(maxb),ne(maxb)
     +     ,idcalc(maxseis,maxseis),normal_ok(maxseis,maxb)
      common/DATABLOCK/drl(nmax),dim(nmax),cu(nmax)
      common/CRS/ss_std(maxseis,maxseis,nmax),
     +     cs(maxseis,nmax),css(maxseis,maxseis,nmax)   
      character*200 outputdir,openfile,seisfile(maxseis)
      common/FLBLOCK/seisfile,openfile,outputdir

      do iseis=1,nseis
         do jseis=1,nseis
            do i=1,nfold
               cssw(iseis,jseis,i)=(0.d0,0.d0)
               ssw2(iseis,jseis,i)=0.d0
            enddo
         enddo
      enddo

c    Read Fourier Spectra
      ib=1
 500  continue
      do iseis=1,nseis
         call fname(iseis,ib,10)
         open(20,file=openfile)
         do i=1,nfold
            read(20,*)dummy1,dummy2,dr,di
            cs(iseis,i)=dcmplx(dr,di)
         enddo
         close(20)
      enddo

      if(freql.lt.0.d0)then
c         write(6,'(a)')'DEBUG: mkcross() called.'
         call mkcross()
      else
c         write(6,'(a)')'DEBUG: mkcross_smthfd() called.'
         call mkcross_smthfd()
      endif
      
      do iseis=1,nseis
         do jseis=1,nseis
            if(idcalc(iseis,jseis).eq.1)then
               do i=1,nfold
                  cssw(iseis,jseis,i)=cssw(iseis,jseis,i)+
     +                 css(iseis,jseis,i)
                  ssw2(iseis,jseis,i)=ssw2(iseis,jseis,i)+
     +                 css(iseis,jseis,i)*dconjg(css(iseis,jseis,i))
               enddo
            endif
         enddo
      enddo
      if(ib.le.nblock-1)then
         ib=ib+1
         goto 500
      else
         do iseis=1,nseis
            do jseis=1,nseis
               if(idcalc(iseis,jseis).eq.1)then
                  do i=1,nfold
                     css(iseis,jseis,i)=
     +                    cssw(iseis,jseis,i)/dble(nblock)
                  enddo
               endif
            enddo
         enddo
c------------------------------------------------------------
         if(nblock.gt.1)then
            do iseis=1,nseis
               do jseis=1,nseis
                  if(idcalc(iseis,jseis).eq.1)then
                     do i=1,nfold
                        ss_std(iseis,jseis,i)=
     +                       sqrt((ssw2(iseis,jseis,i)
     +                       -abs(dble(nblock)*css(iseis,jseis,i)
     +                       *dconjg(css(iseis,jseis,i))))
     +                       /dble(nblock-1))
                     enddo
                  endif
               enddo
            enddo
         endif
c------------------------------------------------------------
      endif

c delete temporaly files
      do iseis=1,nseis
         do ib=1,nblock
            call fname(iseis,ib,10)
            open(15,file=openfile)
            close(15,status='delete')
c            close(15)
         enddo
      enddo
      return
      end

      subroutine mkcross()
      parameter(maxseis=MAXSIEIS_INC,nmax=NMAX_INC,
     +     maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      complex*16 cssw(maxseis,maxseis,nmax),cs,css,ai,cu
      common/PARABLOCK/ai,gain,u,freql,dt,df,TT,
     +     Nconst,
     +     idrimag,idtrd,iddtwin,itype_dtwin,nseis,nblock,kpoint
     +     ,lx,lx2,lw,nfold,nwidth,nb(maxb),ne(maxb)
     +     ,idcalc(maxseis,maxseis),normal_ok(maxseis,maxb)
      common/DATABLOCK/drl(nmax),dim(nmax),cu(nmax)
      common/CRS/ss_std(maxseis,maxseis,nmax),
     +     cs(maxseis,nmax),css(maxseis,maxseis,nmax)   

      do iseis=1,nseis
         do jseis=1,nseis
            if(idcalc(iseis,jseis).eq.1)then
            do i=1,nfold
               cssw(iseis,jseis,i)=cs(iseis,i)*dconjg(cs(jseis,i))
            enddo
            do i=1,nfold
               css(iseis,jseis,i)=(0.d0,0.d0)
               do j=-lw,lw
                  udf=1.570796d0*u*df*dble(j)
                  if(i+j.ge.1.and.i+j.le.nfold)then
                     css(iseis,jseis,i)=
     +                    css(iseis,jseis,i)
     +                    +spw(udf)*cssw(iseis,jseis,i+j)
                  else if( i+j.gt.nfold)then
                     css(iseis,jseis,i)=
     +                    css(iseis,jseis,i)
     +                    +spw(udf)*cssw(iseis,jseis,2*nfold-i-j)
                  else
                     css(iseis,jseis,i)=
     +                    css(iseis,jseis,i)
     +                    +spw(udf)*cssw(iseis,jseis,2-i-j)
                  endif
               enddo
               css(iseis,jseis,i)=gain*css(iseis,jseis,i)
            enddo
            endif
         enddo
      enddo
      return
      end

      subroutine mkcross_smthfd()
      parameter(maxseis=MAXSIEIS_INC,nmax=NMAX_INC,
     +     maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      complex*16 cssw(maxseis,maxseis,nmax),cs,css,ai,cu
      common/PARABLOCK/ai,gain,u,freql,dt,df,TT,
     +     Nconst,
     +     idrimag,idtrd,iddtwin,itype_dtwin,nseis,nblock,kpoint
     +     ,lx,lx2,lw,nfold,nwidth,nb(maxb),ne(maxb)
     +     ,idcalc(maxseis,maxseis),normal_ok(maxseis,maxb)
      common/DATABLOCK/drl(nmax),dim(nmax),cu(nmax)
      common/CRS/ss_std(maxseis,maxseis,nmax),
     +     cs(maxseis,nmax),css(maxseis,maxseis,nmax)   
c
      weight=1.d0
c
      do iseis=1,nseis
         do jseis=1,nseis
            if(idcalc(iseis,jseis).eq.1)then
            do i=1,nfold
               cssw(iseis,jseis,i)=cs(iseis,i)*dconjg(cs(jseis,i))
            enddo
            do i=1,nfold
               css(iseis,jseis,i)=(0.d0,0.d0)
c------------------------------------------------------               
c <Spectral windowing by a simple arithmetic average>
c A window width of N points assuemd 
c  freq =< freql N=Nconst            (lwfd=(Nconst-1)/2)
c  freq  > freql N=Nconst*freq/freql (lwfd=(Nconst*freq/freql-1)/2)
c                        
c               |     * 
c     N [pints] |    *   
c               |   *    
c         Nconst|***     
c               |+  |    
c               +---+----+--
c                 freql   
c                freq[Hz]         
c
c   Table for Nconst=3,freql=2
c     freq[Hz]| 0.5 1 2  3  6  10 20 30
c        N    |  3  3 3  5  7  11 21 31
               freq=df*(i-1)
               freqr=freq/freql
               if(freqr.lt.1.d0)then
                  lwfd=(Nconst-1)/2
               else
                  lwfd=int(Nconst*freqr-0.5d0)/2
               endif
c------------------------------------------------------               
               kk=0
               do j=-lwfd,lwfd
                  if(i+j.ge.1.and.i+j.le.nfold)then
                     css(iseis,jseis,i)=
     +                    css(iseis,jseis,i)
     +                    +weight*cssw(iseis,jseis,i+j)
                     kk=kk+1
                  else if( i+j.gt.nfold)then
                     css(iseis,jseis,i)=
     +                    css(iseis,jseis,i)
     +                    +weight*cssw(iseis,jseis,2*nfold-i-j)
                     kk=kk+1
                  else
                     css(iseis,jseis,i)=
     +                    css(iseis,jseis,i)
     +                    +weight*cssw(iseis,jseis,2-i-j)
                     kk=kk+1
                  endif
               enddo
               css(iseis,jseis,i)=gain*css(iseis,jseis,i)/dble(kk)
            enddo
            endif
         enddo
      enddo
      return
      end

      subroutine rpara()
      parameter(maxseis=MAXSIEIS_INC,nmax=NMAX_INC,
     +     maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      complex*16 ai
      common/PARABLOCK/ai,gain,u,freql,dt,df,TT,
     +     Nconst,
     +     idrimag,idtrd,iddtwin,itype_dtwin,nseis,nblock,kpoint
     +     ,lx,lx2,lw,nfold,nwidth,nb(maxb),ne(maxb)
     +     ,idcalc(maxseis,maxseis),normal_ok(maxseis,maxb)
      character*200 outputdir,openfile,seisfile(maxseis),
     +     logfile
      common/FLBLOCK/seisfile,openfile,outputdir
      dimension dummy(nmax)
      dimension dummyf(10),dummyB(10),idummyn(10)
      
c ----------------------------------------------------------------------
c  Initialize
c ----------------------------------------------------------------------
      ai=(0.,1.)
      idtrd=1 
      iddtwin=1

c      tpend=0.5d0  ! maximum width of tappering
c      tpend=0.05d0 
c      tpend=0.1d0
c      tpend=0.d0  ! equivalent to no tapparing 

c     This option was addded to check the effects of zero-padding (20151014)
c     0 no zero padding
c     1 zero padding 
c      idzeropad=1
c      idzeropad=0

c ----------------------------------------------------------------------
c  Read Parameters
c ----------------------------------------------------------------------
      read(5,*)idrimag
      read(5,'(a)')logfile
      open(7,file=logfile,status='new',err=999)

      if(idrimag.eq.1)then
         write(6,'(a)')'NOICE:idrimag=1, read columns 1-3'
         write(6,'(a)')
     +        '[column 1: time; 2: real part; 3: imaginary part]'
      else if(idrimag.eq.0)then
         write(6,'(a,i5,a)')'NOICE:idrimag=',idrimag,
     +        ' read only columns 1 and 2'
         write(6,'(a)')'No other columns are read'
      else
         write(6,'(a,i5)')'ERROR in idrimag',idrimag
         write(6,'(a)')'idrimag should be set to 1 or 0. STOP'
         write(7,'(a,i5)')'ERROR in idrimag',idrimag
         write(7,'(a)')'idrimag should be set to 1 or 0. STOP'
         stop
      endif
      read(5,'(a)')outputdir
      write(6,'(a)')'OUTPUT DIR: '//outputdir(1:index(outputdir,' ')-1)
      write(7,'(a)')'OUTPUT DIR: '//outputdir(1:index(outputdir,' ')-1)
      read(5,*)nseis
      write(6,*)'No. of Seismograms:',nseis
      write(7,*)'No. of Seismograms:',nseis

      if(nseis.gt.maxseis)then
         write(6,'(a,2i5)')'ERROR:nseis (the number of '//
     +        'seismographs) > maxseis',nseis,maxseis
         write(6,'(a)')'Set an appropriate value for MAXSIEIS_INC '//
     +        'in PARAM.h and compile again in src directory.'
         write(7,'(a,2i5)')'ERROR:nseis (the number of '//
     +        'seismographs) > maxseis',nseis,maxseis
         write(7,'(a)')'Set an appropriate value for MAXSIEIS_INC '//
     +        'in PARAM.h and compile again in src directory.'
         stop
      else if(nseis.eq.0)then
         write(6,'(a,2i5)')'ERROR:nseis (number of seismographs)'//
     +        ' equals 0. Nothing can be done'
         write(7,'(a,2i5)')'ERROR:nseis (number of seismographs)'//
     +        ' equals 0. Nothing can be done'
         stop
      endif

      do i=1,nseis
         read(5,'(a)')seisfile(i)
         seisfile(i)=seisfile(i)(1:index(seisfile(i),' ')-1)
         write(6,'(a,i2,a)')'DATAFILE ',i,') '//seisfile(i)
     +        (1:index(seisfile(i),' ')-1)
         write(7,'(a,i2,a)')'DATAFILE ',i,') '//seisfile(i)
     +        (1:index(seisfile(i),' ')-1)
      enddo
      write(6,*)
      write(6,'(a)')
     +     'Cross-spectral density calculations (1:yes; 2: no)'
      write(6,'(a,100i3)')'   |',(jseis,jseis=1,nseis)
      write(6,'(100a)')   '----',('---',jseis=1,nseis)
      write(7,*)
      write(7,'(a)')
     +     'Cross-spectral density calculations (1:yes; 2: no)'
      write(7,'(a,100i3)')'   |',(jseis,jseis=1,nseis)
      write(7,'(100a)')   '----',('---',jseis=1,nseis)
      do iseis=1,nseis
         read(5,*)(idcalc(iseis,jseis),jseis=1,nseis)
         write(6,'(i3,a,100i3)')iseis,'|',
     +        (idcalc(iseis,jseis),jseis=1,nseis)
         write(7,'(i3,a,100i3)')iseis,'|',
     +        (idcalc(iseis,jseis),jseis=1,nseis)
      enddo
      write(6,*)
      write(7,*)
c
      read(5,*)idzeropad
      read(5,*)itype_dtwin
      read(5,*)tpend
c                    An effective bandwidth given as [-smb/2,smb/2]
      read(5,*)smb              ! band width (not half width) for smoothing 
      lw=0    ! used when band width is set to 0
c
      read(5,*)nblock
      read(5,*)duration
      read(5,*)dt

      if(nblock.le.0)then
         write(6,'(a,2i5)')'ERROR:nblock (the number of data '//
     +        'segments) equals 0. Nothing can be done'
         write(7,'(a,2i5)')'ERROR:nblock (the number of data '//
     +        'segments) equals 0. Nothing can be done'
         stop
      else if(nblock.gt.maxb)then
         write(7,'(a,2i5)')'ERROR:nblock (the number of data '//
     +        'segments) > maxb',nblock,maxb
         write(7,'(a)')'You should do the following to continue.'
         write(7,'(a)')'i)   Decrease the number of data segments'//
     +        ' (possibly by shortening the data length)'
         write(7,*)'[the number of segments for averaging ',
     +        'should be smaller than ',maxb,']'
         write(7,'(a)')'ii)  Edit the parameter MAXNSEGMENT_INC'//
     +        ' in src/PARAM.h and recompile again.'
         write(7,*)'[MAXNSEGMENT_INC should be larger than ',
     +        nblock,']'
         stop
      endif

      if(duration.le.0)then
         write(6,'(a,2i5)')'ERROR:the durtaion of the data segment'//
     +        ' set to be 0 or negative. Nothing can be done'
         write(7,'(a,2i5)')'ERROR:the durtaion of the data segment'//
     +        ' set to be 0 or negative. Nothing can be done'
         stop
      endif

      if(dt.le.0)then
         write(6,'(a,2i5)')'ERROR:the time interval of the waveform'//
     +        ' set to be 0 or negative. Nothing can be done'
         write(7,'(a,2i5)')'ERROR:the time interval of the waveform'//
     +        ' set to be 0 or negative. Nothing can be done'
         stop
      endif

      kpoint=int(duration/dt+0.5)

      if(kpoint.le.0)then
         write(6,'(a,2i5)')'ERROR:(number of data points in one'//
     +        ' segment) =(the duration of the data segment)/(the'//
     +        ' time interval of the waveform) is 0 or negative.'//
     +        ' Nothing can be done'
         write(7,'(a,2i5)')'ERROR:(number of data points in one'//
     +        ' segment) =(the duration of the data segment)/(the'//
     +        ' time interval of the waveform) is 0 or negative.'//
     +        ' Nothing can be done'
         stop
      endif

      ip=int(log10(float(kpoint))/log10(2.))
      lx=2**ip  ! 2Τ٤ʾڤΤ

      if(idzeropad.eq.0)then 
         lx2=lx
      else
         if(lx.lt.kpoint)then
            ip=ip+1 
            lx=2**ip  ! 2Τ٤ʲϣͤ
         endif
         lx2=2*lx     ! ˡܤĹǣͤ
      endif

      if(lx2.gt.nmax)then
         write(6,'(a,2i5)')'ERROR:lx2 > nmax',lx2,nmax

         write(7,'(a,2i5)')'ERROR:lx2 > nmax',lx2,nmax
         write(7,'(a)')'You should do the following to continue.'
         write(7,'(a)')'i)   Decrease duration/dt.'
         write(7,*)    '[duration/dt should be smaller than ',
     +   int(10.**(log10(2.)*int(log10(float(nmax/2))/log10(2.)+0.5))),
     +        ']'
         write(7,'(a)')'ii)  Edit the parameter NMAX_INC'//
     +        ' in src/PARAM.h and recompile again.'
         write(7,*)    '[NMAX_INC should be larger than ',lx2,']'

         stop
      endif
      nfold=lx2/2+1
c      nfold=lx+1
      TT=lx2*dt
      df=1.d0/TT
      PRfac=duration/TT

c ----------------------------------------------------------------------
c  Write Prameters
c ----------------------------------------------------------------------
      do i=1,nblock
         read(5,*)tstart
         nb(i)=int(tstart/dt+0.5)+1
         ne(i)=nb(i)+kpoint-1
         write(7,2021)i,nb(i),ne(i),kpoint,lx2,
     +        dt*(nb(i)-1),dt*ne(i)
 2021    format('Segment ',i3,':',i6,'-',i6,
     +        ' pts (Total ',i7,' pts [but use ',i7,'])',
     +        f8.3,' -',f8.3,' s')
      enddo
      write(6,2013)nblock,duration
      write(6,2015)dt
      write(6,2501)TT,lx2,PRfac,df,(nfold-1)*df
      write(7,2013)nblock,duration
      write(7,2015)dt
      write(7,2501)TT,lx2,PRfac,df,(nfold-1)*df
 2013 format('No. of segments: ',
     +     i5,/,'Data segment duration:',f7.3,' s')
 2015 format('dt           :',f14.8,' s')
 2501 format('Total duration (zero-padded):',f9.3,'s (',i7,' pts)',/,
     +     'Ratio of data length to total length (zero-padded):',
     +     f7.3,/,
     +     '(Power reduction is corrected based on this value)',/,
     +     'Frequency interval:',g9.3,' Hz',/,
     +     'Nyquist frequency :',g9.3,' Hz')

c max. frequency set to shorten the calculation time
c #define MAXIMUM_FREQUENCY 60. 
c      if((nfold-1)*df.gt.MAXIMUM_FREQUENCY)then
c         nfold_old=nfold
c         nfold=int(MAXIMUM_FREQUENCY/df+0.5+1)
c         write(6,*)'CAUSION: Now nfold value is ',nfold_old
c         write(6,*)'* Corresponding Nyquest frequency is ',
c     +        (nfold_old-1)*df
c         write(6,*)'* But Max. Freuency in PARAM.h is ',
c     +        MAXIMUM_FREQUENCY
c         write(6,*)'* (nfold-1)*df is reset to '  ,(nfold-1)*df
c         write(6,*)'*  nfold       is reset to '  , nfold
c         write(6,*)'* Edit PARAM.h and Comile Again, ',
c     +        'if you want to change MAX. Freuency.'
cc
c         write(7,*)'CAUSION: Now nfold value is ',nfold_old
c         write(7,*)'* Corresponding Nyquest frequency is ',
c     +        (nfold_old-1)*df
c         write(7,*)'* But Max. Freuency in PARAM.h is ',
c     +        MAXIMUM_FREQUENCY
c         write(7,*)'* (nfold-1)*df is reset to '  ,(nfold-1)*df
c         write(7,*)'*  nfold       is reset to '  , nfold
c         write(7,*)'* Edit PARAM.h and Comile Again, ',
c     +        'if you want to change MAX. Freuency.'
c      endif


c ----------------------------------------------------------------------
c
      PTfac=1.d0
      if(iddtwin.eq.1)then
         nwidth=int(kpoint*tpend+0.5)

c----------------------------------------------
         write(6,2601)tpend,nwidth
         write(7,2601)tpend,nwidth
 2601    format('Use data window  [Data window with tapering ratio: '
     +        ,f5.3,' (',i5,' pts)]')

         ovlpratio=0.d0
         if(nblock.gt.1)then
            do i=2,nblock
               if(ne(i-1).lt.nb(i))then
                  ovlpratio0=0.d0
               else
                  ovlpratio0=dble(ne(i-1)-nb(i))/dble(kpoint)
               endif
               ovlpratio=ovlpratio+ovlpratio0
            enddo
            ovlpratio=ovlpratio/dble(nblock-1)
         endif
         
         kovlp=int(kpoint*ovlpratio)

         call caledf(itype_dtwin,
     +        nblock,kpoint,nwidth,lx2,kovlp,PTfac,fnfree)
c         write(6,*)'DEBUG:PTfac  ',PTfac
c         write(6,*)'DEBUG:fnfree ',fnfree

c----------------------------------------------
c    the variance due to taperring (akappab is defined in Koopmans 1974, p.302)
         akappab=(1.d0-8.d0/5.d0*tpend)/(1.d0-4.d0/3.d0*tpend)**2

         write(6,2603)akappab,PTfac,ovlpratio
         write(7,2603)akappab,PTfac,ovlpratio
 2603    format(
     +        'kappa_b :',f6.1,/,
     +        'Ratio of tapered power to raw power:',f6.2,/,
     +        '(Power reduction is corrected based on this value)',/,
     +        'Overlapping ratio of adjacent segments: ',f6.2)
      endif
c
c---------------------------------------------------------------------- 
c  For smoothing 
c---------------------------------------------------------------------- 
      idsmt=1
      freql=-1.d0
      if(idsmt.eq.1)then

         if(smb.gt.10000.d0)then
c     when smb greater than 10000, frequency dependent spectral window
c     will be used with a constant smb-10000*x [Hz]            
c     (actually, mkcross_smthfd() will be called)
c                                                    (added on 20160212)
            facu=1.d0
            lwfd0=int(smb/10000)
c            Nconst=2*lwfd0+1
            Nconst=2*(lwfd0-1)+1 ! modified on 20170823 to include the case of Nconst=1
            freql=smb-lwfd0*10000.d0
            
         else if(lw.eq.0 .and. smb.eq.0.d0)then
c  ǽ餫smb򣰤ꤷ硣

c            write(6,*)'Error: both lw and smb equal 0.'
c            write(7,*)'Error: both lw and smb equal 0.'
c            stop
            u=0.d0              ! spw will not be applied
c                       (function called but only to factor unity).

c------------------------------------------------------------            
c       facu=0.5d0*df
            facu=1.d0  ! corrected so that the integral of the wondow function squared equals unity (20151014)
c------------------------------------------------------------            

         else if(lw.eq.0)then
c For a normal setting (smb is effective; lw will be updated adjusted to smb)
c  Ͽư...p.102 ɽ6-1֥ڥȥ륦ɥΥХפu׻
c The Parzen window is defined as W(f)=3/4*u*(sin(pi*u*f/2)/(pi*u*f/2))**4
c                               where u=280/151/smb
            u=1.854305d0/smb
c     Numerical calculation will be done in the frequency range of [-2/u,2/u]
c     (i.e.,[-lw,lw]; 2lw+1 data points are used for the spectral window)
            lw=int(2.d0/(u*df))  

            facu=0.75d0*u*df

            if(lw.eq.0)then
               write(6,*)'ERROR: smoothband is set to ',smb

               write(7,*)'ERROR: smoothband is set to ',smb
               write(7,*)'* smoothband must be larger equal to ',
     +         df, ' or 0.'
               write(7,*)
     +       '* set smoothband=0, if you do not use spectral window.'
               write(7,*)'STOP.'
               stop
            endif

         else

            write(6,*)'ERROR: entering a program line',
     +           ' that has not been used (estspec.F).'
            write(6,*)'STOP'
            stop
            
            u=2.d0/(dble(lw)*df)
            smb=1.854305d0/u
            facu=0.75d0*u*df

         endif                  !          if(smb.gt.10000.d0)then

         if(smb.gt.10000.d0)then
            ndum=7
            dummyf(1)=0.1d0
            dummyf(2)=0.5d0
            dummyf(3)=1.d0
            dummyf(4)=2.d0
            dummyf(5)=5.d0
            dummyf(6)=10.d0
            dummyf(7)=20.d0
            do i=1,ndum
               freqr=dummyf(i)/freql
               if(freqr.lt.1.d0)then
                  lwfd=(Nconst-1)/2
               else
                  lwfd=int(Nconst*freqr-0.5d0)/2
               endif
               idummyn(i)=lwfd*2+1
               dummyb(i)=(lwfd*2+1)*df
            enddo
            write(6,3002)freql,Nconst,lwfd0-1
            write(7,3002)freql,Nconst,lwfd0-1
 3002       format(
     +      'Use frequency-dependent spectral window [freql: ',
     +      f5.2,' Hz Nconst:',i4,' (=',i4,' x 2 + 1)]')
            write(6,'(a)')'------------------------------'
            write(6,'(a,7f7.1)')'F [Hz]: ',(dummyf(i),i=1,ndum)
            write(6,'(a,7i7)')  'PTS   : ',(idummyn(i),i=1,ndum)
            write(6,'(a,7f7.3)')'BW[Hz]: ',(dummyb(i),i=1,ndum)
            write(6,'(a)')'------------------------------'
         else
            write(6,3001)smb,int(smb/df+0.5)+1,smb*duration
            write(7,3001)smb,int(smb/df+0.5)+1,smb*duration
 3001       format(
     +      'Use spectral window [Parzen window with band width: ',
     +      f8.5,' Hz (Total ',i4,' pts; ',f4.1,' pts effective)]')
         endif
         
         gain=facu/(PRfac*PTfac)

      endif                     !       if(idsmt.eq.1)then

      
c---------------------------------------------------------------------- 
c  Theoretical calculation of the degrees of freeedom and stochastic errors
c---------------------------------------------------------------------- 
      if(freql.lt.0)then
c Correcting the effects of data widnow taper (Koopman, 1974, p.302)
      eqnblock=fnfree/2.d0/akappab
      
      if(smb.gt.0.d0.and.PRfac.gt.0.d0)then
c         eqnblock=eqnblock*smb*duration
         eqnblock=eqnblock*(smb/df*PRfac)

c     smb*duration: (equivalent bandwidth)/(effective df)
c     smb*duration: (equivalent bandwidth)/df*(correction for zeropadding)
c         write(6,*)'DEBUG:smb*duration         ',smb*duration
c         write(6,*)'DEBUG:smb/df*PRfac         ',smb/df*PRfac
c         write(6,*)'DEBUG:smb/df*PRfac/akappab ',smb/df*PRfac/akappab
      endif

c     the degrees of freedom updated         
      fnfree=eqnblock*2.d0
      
c      write(6,*)'DEBUG:eqnblock ',eqnblock
c      write(6,*)'DEBUG:fnfree   ',fnfree
      
      estd=dsqrt(1.d0/eqnblock)
      if(eqnblock.gt.2)then
         estsprhv=dsqrt(
     +        (3.d0*eqnblock-1.d0)/
     +        (2.d0*eqnblock*(eqnblock-2.d0)))
         estsprhv_h1=dsqrt(
     +        (2.d0*eqnblock-1.d0)/(eqnblock*(eqnblock-2.d0)))
         estsprcca=estsprhv_h1
      else
         estsprhv=0.d0
         estsprhv_h1=0.d0
         estsprcca=0.d0
      endif
      estpvcca=estsprcca/2.d0

      write(6,5901)fnfree,eqnblock,estd,
     +     estsprhv,estsprhv_h1,estsprcca,estpvcca
      write(7,5901)fnfree,eqnblock,estd,
     +     estsprhv,estsprhv_h1,estsprcca,estpvcca
 5901 format(
     +'Resulting degrees of freedom : ',f8.1,/,
     +'Equivalent number of segments: ',f8.1,/,
     +     ' (the effects of taper, zero padding &',
     +     'overlapping taken into account)',/,
     +'Expected CV  of PSD          : ',f12.6,/,
     +'              SPRHV[h2comp]  : ',f12.6,/,
     +'              SPRHV[h1comp]  : ',f12.6,/,
     +'              SPRCCA         : ',f12.6,/,
     +'Phase vel. by CCA(wl>>r)     : ',f12.6)
      if(abs(fnfree-2.).lt.0.01)then
         write(6,5902)
         write(7,5902)
 5902    format('WARNING: Neither smoothing nor block',
     +    ' averaging done.')
      endif                     ! if(abs(fnfree-2.).lt.0.01)then
      endif                     ! if(freql.lt.0)then
c----------------------------------------------------------------------
      return

 999  write(6,*)'ERROR in running program estspec().'
      write(6,*)
     +     'Cannnot open logfile:'//logfile(1:index(logfile,' ')-1)
      write(6,*)'STOP'

      stop
      end

      subroutine output()
      parameter(maxseis=MAXSIEIS_INC,nmax=NMAX_INC,
     +     maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      complex*16 ai,cs,css
      common/PARABLOCK/ai,gain,u,freql,dt,df,TT,
     +     Nconst,
     +     idrimag,idtrd,iddtwin,itype_dtwin,nseis,nblock,kpoint
     +     ,lx,lx2,lw,nfold,nwidth,nb(maxb),ne(maxb)
     +     ,idcalc(maxseis,maxseis),normal_ok(maxseis,maxb)
      common/CRS/ss_std(maxseis,maxseis,nmax),
     +     cs(maxseis,nmax),css(maxseis,maxseis,nmax)   
      character*200 outputdir,openfile,seisfile(maxseis)
      common/FLBLOCK/seisfile,openfile,outputdir

      do iseis=1,nseis
         do jseis=1,nseis
            if(idcalc(iseis,jseis).eq.1)then
            call fname(iseis,jseis,20)            
            write(6,'(a,a)')'OUTPUT (CSD): ',
     +           openfile(1:index(openfile,' ')-1)
            write(7,'(a,a)')'OUTPUT (CSD): ',
     +           openfile(1:index(openfile,' ')-1)
            open(20,file=openfile)
c one-sided specrum 
            write(20,'(4g20.8)')0.d0
     +           ,dreal(css(iseis,jseis,1))/TT
     +           ,dimag(css(iseis,jseis,1))/TT
     +           ,ss_std(iseis,jseis,1)/TT
            do i=2,nfold-1
               write(20,'(4g20.8)')df*(i-1)
     +              ,2.d0*dreal(css(iseis,jseis,i))/TT
     +              ,2.d0*dimag(css(iseis,jseis,i))/TT
     +              ,ss_std(iseis,jseis,i)/TT
            enddo
            write(20,'(4g20.8)')df*(nfold-1)
     +           ,dreal(css(iseis,jseis,nfold))/TT
     +           ,dimag(css(iseis,jseis,nfold))/TT
     +           ,ss_std(iseis,jseis,nfold)/TT
            close(20)
            endif
         enddo
      enddo
      return
      end

      subroutine fname(iseis,ib,id)
      parameter(maxseis=MAXSIEIS_INC)
      implicit real*8 (a-h,o-z)                                         
      character*10 cb,cseis
      character*200 outputdir,openfile,seisfile(maxseis)
      common/FLBLOCK/seisfile,openfile,outputdir

      write(cseis,'(i10)')iseis
      do i=1,len(cseis)
         if(cseis(i:i).ne.' ')goto 10
      enddo
 10   continue
      icseis=i

      write(cb,'(i10)')ib
      do i=1,len(cb)
         if(cb(i:i).ne.' ')goto 20
      enddo
 20   continue
      icb=i
c--------------------------------------------------
      if(     id.eq.10)then
         openfile=seisfile(iseis)(1:index(seisfile(iseis),' ')-1)
     +        //'_SEG'//cb(icb:len(cb))//'.tmp'
      else if(id.eq.20)then
         do i1=len(seisfile(iseis)),1,-1
            if(seisfile(iseis)(i1:i1).eq.'/')goto 21
         enddo
 21      continue
         do i2=len(seisfile(iseis)),1,-1
            if(seisfile(iseis)(i2:i2+1).eq.'.d')goto 22
         enddo
 22      continue
         do i3=len(seisfile(ib)),1,-1
            if(seisfile(ib)(i3:i3).eq.'/')goto 23
         enddo
 23      continue
         openfile=outputdir(1:index(outputdir,' ')-1)//'/'//
     +        seisfile(iseis)(i1+1:i2-1)//'_'//
     +        seisfile(ib)(i3+1:index(seisfile(ib),' ')-1)
      endif
      return
      end

      subroutine   dtrd (x,n,y,ndeg,slope,avex)
      implicit real*8 (a-h,o-z)                                         
      dimension  x(1) , y(1)                                            
c*****this dtrd removes the mean and/or a linear trend                  
c***** x(i)- original series   , y(i)- calculated seies                 
c***** ndeg- code word  - if -1   no change
c                         if  0   only mean removed                      
c*****                  - if  1   both mean and linear trend removed     
c֥ǡΡפp288
      an = n                                                            
      s1 = 0.0                                                          
      s2 = 0.0                                                          
      slope=12345.
      if ( ndeg ) 9,11,20                                              
 9    return
   11 do 12 i=1,n                                                       
   12 s1 = s1 + x(i)                                                  
      avex = s1 / an                                                    
      do 15  i=1,n                                                      
   15 y(i) = x(i) -avex                               
      return                                                            
   20 do 22 i=1,n                                                       
      s1 = s1 + x(i)                                            
   22 s2 = s2 + s1                                                      
      avei = 0.5*(an+1.0)                                             
      avex = s1 / an                                                    
      slope = -12.0*(s2-avei*s1)/(an*(an**2-1.0))     
      do 28 i=1,n                                                       
      ai = i                                                            
   28 y(i) = x(i)-avex-slope*(ai-avei )            
c      write(6,*)'DEBUG:Subroutine(drtr):',slope,avex
      return                                                            
      end                                                               

      subroutine dtwin(x,y,n,nmax,nwidth,itype_dtwin)
      implicit real*8 (a-h,o-z)                                               
      dimension x(nmax),y(nmax)
      if(     itype_dtwin.eq.1)then
         call dtwin_w1(x,y,n,nmax,nwidth)
      else if(itype_dtwin.eq.2)then
         call dtwin_w2(x,y,n,nmax,nwidth)
      else if(itype_dtwin.eq.3)then
         call dtwin_han1(x,y,n,nmax,nwidth)
      else
         write(6,*)'ERROR dtwin(): invalid type: ',itype_dtwin
         stop
      endif
      return
      end
      
      subroutine dtwin_han1(x,y,n,nmax,nwidth)
c Hanning (cos) window
      implicit real*8 (a-h,o-z)                                               
      dimension x(nmax),y(nmax)
      data idcalled/0/
      if(idcalled.eq.0)then
         write(6,'(a)')'Type of tapering window : Hanning'
         idcalled=1
      endif
      pi=acos(-1.d0)
      if(nwidth.eq.0)then
         return
      endif
      darg=pi/dble(nwidth)
      iarg=0
      do 10 i=1,nwidth
         fac=0.5d0*(cos(darg*iarg+pi)+1.d0)
         y(i)=fac*x(i)
         iarg=iarg+1
 10   continue
      do 20 i=nwidth,n-nwidth
         y(i)=x(i)
 20   continue
      iarg=0
      do 30 i=n-nwidth+1,n
         fac=0.5d0*(cos(darg*iarg)+1.d0)
         y(i)=fac*x(i)
         iarg=iarg+1
 30   continue
      return
      end

      subroutine dtwin_han2(x,y,n,nmax,nwidth)
c Hanning (cos) window
      implicit real*8 (a-h,o-z)                                               
      dimension x(nmax),y(nmax)
      data idcalled/0/
      if(idcalled.eq.0)then
         write(6,'(a)')'Type of tapering window : Hanning(type2)'
         idcalled=1
      endif
      pi2=acos(-1.d0)/2.d0
      if(nwidth.eq.0)then
         return
      endif
      darg=pi2/(nwidth-1)
      iarg=0
      do 10 i=1,nwidth
         fac=sin(darg*iarg)
         y(i)=fac*x(i)
         iarg=iarg+1
 10   continue
      do 20 i=nwidth,n-nwidth
         y(i)=x(i)
 20   continue
      iarg=0
      do 30 i=n-nwidth+1,n
         fac=cos(darg*iarg)
         y(i)=fac*x(i)
         iarg=iarg+1
 30   continue
      return
      end

      subroutine dtwin_w1(x,y,n,nmax,nwidth)
      implicit real*8 (a-h,o-z)                                               
      dimension x(nmax),y(nmax)
      data idcalled/0/
      if(idcalled.eq.0)then
         write(6,'(a)')'Type of tapering window : Welch W1 (1-t**2)'
         idcalled=1
      endif

      if(nwidth.eq.0)then
         return
      endif
      do 10 i=1,nwidth
         fac=-(dble(i-nwidth)/dble(nwidth))**2+1.d0
         y(i)=fac*x(i)
 10   continue
      do 20 i=nwidth,n-nwidth
         y(i)=x(i)
 20   continue
      iarg=0
      do 30 i=n-nwidth+1,n
         fac=-(dble(i-(n-nwidth))/dble(nwidth))**2+1.0d0
         y(i)=fac*x(i)
 30   continue
      return
      end

      subroutine dtwin_w2(x,y,n,nmax,nwidth)
      implicit real*8 (a-h,o-z)                                               
      dimension x(nmax),y(nmax)
      data idcalled/0/
      if(idcalled.eq.0)then
         write(6,'(a)')'Type of tapering window : Welch W2 (1-|t|)'
         idcalled=1
      endif

      if(nwidth.eq.0)then
         return
      endif
      do 10 i=1,nwidth
         fac=dble(i-1)/dble(nwidth)
         y(i)=fac*x(i)
 10   continue
      do 20 i=nwidth,n-nwidth
         y(i)=x(i)
 20   continue
      iarg=0
      do 30 i=n-nwidth+1,n
         fac=-dble(i-n)/dble(nwidth)
         y(i)=fac*x(i)
 30   continue
      return
      end

      real*8 function spw_simplesum(udf)
c      real*8 function spw(udf)
c   Simple summation
      implicit real*8 (a-h,o-z)
      spw=1.d0
      return
      end

      real*8 function spw(udf)
c      real*8 function spw_pzw(udf)
c   Parzen window 
      implicit real*8 (a-h,o-z)                                         
      if(udf.eq.0d0)then
         spw=1.d0
      else
         spw=sin(udf)/udf  
         spw=spw**4
      endif         
      return
      end

      subroutine caledf(itype_dtwin,
     +     nblock,kpoint,nwidth,lx2,kovlp,PTfac,edf)
c     An algorithm calculating equivalent dgrees of freedom after Welch1967 (P. D. Welch (1967), The use of Fast Fourier Transform for the estimation of power sectra: A method based on time averaging over short, modified periodgrams, IEEE Trans. Audio and Electroaccoust., AU-15, 70-73.
      parameter(nmax=NMAX_INC,maxb=MAXNSEGMENT_INC)
      implicit real*8 (a-h,o-z)                                         
      dimension dummy(nmax),rho(0:nmax)

c      write(6,*)'DEBUG: caledf() input:',
c     +     nblock,kpoint,nwidth,lx2,kovlp
      
      do i=1,kpoint
         dummy(i)=1.d0
      enddo
      call dtwin(dummy,dummy,kpoint,nmax,nwidth,itype_dtwin) 
      do i=kpoint,lx2
         dummy(i)=0.d0
      enddo

c The efffects of the zero padding is not evaluated in calculating PTfac
c (So that we can evaluate sepalately the power reductions by the zero
c padding and by the tapering) (20151015).
      wsq=0.d0
      do i=1,kpoint
         wsq=wsq+dummy(i)**2
c         write(6,*)'DEBUG:dummy ',i,dummy(i)
      enddo
      PTfac=wsq/dble(kpoint)

c     The effects of zero-padding is taken into consideration (20151015).
c     (There are, however, no effect.)
      do iblock=0,nblock-1
         ww=0.d0
         do i=1,lx2
c         do i=1,kpoint
            wk=dummy(i)
            jd=i+(kpoint-kovlp)*iblock
            if(jd.ge.1.and.jd.le.lx2)then
c            if(jd.ge.1.and.jd.le.kpoint)then
               wkjd=dummy(jd)
            else
               wkjd=0.d0
            endif
c            write(6,*)'XX:i,jd,iblock wk,wkjd ',i,jd,iblock,wk,wkjd
            ww=ww+wk*wkjd
         enddo
         rho(iblock)=ww**2/wsq**2
c         write(6,*)'DEBUG:ww wsq',iblock,ww,wsq
c         write(6,*)'DEBUG:rho   ',rho(iblock)
      enddo

c      do iblock=0,nblock-1
c         if(rho(iblock).ne.0.d0)then
c            write(6,*)'DEBUG:iblock rho ',iblock,rho(iblock)
c         endif
c      enddo

      rhosum=0.d0
      do iblock=1,nblock-1
         rhosum=rhosum
     +        +2.d0*dble(nblock-iblock)/dble(nblock)*rho(iblock)
c         write(6,*)iblock,rhosum
      enddo
      edf=2.d0*dble(nblock)/(1.d0+rhosum)
c      write(6,*)'DEBUG:nblock,rhosum,edf ',nblock,rhosum,edf

      return
      end
      
      subroutine moment(n,x,ave,std,var,skwew,curt) 
      implicit real*8 (a-h,o-z)                                         
      dimension x(*)
      if(n.lt.2)then
         write(6,*)'ERROR moment(): n < 2: ',n
         write(6,*)'RETURN (nothing done)'
         return
      endif
      
      sum=0.d0
      do i=1,n
         sum=sum+x(i)
      enddo
      ave=sum/dble(n)

      ep=0.d0
      var=0.d0
      skwew=0.d0
      curt=0.d0
      do i=1,n
         s=x(i)-ave
         ep=ep+s
         p=s*s
         var=var+p
         p=p*s
         skwew=skwew+p
         p=p*s
         curt=curt+p
      enddo

c      var=var/dble(n-1)  ! corrected two-pass algorithm not used
      var=(var-ep*ep/dble(n))/dble(n-1)  ! corrected two-pass algorithm

      std=dsqrt(var)
      skwew=skwew/(dble(n)*var*std)
      curt=curt/(dble(n)*var*var)-3.d0
      return
      end

      subroutine jbtest(itype,iconf,n,ajb,idok)
      implicit real*8(a-h,o-z)
c     itype:1  original jb 
c          :21 improved quantity by Nakagawa2009
c     iconf:1  95%
c          :2  99%
c     ajb  :jb value      
c     n    :the number of data points
c     idok :1 maybe normal distribution
c          :2 perhaps not
      if(iconf.ne.1.and.iconf.ne.2)then
         write(6,*)'ERROR jbtest(): iconf not defined:',iconf
         write(6,*)'STOP'
         stop
      endif

      if(     itype.eq.1)then
c     x^2_2 test 0.05  0.01 0.005% C.L.
         if(     iconf.eq.1)then
            valuec=5.991d0
         else if(iconf.eq.2)then
            valuec=9.210d0
         endif
         if(ajb.le.valuec)then
            idok=1
         else
            idok=0
         endif
         
      else if(itype.eq.2)then
         if(     iconf.eq.1)then
            valuec=1.645d0
         else if(iconf.eq.2)then
            valuec=2.326d0
         endif
         if(ajb.le.cjb(n,valuec))then
            idok=1
         else
            idok=0
         endif
      else
         write(6,*)'ERROR jbtest(): itype not defined:',itype
         write(6,*)'STOP'
         stop
      endif

      return
      end

      real*8 function cjb(n,valuec)
      implicit real*8(a-h,o-z)
c  function cjb coded by Cho on 2015/11/9 
c  cjb:    Jarque-Bera statistics improved by Nakagawa(2009)
c  n:      number of data
c  valuec: critical value correspoding to the conf. limit
c (2009),Jarque-Bera̤momentƳФȿ, , 16, 55-64.
      an=dble(n)
      r2=dsqrt(2.d0)
      r6=dsqrt(6.d0)
      an05=1.d0/dsqrt(an)
      
      amu_1=(3.d0*an-5.d0)*(an**2+12.d0*an+7.d0)
     +     /(8.d0*(an+5.d0)*(an+3.d0)*(an+1.d0))

      amu_2=an*(an-2.d0)*(3.d0*an**7 +239.d0*an**6
     +     +6819.d0*an**5 +37283.d0*an**4  -8775.d0*an**3
     +     -329451.d0*an**2 -327711.d0*an -99175.d0)
     +     /(2.d0*(an+9.d0)*(an+13.d0)*(an+7.d0)*(an+11.d0)
     +     *((an+5.d0)*(an+3.d0)*(an+1.d0))**2)

      rbeta_1=(8.d0 
     +     +2750.d0/9.d0/an
     +     -33968.d0/9.d0/an/an)*r6*an05

      A = 6.d0 + 8.d0/rbeta_1 *
     +     (2.d0/rbeta_1+dsqrt(1.d0+4.d0/(rbeta_1*rbeta_1)))

      ai=1/A
      ra=dsqrt(A)
      sqrtmu2=dsqrt(amu_2)
      valuec2=valuec*valuec
      valuec3=valuec2*valuec
      
      cjb=(8.d0*sqrtmu2+A*(ai*dsqrt(1.d0/(-4.d0+A))
     +     *amu_1*(-2.d0*(4.d0*r2/ra+9.d0
     +     *(2.d0-9.d0*A)**2*valuec)*ra
     +     + 27.d0*A*(r2*(4.d0+9.d0*A*(-2.d0+3.d0*A))
     +     +2.d0*r2*(-2.d0+9.d0*A)*valuec2
     +     -4.d0*valuec3*ra))
     +     + 9.d0*sqrtmu2*(-12.d0+r2*(2.d0-9.d0*A)**2
     +     /ra*valuec+12.d0*valuec2
     +     + 6.d0*A*(-18.d0+valuec2
     +     *(-9.d0+r2/ra*valuec)))))
     +     /(dsqrt(1.d0/(-4.d0+A))*(-2.d0
     +     *(4.d0*r2/ra+9.d0*(2.d0-9.d0*A)**2*valuec)
     +     *ra + 27.d0*A*(r2*(4.d0+9.d0*A*(-2.d0+3.d0*A))
     +     +2.d0*r2*(-2.d0+9.d0*A)*valuec2
     +     -4.d0*valuec3*ra)))
      return
      end
