c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#define NPAIR_MAX 100
#define NCOMBI_MAX 100
c-------
c     copied and modified from combi.F on 20220204
c-------
      parameter(npair_max=NPAIR_MAX,ncombi_max=NCOMBI_MAX)
      implicit real*8 (a-h,o-z)
      dimension r(npair_max)
      common/vec/vx(npair_max),vy(npair_max)
c      external  nCr
      i=1
      read(5,*)radius_cvlimit_for_spacapx
 10   read(5,*,end=99,err=99)r(i),x1,y1,x2,y2
      vx(i)=x2-x1
      vy(i)=y2-y1
      i=i+1
      goto 10
 99   npair=i-1
c      write(6,*)radius_cvlimit_for_spacapx
c      do ir=2,npair
c      do ir=3,3
c         write(6,*)'nCr',ir,nCr(npair,ir)
c      enddo
      
c      nr=3
      nr=2
      do i1=1,npair
      do i2=i1+1,npair
c      do i3=i2+1,npair
c            sum=r(i1)+r(i2)+r(i3)
c            sum2=r(i1)**2+r(i2)**2+r(i3)**2
         sum=r(i1)+r(i2)
         sum2=r(i1)**2+r(i2)**2
         ave=sum/dble(nr)
c take sample standard deviation            
c            var=(sum2-nr*ave**2)/(nr-1)
         var=(sum2-nr*ave**2)/dble(nr)
         std=dsqrt(var)
         cv=std/ave
         call cal_acsq(i1,i2,acsq12)
c            call cal_acsq(i2,i3,acsq23)
c            call cal_acsq(i1,i3,acsq13)

         idok=1
         if(cv.gt.radius_cvlimit_for_spacapx)idok=0
         if(acsq12.gt.0.587d0)idok=0 ! 40<=angle<=140
c            if(acsq23.gt.0.587d0)idok=0 ! 40<=angle<=140
c            if(acsq13.gt.0.587d0)idok=0 !
         
         if(idok.eq.1)then
            write(6,'(3i5,f10.6,10e16.8)')
     +           i1,i2,0,ave,cv,acsq12,0.,0.
c            write(6,'(3i5,f10.6,10e16.8)')
c     +           i1,i2,i3,ave,cv,acsq12,acsq13,acsq23
         endif
c      enddo
      enddo
      enddo
      
      stop
      end

c      integer function nCr(n,r)
c      integer n,r,i,r0
c      r0=n-r
c      if(r.le.r0)r0=r
c      nCr=1
c      do i=1,r0
c         nCr=nCr*(n-r0+i)
c         nCr=nCr/i
c      enddo
c      return
c      end

      subroutine cal_acsq(i,j,acsq)
      parameter(npair_max=NPAIR_MAX)
      implicit real*8 (a-h,o-z)
      common/vec/vx(npair_max),vy(npair_max)
      
      prdi=vx(i)*vx(j)+vy(i)*vy(j)
      visq=vx(i)**2+vy(i)**2
      vjsq=vx(j)**2+vy(j)**2
      acsq=prdi**2/(visq*vjsq)
      
      return
      end
      
