c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
      character*200 warning(100)
      character radiunit*4
      idpsd=1
      idhv=0
      idarray=0
      idspac=0
      idcca=0
      idnccca=0
      idh0=0
      idh1=0
      idv=0
      idnsr_v=0
      idcca_plus_L=0
      idcca_plus_R=0
      idspac_plus_L=0
      idspac_plus_R=0
      idspac_minus_L=0
      idspac_minus_R=0
      idrv=0
      idRL=0
      idnsr_h=0
      idwarning=0

      read(5,*)idcalc,id_center,nseis,idcomp,radius,
     +     id_miniature_array
      if(idcalc.eq.0)stop

      if(radius.lt.0.01)then
         radius=radius*100000.
         radiunit='[cm]'
      else 
         radius=radius*1000.
         radiunit='[m]'
      endif

      nseis_total=id_center+nseis
      idcomp0=idcomp

      if(radius.ne.0.)then
      idwarning=idwarning+1
      write(warning(idwarning),'(a)')
     +     '-------------------------------------------------@'
      if(id_center.eq.1)then
         idwarning=idwarning+1
         write(warning(idwarning),'(a,i1,a)')'Array geometry: '//
     +   'centered ', nseis_total,'-station array.@'
         idwarning=idwarning+1
         write(warning(idwarning),'(a,f4.0,a)')'Array radius: '
     +        ,radius,' '//radiunit//'@'
         idwarning=idwarning+1
         write(warning(idwarning),'(a,i1,a)')'Number of sensors at'
     +        //' the center: ',id_center,'@'
         idwarning=idwarning+1
         write(warning(idwarning),'(a,i1,a)')'Number of sensors'
     +        //' around the circle: ',nseis,'@'
      else
         idwarning=idwarning+1
         write(warning(idwarning),'(a,i1,a)')'Array geometry: '//
     +    'centerless ',nseis_total,'-station array@'
         idwarning=idwarning+1
         write(warning(idwarning),'(a,f8.2,a)')'Array radius: '
     +        ,radius,' '//radiunit//'@'
         idwarning=idwarning+1
         write(warning(idwarning),'(a,i1,a)')'Number of sensors at'
     +        //' the center: ',id_center,'@'
         idwarning=idwarning+1
         write(warning(idwarning),'(a,i1,a)')'Number of sensors'
     +        //' around the circle: ',nseis,'@'
      endif
      endif

      if(     idcomp0.eq.1)then
         idwarning=idwarning+1
         write(warning(idwarning),'(a)')
     +        'Data: vertical component only@'
      else if(idcomp0.eq.2)then
         idwarning=idwarning+1
         write(warning(idwarning),'(a)')
     +        'Data: horizontal components only@'
      else if(idcomp0.eq.3)then
         idwarning=idwarning+1
         write(warning(idwarning),'(a)')
     +        'Data: all three components@'
      endif

      if(radius.ne.0.)then
         idwarning=idwarning+1
         write(warning(idwarning),'(a)')
     +        '-------------------------------------------------@'
      endif
c      idwarning=idwarning+1
c      write(warning(idwarning),'(a)')'@'

c idhv
      if(idcomp0.eq.3)then
         idhv=1
      endif

c idarray
      if(nseis_total.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Only a single station'//
     +        ' defined in seismfile.@'
      else if(nseis.le.2.and.idcomp0.eq.2)then
         idwarning=idwarning+1
         warning(idwarning)='Only one or two stations around'
     +        //' the circle.@'
      else if(nseis.ge.1.and.idcomp0.eq.1)then
         idarray=1
      else if(nseis.ge.1.and.idcomp0.eq.3)then
         idarray=1
      else if(nseis.ge.3.and.idcomp0.eq.2)then
         idarray=1
      endif

c idspac & idh0
      if(id_center.eq.1)then

         if(nseis.ge.1.and.idcomp0.ne.2)idspac=1

         if(nseis.ge.2.and.idcomp0.ne.2)idh0=1

         if(nseis.eq.1.or.nseis.eq.2)then
            if(idcomp0.eq.3)then
               idwarning=idwarning+1
               warning(idwarning)='NOTICE: Array analysis will be'
     +              //' conducted for the vertical component only.@'
               idcomp=1
            endif
         endif

      endif

c idcca
      if(nseis.ge.3.and.idcomp0.ne.2)idcca=1

c idcca,h1,v,nccca,nsr_v
      if(id_center.eq.1)then
         if(nseis.ge.3.and.idcomp0.ne.2)idcca=1
         if(nseis.ge.3.and.idcomp0.ne.2)idh1=1
         if(nseis.ge.3.and.idcomp0.ne.2)idv=1
         if(nseis.ge.3.and.idcomp0.ne.2)idnccca=1
         if(nseis.ge.3.and.idcomp0.ne.2)idnsr_v=1
      endif

c idcca_plus_L & idcca_plus_R
      if(nseis.ge.3.and.idcomp0.ne.1)idcca_plus_L=1
      if(nseis.ge.3.and.idcomp0.ne.1)idcca_plus_R=1

c idspac_plus_L,R & idspac_minus_L,R & idnsr_h
      if(id_center.eq.1)then
         if(nseis.ge.3.and.idcomp0.ne.1)idspac_plus_L=1
         if(nseis.ge.3.and.idcomp0.ne.1)idspac_plus_R=1
         if(nseis.ge.3.and.idcomp0.ne.1)idspac_minus_L=1
         if(nseis.ge.3.and.idcomp0.ne.1)idspac_minus_R=1
         if(nseis.ge.3.and.idcomp0.ne.1)idnsr_h=1
      endif

c idrv & idRL  
c      if(id_center.eq.1)then
      if(idarray.eq.1)then  ! 20120201
         if(nseis.ge.3.and.idcomp0.eq.3)idrv=1
      endif
      if(id_center.eq.1)then
         if(nseis.ge.3.and.idcomp0.eq.3)idRL=1
      endif

    
      if(idarray.eq.0)then
         idwarning=idwarning+1
         warning(idwarning)=
     +        'Any array analysis will not be conducted.@'
      endif
      if(idpsd.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Power spectral densities will be'
     +        //' estimated.@'
      endif
      if(idhv.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='horizontal-to-vertical spectral ratios'
     +        //' will be estimated.@'
      endif
      if(idspac.eq.1.and.id_miniature_array.eq.0)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh wave phase velocities'
     +        //' will be estimated (by SPAC).@'
      endif
      if(idcca.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh wave phase velocities'
     +        //' will be estimated (by CCA).@'
      endif
      if(idnccca.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh wave phase velocities'
     +        //' will be estimated (by ncCCA).@'
      endif
      if(idh0.eq.1.and.id_miniature_array.eq.0)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh wave phase velocities'
     +        //' will be estimated (by H0).@'
      endif
      if(idh1.eq.1.and.id_miniature_array.eq.0)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh wave phase velocities'
     +        //' will be estimated (by H1).@'
      endif
      if(idv.eq.1.and.id_miniature_array.eq.0)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh wave phase velocities'
     +        //' will be estimated (by V).@'
      endif
      if(idnsr_v.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Noise-to-signal ratios in the vertical'
     +        //' component will be estimated.@'
      endif
      if(idcca_plus_R.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh wave phase velocities'
     +        //' will be estimated (by CCA+R).@'
      endif
      if(idspac_plus_R.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh wave phase velocities'
     +        //' will be estimated (by SPAC+R).@'
      endif
      if(idspac_minus_R.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh wave phase velocities'
     +        //' will be estimated (by SPAC-R).@'
      endif
      if(idcca_plus_L.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Love wave phase velocities'
     +        //' will be estimated (by CCA+L).@'
      endif
      if(idspac_plus_L.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Love wave phase velocities'
     +        //' will be estimated (by SPAC+R).@'
      endif
      if(idspac_minus_L.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Love wave phase velocities'
     +        //' will be estimated (by SPAC-R).@'
      endif
      if(idrv.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='H/V power partition ratios of the '
     +        //'Rayleigh waves will be estimated.@'
      endif
      if(idRL.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Rayleigh-to-Love power partition'
     +        //' ratios will be estimated.@'
      endif
      if(idnsr_h.eq.1)then
         idwarning=idwarning+1
         warning(idwarning)='Noise-to-signal ratios in the'
     +        //' horizontal components will be estimated.@'
      endif

c output
      write(6,'(a)')'#!/bin/sh' 

      if(nseis_total.eq.2.and.nseis.eq.2)then
         if(idcomp.ne.2)then
            write(6,'(a)')'cat <<EOF'
            write(6,'(a)')'ERROR: Centerless two-station array.'
     +           //' Assign one of the sensors at the'
     +           //' center and the other around the circle. '
     +           //'Modify seismfile and execute run.sh again.'
            write(6,'(a)')'STOP'
            write(6,'(a)')'EOF'
            write(6,'(a)')'exit 1'
         endif
      endif

      idspec2pv=idarray
      write(6,'(a,i1)')'idpsd=',idpsd
      write(6,'(a,i1)')'idhv=',idhv
      write(6,'(a,i1)')'idarray=',idarray
      write(6,'(a,i1)')'idcomp=',idcomp
      write(6,'(a,i1)')'idspec2pv=',idspec2pv
      if(idwarning.ne.0)then
         write(6,'(a,i1)')'warning_flag=1'
      else
         write(6,'(a,i1)')'warning_flag=0'
      endif

      write(6,'(a)')'cat<<EOF' 
      do i=1,idwarning
         write(6,'(a)')warning(i)(1:index(warning(i),'@')-1)
      enddo
      write(6,'(a)')'EOF' 

      stop
      end
