c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------
#include"PARAM.h"
      implicit real*8 (a-h,o-z)     
      external anoise,rkmin4nsr2
      common/OBSERVED/coh2,spr,bsj0,nseis
      common/OBSERVED2/ansr,err0
      common/IDS/iddltmax
c      data re,ae/1.d-8,1.d-8/
      data re,ae/1.d-9,1.d-9/
      character*15 ceps_max,ceps_min
      character*200 vmaxfile
c
      read(5,'(a)')vmaxfile
      open(7,file=vmaxfile,err=999)

      read(5,*)radius,nseis
 10   read(5,*,err=99,end=99)freq,coh2,dum1,spr,dum2,sprnew2
      if(freq.ne.dum1.or.freq.ne.dum2)then
         write(6,*)'ERROR: inconcistent frequency !',freq,dum1,dum2
         stop
      endif

c-----------------------------
      iddltmax=0
      b=0.d0
      c=100.d0
      r=c
      call dfzero(anoise, b, c, r, re, ae, iflag0)
      eps_max=b
c-----------------------------
      iddltmax=1
      b=0.d0
      c=100.d0
      r=c

      call dfzero(anoise, b, c, r, re, ae, iflag1)
      eps_min=b

c      call caldltmx(dltmax,eps_min)

c-----------------------------
      if(iflag0.eq.1)then
         write(ceps_max,'(e15.7)')eps_max
      else
         write(ceps_max,'(a15)')'    NO ROOT    ' 
      endif
      if(iflag1.eq.1)then
         write(ceps_min,'(e15.7)')eps_min
      else
         write(ceps_min,'(a15)') '    1234567    ' 
      endif

      write(6,'(e15.7,2a15,e15.7)')freq,ceps_max,ceps_min,dltmax

      iflag=1

      if(iflag0.eq.1)then
c----------------------------------------
c added on 2010/10/23$B!!8B3&(BNS$BHf"*8B3&0LAjB.EY$KJQ49(B
c
c $B%N%$%:$K$h$k0LAjB.EY$NDc8:N(ogCM(Berr0$B$H$9$k$H!"(B
c J0^2(rk_c/err0)/J1^2(rk_c/err0)
c$B!!!!!!!!!!!!(B=[J0^2(rk_c)+nsr/nseis]/[J1^2(rk_c)+nsr/nseis]. 
c $B$?$@$7!"(Bk_c$B$OBP1~$9$k8B3&GH?t(B(=2$B&P(Bf/phasevel_c)$B$G$"$k!#(B
c $B>e<0$r8B3&(Brk_c$B$K$D$$$F?tCME*$K2r$-!"<!<0$G8B3&0LAjB.EY$r7W;;$9$k!#(B
c 
c----------------------------------------
         b=0.001d0
         c=2.d0  ! 2.4$B$K$9$k$H2r$,5a$^$j$K$/$$!#(B
         r=c
         ansr=eps_max
         err0=0.95d0               ! $B%N%$%:$K$h$kGH?t$N2a>.I>2AogCM(B
         call dfzero(rkmin4nsr2, b, c, r, re, ae, iflag)
         rkmin=b
         alphamax=DPI2
     +        /rkmin
         pvmax=radius*freq*alphamax
      endif

      if(iflag0.eq.1.and.iflag.eq.1)then
         write(7,'(4e15.7)')freq,pvmax,alphamax,rkmin
      else
         write(7,'(1e15.7,3a15)')freq,
     +        '    NO ROOT    ', 
     +        '    NO ROOT    ', 
     +        '    NO ROOT    ' 
      endif

      goto 10
 99   continue
      stop
 999  write(6,*)'ERROR in program calnsr_J0.'
      write(6,*)
     +     'Cannot open file:'//vmaxfile(1:index(vmaxfile,' ')-1)
      write(6,*)'STOP'
      end
      
      subroutine cal_bsl(fjisu8,x8,y8)
      parameter(ny=1)
      complex cy0,cy1,cy, z
      dimension cy0(ny),cy1(ny),cy(2)
      real*8 fjisu8,x8,y8
      fjisu=1.*fjisu8
      x=1.*x8

      kode=2
      z=cmplx(x,0.)
      call cbesj(z, fjisu,  kode, ny, cy0, nz, ierr)
      if(nz.ne.0 .or. ierr.ne.0)then
         write(6,*)'Error:nz or ierr in cbesj()',nz,ierr
         stop
      endif
      y=cy0(1)*1.0

      y8=1.*y
      return
      end

      real*8 function anoise(eps)
      implicit real*8 (a-h,o-z)  
      common/OBSERVED/coh2,spr,bsj0,nseis
      common/IDS/iddltmax
      epsiron=1.d-10
c SPR=J0/(1+$B&E(B)                  
c i.e., J0=SPR(1+$B&E(B)                  --(0)
c coh2=J0^2 / [J0^2+$B&$(B+$B&E(B/3][1+$B&E(B]       --(1)
      bsj0=spr*(1.+eps)
      bsj0sq=bsj0*bsj0
c
      if(iddltmax.eq.0)then
         dltmax=0.
      else
c  case 1 (2$B%b!<%I$N>l9g$K$*$1$k(B-0.4<=J_i<=1$B$NMW@A$+$i(B)
         r1=1.-bsj0
         r2=bsj0+0.4d0
         if(r2.lt.r1)r1=r2
         dltmax=r1**2
c
c  case 2 $B&E!a(B0 ($B$3$3$G$O&E$N:G>.CM$r9M$($k$?$a%T!<%/CM$r9MN8$9$kI,MW$O$J$7(B)
         dltmax1=spr**2*(1./coh2-1)-epsiron
         if(dltmax1.le.dltmax)dltmax=dltmax1
c
      endif
c
      anoise=coh2-bsj0sq/((bsj0sq+dltmax+eps/float(nseis))*(1.+eps))
      return
      end

      real*8 function rkmin4nsr2(rk)
      implicit real*8 (a-h,o-z)  
      common/OBSERVED/coh2,spr,bsj0,nseis
      common/OBSERVED2/ansr,err0
      rke=rk/err0
      eps=ansr/dble(nseis)
      call cal_bsl(0.d0,rk,y0)
      call cal_bsl(1.d0,rk,y1)
      call cal_bsl(0.d0,rke,y0e)
      call cal_bsl(1.d0,rke,y1e)
      y0sq=y0**2
      y1sq=y1**2
      y0esq=y0e**2
      y1esq=y1e**2
      rkmin4nsr2=y0esq/y1esq-(y0sq+eps)/(y1sq+eps)
      return
      end

      subroutine caldltmx(dltmax,eps)
      implicit real*8 (a-h,o-z)     
      common/OBSERVED/coh2,spr,bsj0,nseis
      epsiron=1.d-10
      dltmax=1.d18
c     case 1 (2$B%b!<%I$N>l9g$K$*$1$k(B-0.4<=J_i<=1$B$NMW@A$+$i(B)
      bsj0=spr*(1.d0+eps)
      r1=1.-bsj0
      r2=bsj0+0.4d0
      if(r2.lt.r1)r1=r2
      dltmax1=r1**2
      if(dltmax1.le.dltmax)dltmax=dltmax1
c     case 2 
      eps_p=0.5d0/coh2 - 0.5d0/(dble(nseis)*spr**2)- 1.d0 
      if(eps_p.gt.0.d0)then
c  $B%T!<%/CM(B
         dltmax1=(spr**2./coh2 - 2.d0*spr**2. - 1.d0/float(nseis))**2.
     +        + 4.d0*spr**4.d0*(1.d0/coh2-1.d0)
         dltmax1=dltmax1/(4.d0*spr**2.)
      else
c  $B&E!a(B0
         dltmax1=spr**2.*(1.d0/coh2-1.d0)-epsiron
      endif
      if(dltmax1.le.dltmax)dltmax=dltmax1
      return
      end
