c----------------------------------------
c Fortran Program for Packege BIDO
c (C) 2025 AIST All Rights Reserved.
c----------------------------------------

c -------------------------
c This Program solves 
c g(rkmin,e,N)=g(rkmin/(1-a),0,N)
c for rkmin, where 
c  * g(rk,e,N)=J0(rk)/[1+e],
c  * e NSR, N the number of seismometers
c  * 0.001<rkimin<2.0,
c  * a=0.05,
c and output cmax=2pifr/rkmin 
c -------------------------

#include"PARAM.h"
      implicit real*8 (a-h,o-z)     
      external rkmin4nsr2
      data re,ae/1.d-9,1.d-9/
      character*15 ceps_max,ceps_min
      common/PARAM/ansr,err0
c
      read(5,*)radius
      read(5,*)alim
c
      xmin=0.001d0
      xmax=2.0d0
      err0=1.d0-alim            ! $B%N%$%:$K$h$kGH?t$N2a>.I>2AogCM(B
 10   read(5,*,err=99,end=99)freq,ansr
     
      b=xmin
      c=xmax
      r=c
      call dfzero(rkmin4nsr2, b, c, r, re, ae, iflag)
      rkmin=b
      alphamax=DPI2
     +     /rkmin
      pvmax=radius*freq*alphamax
      write(6,'(4e15.7)')freq,pvmax
      goto 10
 99   continue
      stop
      end

      subroutine cal_bsl(fjisu8,x8,y8)
      parameter(ny=1)
      complex cy0,cy1,cy, z
      dimension cy0(ny),cy1(ny),cy(2)
      real*8 fjisu8,x8,y8
      fjisu=1.*fjisu8
      x=1.*x8

      kode=2
      z=cmplx(x,0.)
      call cbesj(z, fjisu,  kode, ny, cy0, nz, ierr)
      if(nz.ne.0 .or. ierr.ne.0)then
         write(6,*)'Error:nz or ierr in cbesj()',nz,ierr
         stop
      endif
      y=cy0(1)*1.0
      y8=1.*y
      return
      end

      real*8 function rkmin4nsr2(rk)
      implicit real*8 (a-h,o-z)  
      common/PARAM/ansr,err0
      rke=rk/err0
      call cal_bsl(0.d0,rk,y0)
      call cal_bsl(0.d0,rke,y0e)
      rkmin4nsr2=y0e-y0/(1+ansr)
      return
      end
