#!/bin/bash

if [ ! -f ./FAST.f ]
then
cat <<EOF

ERROR: File not found [FAST.f].

       You need to place FAST.f in src, which is downloadable from:
       http://www.ohsaki.co.jp/eng/activity/download/index.html
       See the manual for the details. 

STOP

EOF
exit 1
fi

grep "A PATCHED DOUBLE-PRECISION VERSION FOR BIDO" ./FAST.f >& /dev/null
if test "$?" == "0"
then
cat <<EOF

File FAST.f found, which seems already patched.
Nothing done.

EOF
exit 0
fi

if [ -f ./FAST.f.rej ]
then
rm -f ./FAST.f.rej
fi
if [ -f ./FAST.diff ]
then
rm -f ./FAST.diff
fi
cat <<EOF>./FAST.diff
40a41,44
> C     -------------------------------------------
> C     A PATCHED DOUBLE-PRECISION VERSION FOR BIDO
> C     -------------------------------------------
> 
43c47
<       COMPLEX X(ND),TEMP,THETA                                          
---
>       COMPLEX*16 X(ND),TEMP,THETA                                          
62c66,67
<       THETA=CMPLX(0.0,3.141593*REAL(IND*(K-1))/REAL(KMAX))              
---
>       THETA=DCMPLX(0.0d0,3.141592653589793d0
>      +                        *REAL(IND*(K-1))/REAL(KMAX))              
65c70
<       TEMP=X(J)*CEXP(THETA)                                             
---
>       TEMP=X(J)*EXP(THETA)                                             
EOF

cat ./FAST.f | sed 's/\r$//' > ./FAST.f.temporal
mv -f ./FAST.f.temporal ./FAST.f
echo patch FAST.f  FAST.diff
patch ./FAST.f ./FAST.diff
rm -f ./FAST.diff

if [ -f ./FAST.f.rej ]
then
rm -f ./FAST.f.rej
if [ -f ./FAST.f.orig ]
then
mv -f ./FAST.f.orig  ./FAST.f
fi
cat <<EOF

patch failed.
Please check if FAST.f is downloaded from:  
       http://www.ohsaki.co.jp/eng/activity/download/index.html
       See the manual for the details.

EOF

exit 1
fi

echo patch successfully finished.
