#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

seisfile_cohcca=$outputdir2/seism_cohcca.log
seisfile_spacapx_combi=$outputdir2/seism_spacapx_combi.log

#######################################################################
# Don't touch from here
#######################################################################
# (1) check if the original array consists of more than 3 points
# (2) extract all combinations of 3p-array from the original array,
#     where (i)  radius_cvlimit_for_spacapx <= a critical value
#           (ii) all two vectors have an angle between 40 and  140 deg.
#            * the concrete value for (i)  is set in setpar.sh
#            * the concrete value for (ii) is set in combi.F
# (3) cluster 3p-arrays by radius
#     Aggolomerative hierarchical clustering method is used
#           (the seven-th method of Spath (1980)).
#     where a critical value for clustering, relative_r_error4clustring,
#     is set in setpar.sh
#
#     Spath, H., 1980, Cluster analysis algorithms: for data rduction and classification of objects, Chapter4, John Willey & Sons, N.Y., 226p.
#----------------------------------------------------------------------

echo "<SPAC APX COMBI>"

echo nseis_total: $nseis_total

idok=1

if  [ -f $seisfile_spacapx_combi ]
then
rm -f $seisfile_spacapx_combi 
fi
touch -f $seisfile_spacapx_combi 

if  [ -f $seisfile_spacapx_combi.filename ]
then
rm -f $seisfile_spacapx_combi.filename 
fi
touch -f $seisfile_spacapx_combi.filename 

radius_cohcca=`cat $seisfile_cohcca | awk '{print $1}' | sort -n | uniq`

nrc0_total=0
for rc0 in $radius_cohcca
do
let nrc0_total=nrc0_total+1
done
if [ $nrc0_total -eq 1 ]
then
cat $seismfile  | grep -v '^#' | awk '{if($3!=""){print $3}
}' | grep _DvTmNo >& /dev/null
if test "$?" == "0"
then
idok=1
else
idok=0
fi
fi

if [ $idok -eq 1 ] # nrc0_total > 1
then

echo OUTPUT: $seisfile_spacapx_combi

cat $seisfile_cohcca|awk 'BEGIN{print "'"$radius_cvlimit_for_spacapx"'"
}{print $2,$10,$11,$12,$13}' | $bindir/combi | sort -n -k 4 >> $seisfile_spacapx_combi

n_spacapx_combi=`wc -l $seisfile_spacapx_combi| awk '{print $1}' `
i_spacapx_combi=1
while [ $i_spacapx_combi -le $n_spacapx_combi ]
do

buf=`cat $seisfile_spacapx_combi| head -$i_spacapx_combi | tail -1`
i1=`echo $buf |awk '{print $1}'`
i2=`echo $buf |awk '{print $2}'`
i3=`echo $buf |awk '{print $3}'`
r_ave=`echo $buf |awk '{print $4}'`
r_n=3

rc0=`echo $r_ave | awk '{eps4shisha=0.5; r=$1
if(     r<=0.0030001){rapx=sprintf("%2d",r*100000+eps4shisha)
printf "%2.0fcm",rapx}
else if(r<=0.020001){rapx=sprintf("%2d",r*10000+eps4shisha)
printf "%2.1fm",rapx/10}
else if(r<=0.20001){rapx=sprintf("%2d",r*1000+eps4shisha)
printf "%2.0fm",rapx}
else                   {rapx=sprintf("%2d",r*100+eps4shisha)
printf "%2.0fm",rapx*10}
}'`

file1=`cat $seisfile_cohcca | head -$i1 | tail -1 | awk '{print $7}'`
file2=`cat $seisfile_cohcca | head -$i2 | tail -1 | awk '{print $7}'`
file3=`cat $seisfile_cohcca | head -$i3 | tail -1 | awk '{print $7}'`

FILES_CMPLXCOH="$file1 $file2 $file3"
no=`echo $i_spacapx_combi| awk '{printf "No%03d",$1}'`

filetail=_R$rc0"$r_n"pAPX_"$no"

echo $buf $FILES_CMPLXCOH $filetail >> $seisfile_spacapx_combi.filename

#------
# Directional averaging complex Coherences
#------
avefile=${spr_spacfile%.*}$filetail.d
if [ -f $avefile ]
then
rm -f $avefile
fi
touch -f $avefile
nfile=0
for file in $FILES_CMPLXCOH 
do
paste $file $avefile | awk '{print $1,$2+$5}' > $avefile.1
mv -f $avefile.1 $avefile
let nfile=nfile+1
done
cat $avefile | awk 'BEGIN{nfile=1.*"'"$nfile"'"}{d=$2/nfile
printf "%20.10e %20.10e\n", $1,d}' > $avefile.1
mv -f $avefile.1 $avefile
echo "OUTPUT (for Average Coherence) " $avefile

#------
# Phase Veolocity
#------
#outfile=${vel_spacfile%.*}$filetail.d
#echo "OUTPUT (for Phase Velocity for average radius $r_ave [km]) " $outfile
#dfmin=`   cat $avefile | sed -n '1,1'p | awk '{printf "%f\n",$1}'`
#freq_max=`cat $avefile | tail -1       | awk '{printf "%f\n",$1}'`
#cat $avefile | awk 'BEGIN{
#printf "1 "'"$r_ave"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
#print $0}' | $bindir/sctr2pv > $outfile

let i_spacapx_combi=i_spacapx_combi+1
done # while [ $i_spacapx_combi -le $n_spacapx_combi ]

mv -f $seisfile_spacapx_combi.filename $seisfile_spacapx_combi

#--------------------------------
# clustering of radii
#--------------------------------
#if [ $n_spacapx_combi -ge 10 ]
#then
if [ `cat $seisfile_spacapx_combi | wc -l | awk '{print $1}'` -ge 1 ]
then
if [ -f $seisfile_spacapx_combi.4paste ]
then
rm -f $seisfile_spacapx_combi.4paste
fi
if [ -f $seisfile_spacapx_combi.cluster ]
then
rm -f $seisfile_spacapx_combi.cluster
fi

cat $seisfile_spacapx_combi | awk 'BEGIN{
print "'"$relative_r_error4clustring"'"}{
print $4}' | $bindir/hierarchical > $seisfile_spacapx_combi.4paste
paste $seisfile_spacapx_combi $seisfile_spacapx_combi.4paste > $seisfile_spacapx_combi.cluster
echo output: $seisfile_spacapx_combi.cluster
mv -f $seisfile_spacapx_combi.cluster $seisfile_spacapx_combi
rm -f $seisfile_spacapx_combi.4paste

#---------
# process each cluster
#---------
igidmax=`cat $seisfile_spacapx_combi | awk '{print $14}'| sort -n | tail -1`
igid=1
r_n=3
while [ $igid -le $igidmax ]
do
tails=`cat $seisfile_spacapx_combi | awk 'BEGIN{igid=1.*"'"$igid"'"}{
if($14==igid){print $12}}'`
n_ave=`cat $seisfile_spacapx_combi | awk 'BEGIN{igid=1.*"'"$igid"'"}{
if($14==igid){print $15}}' | tail -1`
r_ave=`cat $seisfile_spacapx_combi | awk 'BEGIN{igid=1.*"'"$igid"'"}{
if($14==igid){print $16}}' | tail -1`
rc0=`echo $r_ave | awk '{eps4shisha=0.5; r=$1
if(     r<=0.0030001){rapx=sprintf("%2d",r*100000+eps4shisha)
printf "%2.0fcm",rapx}
else if(r<=0.020001){rapx=sprintf("%2d",r*10000+eps4shisha)
printf "%2.1fm",rapx/10}
else if(r<=0.20001){rapx=sprintf("%2d",r*1000+eps4shisha)
printf "%2.0fm",rapx}
else                   {rapx=sprintf("%2d",r*100+eps4shisha)
printf "%2.0fm",rapx*10}
}'`
no=`echo $n_ave $igid | awk '{printf "n%03dCL%02d",$1,$2}'`
filetail=_R$rc0"$r_n"pAPX_"$no"
#echo $r_ave $rc0 $filetail

#------
# averaging spr_spacfiles of 3-p arrays
#------
FILES_TEMP=""
for tail in $tails
do
  file=${spr_spacfile%.*}$tail.d
  FILES_TEMP="$FILES_TEMP $file"
done

avefile=${spr_spacfile%.*}$filetail.d
if [ -f $avefile ]
then
rm -f $avefile
fi
touch -f $avefile
nfile=0
for file in $FILES_TEMP 
do
paste $file $avefile | awk '{print $1,$2+$4}' > $avefile.1
mv -f $avefile.1 $avefile
rm -f $file
let nfile=nfile+1
done
cat $avefile | awk 'BEGIN{nfile=1.*"'"$nfile"'"}{d=$2/nfile
printf "%20.10e %20.10e\n", $1,d}' > $avefile.1
mv -f $avefile.1 $avefile
echo "OUTPUT (for Average Coherence) " $avefile

#------
# Phase Veolocity
#------
outfile=${vel_spacfile%.*}$filetail.d
echo "OUTPUT (for Phase Velocity for average radius $r_ave [km]) " $outfile
dfmin=`   cat $avefile | sed -n '1,1'p | awk '{printf "%f\n",$1}'`
freq_max=`cat $avefile | tail -1       | awk '{printf "%f\n",$1}'`
cat $avefile | awk 'BEGIN{
printf "1 "'"$r_ave"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
print $0}' | $bindir/sctr2pv > $outfile

let igid=igid+1
done

fi # if [ `wc -l $seisfile_spacapx_combi | awk '{print $1}'` -ge 1 ]
#fi # if [ $n_spacapx_combi -ge 10 ]

fi # if [ $idok -eq 1 ]


