#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

seisfile_cohcca=$outputdir2/seism_cohcca.log
seisfile_spacapx=$outputdir2/seism_spacapx.log

#######################################################################
# Don't touch from here
#######################################################################
# specratiopv_cohccaǤϤդIDȤƤΡȾ¡פƱʿ򤹤롣ΤפȤǤspecratiopv_cohcca˵ܤꤹȤ٤ƤˤĤơ֤٤ƱǤʤפ˸¤֤ФĤϰפʤʿ򤹤롣
echo "<SPAC APX>"

idok=1

if  [ -f $seisfile_spacapx ]
then
rm -f $seisfile_spacapx 
fi
touch -f $seisfile_spacapx 

radius_cohcca=`cat $seisfile_cohcca | awk '{print $1}' | sort -n | uniq`

nrc0_total=0
for rc0 in $radius_cohcca
do
let nrc0_total=nrc0_total+1
done
if [ $nrc0_total -eq 1 ]
then
    idok=0
fi

if [ $idok -eq 1 ] # nrc0_total > 1
then
stat=`cat $seisfile_cohcca | awk 'BEGIN{n=0;sum=0;sum2=0;eps=1.e-12
}{r=$2;sum=sum+r;sum2=sum2+r^2;n=n+1}END{ave=sum/n;a=sum2-n*ave^2
if(a>eps){std=sqrt((sum2-n*ave^2)/(n-1))}else{std=0};cv=std/ave
print ave,std,cv,n}'`
r_ave=`echo $stat | awk '{print $1}'`
r_std=`echo $stat | awk '{print $2}'`
r_cv=`echo $stat | awk '{print $3}'`
r_n=`echo $stat | awk '{print $4}'`

rc0=`echo $r_ave | awk '{eps4shisha=0.5; r=$1
if(     r<=0.0030001){rapx=sprintf("%2d",r*100000+eps4shisha)
printf "%2.0fcm",rapx}
else if(r<=0.020001){rapx=sprintf("%2d",r*10000+eps4shisha)
printf "%2.1fm",rapx/10}
else if(r<=0.20001){rapx=sprintf("%2d",r*1000+eps4shisha)
printf "%2.0fm",rapx}
else                   {rapx=sprintf("%2d",r*100+eps4shisha)
printf "%2.0fm",rapx*10}
}'`

# cvlimit_for_spacapx
idok=`echo $r_cv | awk 'BEGIN{
radius_cvlimit_for_spacapx=1.*"'"$radius_cvlimit_for_spacapx"'"}{
if($1<=radius_cvlimit_for_spacapx){printf "1"}else{printf "0"}}'`

echo OUTPUT: $seisfile_spacapx
cat <<EOF>> $seisfile_spacapx 
radius_id   $rc0
radius_ave $r_ave
radius_std $r_std
radius_cv  $r_cv
radius_n   $r_n
EOF

fi # if [ $idok -eq 1 ]


if [ $idok -eq 1 ]
then
FILES_CMPLXCOH=`cat $seisfile_cohcca | awk '{print $7}'`
filetail=_R$rc0"$r_n"pAPX

#------
# Directional averaging complex Coherences
#------
avefile=${spr_spacfile%.*}$filetail.d
if [ -f $avefile ]
then
rm -f $avefile
fi
touch -f $avefile
nfile=0
for file in $FILES_CMPLXCOH 
do
paste $file $avefile | awk '{print $1,$2+$5}' > $avefile.1
mv -f $avefile.1 $avefile
let nfile=nfile+1
done
cat $avefile | awk 'BEGIN{nfile=1.*"'"$nfile"'"}{d=$2/nfile
printf "%20.10e %20.10e\n", $1,d}' > $avefile.1
mv -f $avefile.1 $avefile
echo "OUTPUT (for Average Coherence) " $avefile

#------
# Phase Veolocity
#------
outfile=${vel_spacfile%.*}$filetail.d
echo "OUTPUT (for Phase Velocity for average radius $r_ave [km]) " $outfile
dfmin=`   cat $avefile | sed -n '1,1'p | awk '{printf "%f\n",$1}'`
freq_max=`cat $avefile | tail -1       | awk '{printf "%f\n",$1}'`
cat $avefile | awk 'BEGIN{
printf "1 "'"$r_ave"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
print $0}' | $bindir/sctr2pv > $outfile

fi # if [ $idok -eq 1 ]


