#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

seisfile_cohcca=$outputdir2/seism_cohcca.log

id_DvTm=1  # 1 ON, 0 OFF. This option checks if the observation is simultaneous or not following the code name. This check will be done if the code name includes "_DvTmNo". 

#######################################################################
# Don't touch from here
#######################################################################
echo "<ESAC>"

comp=u
if [ -f  $seisfile_cohcca ]
then
rm -f $seisfile_cohcca
fi
touch -f $seisfile_cohcca

No=1
i=1
while [ $i -le $nseis_total ]
do
j=1
while [ $j -le $nseis_total ]
do

if [ $j -gt $i ]
then
idok=1
else
idok=0
fi

buf1=`cat $seismfile  | grep -v '^#' | head -$i | tail -1` 
buf2=`cat $seismfile  | grep -v '^#' | head -$j | tail -1`
code1=`echo $buf1 | awk '{print $3}'`
code2=`echo $buf2 | awk '{print $3}'`

######################
# Divided Time Routine added 20220201
######################
if [ $id_DvTm -eq 1 ]
then
echo $code1 | grep _DvTmNo >& /dev/null
if test "$?" == "0"
then
DvTm_code1=`basename $code1 .d | sed 's/_DvTmNo/ /' | awk '{print $2}'`
else
DvTm_code1="-1"
fi
echo $code2 | grep _DvTmNo >& /dev/null
if test "$?" == "0"
then
DvTm_code2=`basename $code2 .d | sed 's/_DvTmNo/ /' | awk '{print $2}'`
else
DvTm_code2="-1"
fi
idDvTm_ok=`echo $DvTm_code1 $DvTm_code2 | awk '{
id1=$1;id2=$2;idok=1
if(id1==-1&&id1!=-1){idok=0}
if(id1!=-1&&id1==-1){idok=0}
if(id1!=id2){idok=0}
print idok}'`
if [ $idDvTm_ok -eq 0 ]
then
idok=0
fi
fi # if [ $id_DvTm -eq 1 ]
######################

if [ $idok -eq 1 ]
then
file1=$outputdir2/SD"$i""$comp"_SD"$j"$comp.d 
file2=$outputdir2/SD"$i""$comp"_SD"$i"$comp.d 
file3=$outputdir2/SD"$j""$comp"_SD"$j"$comp.d 
FILES="$file1 $file2 $file3"
outfile_cmplxcoh=$outputdir2/CMPLXcoh"$i"_"$j"$comp.d 
outfile_phase=$outputdir2/PHASE"$i"_"$j"$comp.d 

buf=`echo $buf1 $buf2 | awk 'BEGIN{eps4shisha=0.5; eps=0.01
}{x1=$1;y1=$2;code1=$3;x2=$5;y2=$6;code2=$7
r=sqrt((x1-x2)^2+(y1-y2)^2)
# basic data
if(     r<=0.0030001){rapx=sprintf("%2d",r*100000+eps4shisha)
printf "%2.0fcm  %15.4e %s %s ",rapx,  r,code1,code2}
else if(r<=0.020001){rapx=sprintf("%2d",r*10000+eps4shisha)
printf "%2.1fm  %15.4e %s %s ",rapx/10,  r,code1,code2}
else if(r<=0.20001){rapx=sprintf("%2d",r*1000+eps4shisha)
printf "%2.0fm  %15.4e %s %s ",rapx,  r,code1,code2}
else                   {rapx=sprintf("%2d",r*100+eps4shisha)
printf "%2.0fm  %15.4e %s %s ",rapx*10,  r,code1,code2}
# angle between two stations 
printf "999 999"}'`
buf_zahyo=`echo $buf1 $buf2 | awk '{x1=$1;y1=$2;x2=$5;y2=$6
printf "%s %s %s %s ",x1,y1,x2,y2}'`
#echo $buf $outfile_cmplxcoh $outfile_phase >> $seisfile_cohcca
rc0=`echo $buf | awk '{printf "%s", $1}'`
rc0_realnumber=`echo $buf | awk '{printf "%s",$2}'`

No_C=`echo $No| awk '{printf "No%03d",$1}'`
filetail=_R"$rc0"1p_"$No_C"
#filetail=_R"$rc0"1p_No"$No"

echo $buf $outfile_cmplxcoh $outfile_phase $filetail $buf_zahyo >> $seisfile_cohcca

for file in $FILES;do
. script/chkfile.sh $file; done

# For spac method, this program takes a simple average (without a weight) of the coherence functions between stations having a uniform distance.
echo "OUTPUT (for Complex Coherence) " $outfile_cmplxcoh
paste $FILES| awk '{freq=$1;bunshi_r=$2;bunshi_i=$3;bunbo1=$6;bunbo2=$10;
b1b2=bunbo1*bunbo2
if(b1b2!=0){printf "%e\t%e\t%e\n",
freq,bunshi_r/sqrt(b1b2),bunshi_i/sqrt(b1b2)
}}'> $outfile_cmplxcoh

#-------------------------
# added 2015/8/11
echo "OUTPUT (for Phase Difference) " $outfile_phase
paste $FILES| awk 'BEGIN{pi=4.0*atan2(1.0,1.0);d2r=pi/180.}{
freq=$1;bunshi_r=$2;bunshi_i=$3
phase=atan2(bunshi_i,bunshi_r)/d2r
printf "%g\t%g\n",freq,phase
}'> $outfile_phase
#-------------------------

dfmin=`   cat $outfile_cmplxcoh |sed -n '1,1'p|awk '{printf "%f\n",$1}'`
freq_max=`cat $outfile_cmplxcoh |tail -1      |awk '{printf "%f\n",$1}'`

# output phase velocities by two-station spac

outfile_spr=${spr_spacfile%.*}$filetail.d
outfile=${vel_spacfile%.*}$filetail.d
echo "OUTPUT (for Phase Velocity   ) " $outfile
#dfmin=`   cat $outfile_cmplxcoh |sed -n '1,1'p|awk '{printf "%f\n",$1}'`
#freq_max=`cat $outfile_cmplxcoh |tail -1      |awk '{printf "%f\n",$1}'`
cat $outfile_cmplxcoh | awk '{print $1,$2}'  > $outfile_spr
cat $outfile_cmplxcoh | awk 'BEGIN{
printf "1 "'"$rc0_realnumber"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
print $0}' | $bindir/sctr2pv > $outfile

let No=No+1

fi # [ $idok -eq 1 ]

let j=j+1
done
let i=i+1
done

