#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

idcohcca_spaclevel=3  # output level for SPAC. 1: spac standard spac only 2:all spac except for two-point spac, 3:include two-point spac (2,3 used for a developement purpose)
idcohcca_ccalevel=1   # output level for CCA. 1: cca & nc-cca 2:include all spac derivations  (2 used for a developement purpose)
idoutput_snpowfile=1   # 0/1: output signal and noise psd
llim_npairs_cohs=2     # lower limit of the number of station pairs for SPAC
llim_npairs_cohc=3     # lower limit of the number of stations for CCA
filetail_cca0th=0th_order
filetail_cca1st=1st_order
seisfile_cohcca=$outputdir2/seism_cohcca.log

#######################################################################
# Don't touch from here
#######################################################################
sprspacfile4nccca=""
sprspacfile4nccca_nocenter3st=""
rc0_cca=`echo $radius_cca | awk '{eps4shisha=0.5; r=$1
if(     r<=0.0030001){rapx=sprintf("%2d",r*100000+eps4shisha)
printf "%2.0fcm",rapx}
else if(r<=0.020001){rapx=sprintf("%2d",r*10000+eps4shisha)
printf "%2.1fm",rapx/10}
else if(r<=0.20001){rapx=sprintf("%2d",r*1000+eps4shisha)
printf "%2.0fm",rapx}
else                   {rapx=sprintf("%2d",r*100+eps4shisha)
printf "%2.0fm",rapx*10}
}'`

echo "<COHERENCE CCA>"

comp=u
idccaflag=0
x0=`cat $seismlogfile | grep 'CENTER POINT CALCULATED:' |\
 tr '(' ' ' | tr ')' ' ' | awk '{print $4}'`
y0=`cat $seismlogfile | grep 'CENTER POINT CALCULATED:' |\
 tr '(' ' ' | tr ')' ' ' | awk '{print $5}'`
if [ -f  $seisfile_cohcca ]
then
rm -f $seisfile_cohcca
fi
touch -f $seisfile_cohcca

No=1
i=1
while [ $i -le $nseis_total ]
do
j=1
while [ $j -le $nseis_total ]
do

if [ $j -gt $i ]
then
idok=1
else
idok=0
fi

if [ $idok -eq 1 ]
then
file1=$outputdir2/SD"$i""$comp"_SD"$j"$comp.d 
file2=$outputdir2/SD"$i""$comp"_SD"$i"$comp.d 
file3=$outputdir2/SD"$j""$comp"_SD"$j"$comp.d 
FILES="$file1 $file2 $file3"
outfile_cmplxcoh=$outputdir2/CMPLXcoh"$i"_"$j"$comp.d 
outfile_phase=$outputdir2/PHASE"$i"_"$j"$comp.d 

buf1=`cat $seismfile  | grep -v '^#' | head -$i | tail -1` 
buf2=`cat $seismfile  | grep -v '^#' | head -$j | tail -1`
code1=`echo $buf1 | awk '{print $3}'`
code2=`echo $buf2 | awk '{print $3}'`
buf=`echo $buf1 $buf2 | awk 'BEGIN{eps4shisha=0.5; eps=0.01
x0=1.*"'"$x0"'";y0=1.*"'"$y0"'";radius_cca=1.*"'"$radius_cca"'"
}{x1=$1;y1=$2;code1=$3;x2=$5;y2=$6;code2=$7
r=sqrt((x1-x2)^2+(y1-y2)^2)

# basic data
if(     r<=0.0030001){rapx=sprintf("%2d",r*100000+eps4shisha)
printf "%2.0fcm  %15.4e %s %s ",rapx,  r,code1,code2}
else if(r<=0.020001){rapx=sprintf("%2d",r*10000+eps4shisha)
printf "%2.1fm  %15.4e %s %s ",rapx/10,  r,code1,code2}
else if(r<=0.20001){rapx=sprintf("%2d",r*1000+eps4shisha)
printf "%2.0fm  %15.4e %s %s ",rapx,  r,code1,code2}
else                   {rapx=sprintf("%2d",r*100+eps4shisha)
printf "%2.0fm  %15.4e %s %s ",rapx*10,  r,code1,code2}


# angle between two stations 
x1_0=x1-x0;x2_0=x2-x0;y1_0=y1-y0;y2_0=y2-y0
rcca1=sqrt(x1_0^2+y1_0^2)
rcca2=sqrt(x2_0^2+y2_0^2)
eps1=sqrt((rcca1/radius_cca-1)^2)
eps2=sqrt((rcca2/radius_cca-1)^2)
     if(eps1<=eps&&eps2<=eps){
cosx=(x1_0*x2_0+y1_0*y2_0)/(rcca1*rcca2)
sinx=(x1_0*y2_0-y1_0*x2_0)/(rcca1*rcca2)
printf "%f %f",cosx,sinx}
else if(eps1<=eps&& eps2>eps){printf "0   999"}
else if(eps1>eps &&eps2<=eps){printf "999   0"}
else{printf "999 999"}
}'`
buf_zahyo=`echo $buf1 $buf2 | awk '{x1=$1;y1=$2;x2=$5;y2=$6
printf "%s %s %s %s ",x1,y1,x2,y2}'`
#echo $buf $outfile_cmplxcoh $outfile_phase >> $seisfile_cohcca
rc0=`echo $buf | awk '{printf "%s", $1}'`
rc0_realnumber=`echo $buf | awk '{printf "%s",$2}'`

No_C=`echo $No| awk '{printf "No%03d",$1}'`
filetail=_R"$rc0"1p_"$No_C"
#filetail=_R"$rc0"1p_No"$No"

echo $buf $outfile_cmplxcoh $outfile_phase $filetail $buf_zahyo >> $seisfile_cohcca

for file in $FILES;do
. script/chkfile.sh $file; done

# For spac method, this program takes a simple average (without a weight) of the coherence functions between stations having a uniform distance.
echo "OUTPUT (for Complex Coherence) " $outfile_cmplxcoh
paste $FILES| awk '{freq=$1;bunshi_r=$2;bunshi_i=$3;bunbo1=$6;bunbo2=$10;
b1b2=bunbo1*bunbo2
if(b1b2!=0){printf "%e\t%e\t%e\n",
freq,bunshi_r/sqrt(b1b2),bunshi_i/sqrt(b1b2)
}}'> $outfile_cmplxcoh

#-------------------------
# added 2015/8/11
echo "OUTPUT (for Phase Difference) " $outfile_phase
paste $FILES| awk 'BEGIN{pi=4.0*atan2(1.0,1.0);d2r=pi/180.}{
freq=$1;bunshi_r=$2;bunshi_i=$3
phase=atan2(bunshi_i,bunshi_r)/d2r
printf "%g\t%g\n",freq,phase
}'> $outfile_phase
#-------------------------

dfmin=`   cat $outfile_cmplxcoh |sed -n '1,1'p|awk '{printf "%f\n",$1}'`
freq_max=`cat $outfile_cmplxcoh |tail -1      |awk '{printf "%f\n",$1}'`

# output phase velocities by two-station spac
if [ $idcohcca_spaclevel -eq 3 ]
then
#rc0=`echo $buf | awk '{printf "%s", $1}'`
#rc0_realnumber=`echo $buf | awk '{printf "%s",$2}'`
#filetail=_R"$rc0"1p_No"$No"
outfile_spr=${spr_spacfile%.*}$filetail.d
outfile=${vel_spacfile%.*}$filetail.d
echo "OUTPUT (for Phase Velocity   ) " $outfile
#dfmin=`   cat $outfile_cmplxcoh |sed -n '1,1'p|awk '{printf "%f\n",$1}'`
#freq_max=`cat $outfile_cmplxcoh |tail -1      |awk '{printf "%f\n",$1}'`
cat $outfile_cmplxcoh | awk '{print $1,$2}'  > $outfile_spr
cat $outfile_cmplxcoh | awk '{print $1,$3}'  > $outfile_spr.img
cat $outfile_cmplxcoh | awk 'BEGIN{
printf "1 "'"$rc0_realnumber"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
print $0}' | $bindir/sctr2pv > $outfile

let No=No+1

fi

idcca=`echo $buf | awk '{if($5!=999&&$6!=999){print 1}else{print 0}}'`

if [ $idcca -eq 1 ]
then
let idccaflag=idccaflag+1

buf_mkcrcl_unevenwlog=`
cat $logfile_mkcrcle_circle | grep cohcca | awk 'BEGIN{
code1="'"$code1"'"; code2="'"$code2"'"}{iorder=$2
if(iorder==0){    if($7==code1&&$8==code2){print $0}}}'`
fac_r=`echo $buf_mkcrcl_unevenwlog | awk '{print $5}'`
fac_i=`echo $buf_mkcrcl_unevenwlog | awk '{print $6}'`
paste $FILES| awk 'BEGIN{fac_r=1.*"'"$fac_r"'"; fac_i=1.*"'"$fac_i"'"
}{freq=$1;bunshi_r=$2;bunshi_i=$3;bunbo1=$6;bunbo2=$10;b1b2=bunbo1*bunbo2
if(b1b2!=0){printf "%e\t%e\t%e\n",freq,
(bunshi_r*fac_r-bunshi_i*fac_i)/sqrt(b1b2),
(bunshi_r*fac_i+bunshi_i*fac_r)/sqrt(b1b2)
}}'> $outfile_cmplxcoh.$filetail_cca0th
echo "OUTPUT (for Complex Coherence) " $outfile_cmplxcoh.$filetail_cca0th

buf_mkcrcl_unevenwlog=`
cat $logfile_mkcrcle_circle | grep cohcca | awk 'BEGIN{
code1="'"$code1"'"; code2="'"$code2"'"}{iorder=$2
if(iorder==1){    if($7==code1&&$8==code2){print $0}}}'`
fac_r=`echo $buf_mkcrcl_unevenwlog | awk '{print $5}'`
fac_i=`echo $buf_mkcrcl_unevenwlog | awk '{print $6}'`
paste $FILES| awk 'BEGIN{fac_r=1.*"'"$fac_r"'"; fac_i=1.*"'"$fac_i"'"
}{freq=$1;bunshi_r=$2;bunshi_i=$3;bunbo1=$6;bunbo2=$10;b1b2=bunbo1*bunbo2
if(b1b2!=0){printf "%e\t%e\t%e\n",freq,
(bunshi_r*fac_r-bunshi_i*fac_i)/sqrt(b1b2),
(bunshi_r*fac_i+bunshi_i*fac_r)/sqrt(b1b2)
}}'> $outfile_cmplxcoh.$filetail_cca1st
echo "OUTPUT (for Complex Coherence) " $outfile_cmplxcoh.$filetail_cca1st

fi # if [ $idcca -eq 1 ]

fi # [ $idok -eq 1 ]

let j=j+1
done
let i=i+1
done

################################################
# SPAC Processing for each rc0
################################################
radius_cohcca=`cat $seisfile_cohcca | awk '{print $1}' | sort -n | uniq`
for rc0 in $radius_cohcca
do
nrc0=`cat $seisfile_cohcca | awk 'BEGIN{rc0="'"$rc0"'";i=0}{if($1==rc0){i=i+1}}END{print i}'`

if [ $nrc0 -ge $llim_npairs_cohs ]
then
FILES_CMPLXCOH=`cat $seisfile_cohcca | awk 'BEGIN{rc0="'"$rc0"'"}{if($1==rc0){print $7}}'`
filetail=_R$rc0"$nrc0"p

#------
# Directional averaging complex Coherences
#------
idok=1
avefile=${spr_spacfile%.*}$filetail.d
avetmpfile=$avefile.tmp

if test "$rc0_cca" == "$rc0"
then

sprspacfile4nccca=$avefile

else # if test "$rc0_cca" == "$rc0"

if [ $idcohcca_spaclevel -eq 1 ]
then
idok=0
fi 

id_radius_root3=`cat $seisfile_cohcca | grep $rc0 | tail -1 | awk 'BEGIN{
eps=0.01; radius_cca=1.*"'"$radius_cca"'"}{r=$2
res=sqrt(((r/radius_cca)-sqrt(3))^2)
if(res<eps){print 1}else{print 0}}'`
if [ $id_radius_root3 -eq 1 ]
then
sprspacfile4nccca_nocenter3st=$avefile
fi

fi # if test "$rc0_cca" == "$rc0"

if [ $idok -eq 1 ]
then

if [ -f $avefile ]
then
rm -f $avefile
fi
touch -f $avefile
nfile=0
for file in $FILES_CMPLXCOH 
do
paste $file $avefile | awk '{print $1,$2+$5}' > $avefile.1
mv -f $avefile.1 $avefile
let nfile=nfile+1
done
cat $avefile | awk 'BEGIN{nfile=1.*"'"$nfile"'"}{d=$2/nfile
printf "%20.10e %20.10e\n", $1,d}' > $avefile.1
mv -f $avefile.1 $avefile
echo "OUTPUT (for Average Coherence) " $avefile

#------
# Phase Veolocity
#------
outfile=${vel_spacfile%.*}$filetail.d
rc0_realnumber=`cat $seisfile_cohcca |\
awk 'BEGIN{rc0="'"$rc0"'";sum=0;n=0}{if($1==rc0){n=n+1; sum=sum+$2}}END{print sum/n}'`
echo "OUTPUT (for Phase Velocity for average radius $rc0_realnumber [km]) " $outfile
#dfmin=`   cat $avefile | sed -n '1,1'p | awk '{printf "%f\n",$1}'`
#freq_max=`cat $avefile | tail -1       | awk '{printf "%f\n",$1}'`
cat $avefile | awk 'BEGIN{
printf "1 "'"$rc0_realnumber"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
print $0}' | $bindir/sctr2pv > $outfile
fi   # [ $idok -eq 1 ]

fi   # [ $nrc0 -ge $llim_npairs_cohs ]

done # for rc0

################################################
# CCA Processing 
################################################
if [ $idccaflag -lt $llim_npairs_cohs ]
then

echo "NOTE: The number of seismometers placed along a circle less than $llim_npairs_cohs."
echo "      CCA Processing will not be made."  

else # if [ $idccaflag -lt $llim_npairs_cohs ]

FILES=`cat $seisfile_cohcca | awk '{if($5!=999&&$6!=999){printf "%s\n",$7}}'`
#filetail=_R$rc0_cca"$nseis"st
filetail=""
sprcohccafile=${spr_ccafile%.*}$filetail.d
velcohccafile=${vel_ccafile%.*}$filetail.d
velcohncccafile=${vellwapx_ccafile%.*}$filetail.d
sprcohh0file=${spr_h0file%.*}$filetail.d
sprcohh1file=${spr_h1file%.*}$filetail.d
nsrcohncccafile=${nsrlwapx_ccafile%.*}$filetail.d
nsrlim_vfile0cohncccafile=${nsrlim_vfile0%.*}$filetail.d

#---------------------
# create spr_h0 and _h1 files 
#---------------------
for file in $sprcohh0file $sprcohh1file
do
if [ -f $file ]
then
rm -f $file
fi
touch -f $file
done

# a (weighted) sum of coherences between stations having a uniform distance.
for file in $FILES
do
paste $file.$filetail_cca0th $sprcohh0file                  | awk '{
printf "%20.10e %20.10e\n",$1,$2+$5}' > $sprcohh0file.1
paste $file.$filetail_cca1st $sprcohh1file | awk '{
printf "%20.10e %20.10e\n",$1,$2+$5}' > $sprcohh1file.1
mv -f $sprcohh0file.1 $sprcohh0file
mv -f $sprcohh1file.1 $sprcohh1file
done

const0=`cat $logfile_mkcrcle_circle | grep cohcca | awk 'BEGIN{
sum=0}{iorder=$2 ;ar=$5 ;ai=$6
if(iorder==0&&$7==$8){sum=sum+ar}
}END{print sum}'`
const1=`cat $logfile_mkcrcle_circle | grep cohcca | awk 'BEGIN{
sum=0}{iorder=$2 ;ar=$5 ;ai=$6
if(iorder==1&&$7==$8){sum=sum+ar}
}END{print sum}'`
cat $sprcohh0file | awk 'BEGIN{const=1.*"'"$const0"'"}{
d=2*$2+const
printf "%20.10e %20.10e\n", $1,d}' > $sprcohh0file.1
cat $sprcohh1file | awk 'BEGIN{const=1.*"'"$const1"'"}{
d=2*$2+const
printf "%20.10e %20.10e\n", $1,d}' > $sprcohh1file.1
mv -f $sprcohh0file.1 $sprcohh0file
mv -f $sprcohh1file.1 $sprcohh1file

# spr h0
echo "OUTPUT (for H0) " $sprcohh0file
# spr h1
echo "OUTPUT (for H1) " $sprcohh1file

# spr cca
paste $sprcohh0file $sprcohh1file | awk '{
if($4==0){
printf "%e %e\n",$1,1.e18}
else{
printf "%e %e\n",$1,$2/$4}
}' > $sprcohccafile
echo "OUTPUT (for CCA) " $sprcohccafile

# vel cca
echo "OUTPUT (for CCA) " $velcohccafile
cat $sprcohccafile | awk 'BEGIN{
printf "5 "'"$radius_cca"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
print $0}' | $bindir/sctr2pv > $velcohccafile

if [ $id_center -eq 1 ]
then
# nsr by cca and spac with radius r
##########################################################
# ʲϢΩĹĹƲ.
# rhospac=J0(ax)/[1+e]
# rhocca=[J0(x)^2+e/n]/[J1(x)^2+e/n]
# -->
# rhospac=[1-(ax)^2/4]/[1+e]
# rhocca =[1-(x^2/2)+e/n]/[x^2/4+e/n]
# -->
# x=2sqrt([rhocca-1-(rhocca+n-1)rhospac]/[a^2(rhocca-1)-n(rhocca+2)rhospac])
# e=n[a^2+(2+rhocca)(rhospac-1)]/[a^2(rhocca-1)-n(rhocca+2)rhospac]
# i.e.,
# c=fr
#   *Sqrt([a^2(rhocca-1)-n(rhocca+2)rhospac]/[rhocca-1-(rhocca+n-1)rhospac])
# ()synthetic dataѤƤ̤ˤ, ˡ
#  򤯤nsrοͤϤޤBIDOѤƤˡ(Cho et al., 2006, JGR)
#  ٤ûĹ¦ǷŪ˲ɾ뷹뤳Ȥʬä. 
#  (BIDOƱΥץȷΥǤ15rʲ). ̤ǧ.
#  , ®٤ˤϤۤȤBIASϤʤ褦Ǥ. (2012/12/15)
##########################################################
paste $sprcohccafile $sprspacfile4nccca | awk 'BEGIN{
pi=3.14159265; r=1.*"'"$radius_cca"'"; nseis=1.*"'"$nseis"'"
a=pi*r}{f=$1;rhocca=$2;rhospac=$4;
bunshi=rhocca-1-nseis*(rhocca+2)*rhospac
bunbo=rhocca-1-(rhocca+nseis-1)*rhospac
if(bunbo!=0){
if(bunshi/bunbo>0){
c=a*f*sqrt(bunshi/bunbo)
printf "%e %e\n",f,c}}
}'   > $velcohncccafile 
echo "OUTPUT (for CCA) " $velcohncccafile

paste $sprcohccafile $sprspacfile4nccca | awk 'BEGIN{
r=1.*"'"$radius_cca"'"; nseis=1.*"'"$nseis"'"
}{f=$1;rhocca=$2;rhospac=$4;
bunshi=nseis*(1+(2+rhocca)*(rhospac-1))
bunbo=rhocca-1-nseis*(rhocca+2)*rhospac
if(bunbo!=0){
bb=bunshi/bunbo
# output positive value only 
#if(bb>0){
printf "%e %e\n",f,bb}
#}
}'   > $nsrcohncccafile
echo "OUTPUT (for CCA) " $nsrcohncccafile

cat $nsrcohncccafile | awk 'BEGIN{
printf "%s,%s\n", "'"$radius_cca"'","'"$nseis"'"
printf "%s\n","'"$nsrlim"'"
}{print $1,$2}' | $bindir/calcmax  > $nsrlim_vfile0cohncccafile
echo "OUTPUT (for CCA) " $nsrlim_vfile0cohncccafile

if [ $idoutput_snpowfile -eq 1 ]
then
# Noise and Signal Powers
powfile=$outputdir2/SD1u_SD1u.d
. script/chkfile.sh $powfile
freq_interporate=`cat $logfile_estspec_psd | grep 'Frequency interval' | tr ':' ' ' | awk '{printf "%s",$3}'`
for file in $powfile $nsrcohncccafile
do
if [ -f $file ] 
then
$bindir/linearint2_log <<EOF > $file.lint
$file
$freqmax_ave
$freq_interporate
EOF
fi
done
echo "OUTPUT (for signal power) " $pow_signal_file
paste $powfile.lint $nsrcohncccafile.lint | grep -iv n | awk '{pow=$2;eps=$4
if(pow!=999&&$eps!=999){
p=pow/(1+eps)               ; printf "%e\t%30.20f\n",$1,p}}' > $pow_signal_file
echo "OUTPUT (for noise power)  " $pow_noise_file
paste $powfile.lint $nsrcohncccafile.lint | grep -iv n | awk '{pow=$2;eps=$4
if(pow!=999&&$eps!=999){
if(eps!=0){bunbo=1+1/eps
p=pow/bunbo; printf "%e\t%30.20f\n",$1,p}}}'> $pow_noise_file
fi # if [ $idoutput_snpowfile -eq 1 ]
fi # if [ $id_center -eq 1 ]

if [ $idcohcca_ccalevel -ge 2 ]
then
velcohh0file=$outputdir2/vel_h0.d
velcohh1file=$outputdir2/vel_h1.d
nsrcohh1file=$outputdir2/nsr_h1.lwapx.d

# vel h0
echo "OUTPUT (for H0) " $velcohh0file
cat $sprcohh0file | awk 'BEGIN{
printf "2 "'"$radius_cca"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
print $0}' | $bindir/sctr2pv > $velcohh0file

# vel h1
echo "OUTPUT (for H1) " $velcohh1file
cat $sprcohh1file | awk 'BEGIN{
printf "3 "'"$radius_cca"'" "'"$dfmin"'" "'"$freq_max"'"\n"}{
print $0}' | $bindir/sctr2pv > $velcohh1file

if [ $nseis -ge 3 ] 
then
##########################################################
# ʲϢΩĹĹƲ.
# rhoh0=[J0(x)^2+efac*e/n]/[1+e]
# rhoh1=[J1(x)^2+efac*e/n]/[1+e]
# , n=3 && efac=~1
# efac=1x, eȤʤ. efac
# 1˶ᤤͤȤƶ.
# -->
# x=Sqrt[4-4rhoh0+4rhoh1
#   +4n*rhoh0(-1+rhoh0+2rhoh1)/(-3efac+n*rhoh0+2n*rhoh1)
#   -4n*rhoh1(-1+rhoh0+2rhoh1)/(-3efac+n*rhoh0+2n*rhoh1)]/Sqrt[3]
#  =2/Sqrt[3]*Sqrt[1-rhoh0+rhoh1
#                 +n*rhoh0(-1+rhoh0+2rhoh1)/(-3efac+n(rhoh0+2rhoh1))
#                 -n*rhoh1(-1+rhoh0+2rhoh1)/(-3efac+n(rhoh0+2rhoh1))]
# e=-(-1+rhoh0+2rhoh1)/(-3efac/n+rhoh0+2rhoh1)
# i.e., 
# c=2rf/x
#  =Sqrt[3]rf/Sqrt[1-rhoh0+rhoh1
#                 +n*rhoh0(-1+rhoh0+2rhoh1)/(-3efac+n(rhoh0+2rhoh1))
#                 -n*rhoh1(-1+rhoh0+2rhoh1)/(-3efac+n(rhoh0+2rhoh1))]
##########################################################
efac=0.9
paste $sprcohh0file $sprcohh1file | awk 'BEGIN{
efac=1.*"'"$efac"'";nseis=1.*"'"$nseis"'"; a=efac*3/nseis}{
rhoh0=$2;rhoh1=$4;
b=rhoh0+2*rhoh1
eps=-(-1+b)/(-a+b)
# output positive value only 
if(eps>0){  
printf "%e %e\n",$1,eps
}
}' > $nsrcohh1file.3st
echo "OUTPUT (for H0 & H1) " $nsrcohh1file.3st

paste $sprcohh0file $sprcohh1file | awk 'BEGIN{
pi=3.14159265; r=1.*"'"$radius_cca"'";efac=1.*"'"$efac"'"
nseis=1.*"'"$nseis"'";root3=sqrt(3);a=root3*pi*r}{
f=$1;rhoh0=$2;rhoh1=$4
bunbo=-3*efac+nseis*(rhoh0+2*rhoh1)
if(bunbo!=0){
com=nseis*(-1+rhoh0+2*rhoh1)/bunbo
term1=1-rhoh0+rhoh1
term2=rhoh0*com
term3=rhoh1*com
sqrt1=term1+term2-term3
if(sqrt1>0){
c=a*f/sqrt(sqrt1)
printf "%e %e\n",$1,c}}
}' > $velcohncccafile.3st 
echo "OUTPUT (for H0 & H1)" $velcohncccafile.3st

#cat $nsrcohh1file.3st | awk 'BEGIN{
#printf "%s,%s\n", "'"$radius_cca"'","'"$nseis"'"
#printf "%s\n","'"$nsrlim"'"
#}{print $1,$2}' | $bindir/calcmax  > $nsrlim_vfile0cohncccafile.3st
#echo "OUTPUT (for CCA) " $nsrlim_vfile0cohncccafile.3st

fi # if [ $nseis -ge 3 ] 

if [ $nseis -gt 3 ] # nseis=3λϰʲμϻȤʤ
then
# nsr by h0 & h1 with radius r
##########################################################
# ʲϢΩĹĹƲ.
# rhoh0=[J0(x)^2+e/n]/[1+e]
# rhoh1=[J1(x)^2+e/n]/[1+e]
# -->
# rhoh0=[1-x^2/2+e/n]/[1+e]
# rhoh1=[x^2/4  +e/n]/[1+e]
# -->
# e=(n-3)/(n(rhoh0+2rhoh1)-3)-1
# x=2Sqrt[(1-rhoh0+(1-n)rhoh1)/(3-n(rhoh0+2rhoh1))]
# i.e.,
# c=2f/x=f/x
#  =f*Sqrt[(3-n(rhoh0+2rhoh1))/(1-rhoh0+(1-n)rhoh1)]
##########################################################
paste $sprcohh0file $sprcohh1file | awk 'BEGIN{nseis=1.*"'"$nseis"'"}{
rhoh0=$2;rhoh1=$4;
eps=(nseis-3)/(nseis*(rhoh0+2*rhoh1)-3)-1
# output positive value only 
if(eps>0){  
printf "%e %e\n",$1,eps
}
}' > $nsrcohh1file.5st
echo "OUTPUT (for H0 & H1) " $nsrcohh1file.5st

paste $sprcohh0file $sprcohh1file | awk 'BEGIN{
pi=3.14159265; r=1.*"'"$radius_cca"'";nseis=1.*"'"$nseis"'";a=pi*r}{
f=$1;rhoh0=$2;rhoh1=$4;
bunbo=3-nseis*(rhoh0+2*rhoh1)
if(bunbo!=0){
sqrt1=(1-rhoh0+(1-nseis)*rhoh1)/bunbo
if(sqrt1>0){
c=a*f/sqrt(sqrt1)
printf "%e %e\n",$1,c
}}}'   > $velcohncccafile.5st 
echo "OUTPUT (for H0 & H1) " $velcohncccafile.5st

cat $nsrcohh1file.5st | awk 'BEGIN{
printf "%s,%s\n", "'"$radius_cca"'","'"$nseis"'"
printf "%s\n","'"$nsrlim"'"
}{print $1,$2}' | $bindir/calcmax  > $nsrlim_vfile0cohncccafile.5st
echo "OUTPUT (for CCA) " $nsrlim_vfile0cohncccafile.5st
fi # if [ $nseis -gt 3 ]
fi # if [ $idcohcca_ccalevel -ge 2 ]

fi # if [ $idccaflag -lt $llim_npairs_cohs ]
