#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<SPECRATIO HUDDLE>"

for comp in $COMPS
do
i=1
while [ $i -le $nseis_total ]
do
j=1
while [ $j -le $nseis_total ]
do

if [ $i -eq 1 -a $j -gt $i ]
then
idok=1
else
idok=0
fi  

if [ $idok -eq 1 ]
then
file1=$outputdir2/SD"$i""$comp"_SD"$j"$comp.d 
file2=$outputdir2/SD"$i""$comp"_SD"$i"$comp.d 
file3=$outputdir2/SD"$j""$comp"_SD"$j"$comp.d 
FILES="$file1 $file2 $file3"
outfile=$outputdir2/MSQcoh"$i"_"$j"$comp.d 
outfile_ns=$outputdir2/NSR"$i"_"$j"$comp.d 
outfile_noisepow=$outputdir2/PSD_NOISE"$i"_"$j"$comp.d 
outfile_signalpow=$outputdir2/PSD_SIGNAL"$i"_"$j"$comp.d 
outfile_phase=$outputdir2/PHASE"$i"_"$j"$comp.d 

for file in $FILES;do
. script/chkfile.sh $file; done

echo "OUTPUT (for Magnitude Squared Coherence) " $outfile
paste $FILES| awk '{freq=$1;bunshi_r=$2;bunshi_i=$3;bunbo1=$6;bunbo2=$10;
if(bunbo1*bunbo2!=0){printf "%g\t%g\n",freq,
(bunshi_i^2+bunshi_r^2)/(bunbo1*bunbo2)
}}'> $outfile

echo "OUTPUT (for NSR) " $outfile_ns
paste $FILES| awk '{
freq=$1;bunshi_r=$2;bunshi_i=$3;bunbo1=$6;bunbo2=$10;
bunshi=bunshi_i^2+bunshi_r^2
if(bunbo1*bunbo2!=0&&bunshi!=0){
gamma2=bunshi/(bunbo1*bunbo2)
gamma=sqrt(gamma2)
nsr=(1-gamma)/gamma     # from Eq (6) of Carter et al.(1973)
#nsr=(1-gamma2)/gamma2  # from Eq (8) of Carter et al.(1973)
printf "%g\t%g\n",freq,nsr
}}'> $outfile_ns

echo "OUTPUT (for Noise Power) " $outfile_noisepow
paste $FILES| awk '{
freq=$1;bunshi_r=$2;bunshi_i=$3;bunbo1=$6;bunbo2=$10;
bunshi=bunshi_i^2+bunshi_r^2
bb12=bunbo1*bunbo2
if(bb12!=0&&bunshi!=0){
gamma2=bunshi/bb12
gamma=sqrt(gamma2)
nsr=(1-gamma)/gamma     # from Eq (6) of Carter et al.(1973)
#nsr=(1-gamma2)/gamma2  # from Eq (8) of Carter et al.(1973)
npow=sqrt(bb12)*nsr
printf "%g\t%g\n",freq,npow
}}'> $outfile_noisepow

echo "OUTPUT (for Phase Difference) " $outfile_phase
paste $FILES| awk 'BEGIN{pi=4.0*atan2(1.0,1.0);d2r=pi/180.}{
freq=$1;bunshi_r=$2;bunshi_i=$3
phase=atan2(bunshi_i,bunshi_r)/d2r
printf "%g\t%g\n",freq,phase
}'> $outfile_phase

fi 

let j=j+1
done
let i=i+1
done
done
