#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<SPECRATIO for horizontal components>"

#------------------------------ 
# new Love 5.23 (CCA-L)
FILES="$outputdir2/T1r_T0r.d $outputdir2/R1r_T0r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for CCA-L) " $sprh_cca_minus_L
paste $FILES|$bindir/spr4h|awk '{printf "%s %s 999.\n",$1,$3}'>$sprh_cca_minus_L
#echo "[CAUTION! ONLY IMAGINARY PART EXTRACTED]"
#------------------------------ 

#------------------------------ 
# eq7 rayleigh (CCA-R)
FILES="$outputdir2/R1r_R0r.d $outputdir2/T1r_R0r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for CCA-R) " $sprh_cca_minus_R
paste $FILES|$bindir/spr4h|awk '{printf"%s %e 999.\n",$1,-$3}'>$sprh_cca_minus_R
#echo "[CAUTION! ONLY IMAGINARY PART EXTRACTED WITH A SIGN CHANGE]"
#------------------------------ 

#------------------------------ 
# Power partition ratio of H/V component of Rayleigh waves
if [ $idcomp -eq 3 ]
then
id=1
FILES="$outputdir2/Z1r_Z1r.d $outputdir2/R0r_R0r.d"
for file in $FILES;do
if [ ! -f $file ] ;then
id=0
fi
done
if [ $id -eq 1 ]; then
echo "OUTPUT (for R/V) " $AmpRV_R
paste $FILES | awk '{freq=$1;bunshi=$6;bunbo=$2
if(bunbo!=0){printf "%f\t%f\n",freq,sqrt(bunshi/bunbo)}}' > $AmpRV_R
# Cho (2005,SEGJ, eq.36) or Cho et al. (2006, GJI, eq.E4)
fi
fi
#------------------------------ 

if [ $id_center -eq 1 ]
then
#------------------------------ 
# SPAC-L
FILES="$outputdir2/T1r_T0r.d $outputdir2/T10_T0r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for SPAC-L) " $sprh_spac_minus_L
paste $FILES | $bindir/spr4h > $sprh_spac_minus_L
#------------------------------ 

#------------------------------ 
# SPAC+L
FILES="$outputdir2/R1r_T0r.d $outputdir2/R10_T0r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for SPAC+L) " $sprh_spac_plus_L
paste $FILES | $bindir/spr4h  > $sprh_spac_plus_L
#------------------------------ 

#------------------------------ 
# SPAC-R
FILES="$outputdir2/R1r_R0r.d $outputdir2/R10_R0r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for SPAC-R) " $sprh_spac_minus_R
paste $FILES | $bindir/spr4h  > $sprh_spac_minus_R
#------------------------------ 

#------------------------------ 
# SPAC+R
FILES="$outputdir2/T1r_R0r.d $outputdir2/T10_R0r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for SPAC+R) " $sprh_spac_plus_R
paste $FILES | $bindir/spr4h  > $sprh_spac_plus_R
#------------------------------ 

#------------------------------ 
# Power partition ratio of Rayl to Love waves
id=1
FILES="
$outputdir2/Z00_Z00.d
$outputdir2/R0r_R0r.d
$outputdir2/Z1r_Z1r.d
$outputdir2/R10_R10.d"
for file in $FILES
do
if [ ! -f $file ] ;then
id=0
fi
done
if [ $id -eq 1 ]; then
echo "OUTPUT (for R/(R+L)) " $powratio_R2L
paste $FILES | awk '{freq=$1;bunshi=$2*$6;bunbo=4.*$10*$14
if(bunbo!=0){printf "%f\t%f\n",freq,bunshi/bunbo}}' > $powratio_R2L
fi
#------------------------------ 

#------------------------------ 
# NSR
# type R 
FILES="
$outputdir2/R10_R0r.d
$outputdir2/R10_R10.d
$outputdir2/R10_R1r.d
$outputdir2/R10_T0r.d
$outputdir2/R1r_R0r.d
$outputdir2/R1r_R1r.d
$outputdir2/R1r_T0r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
#echo "OUTPUT (for NSR_H: TYPE R) " $nsrfile_h_typer
echo "OUTPUT (for NSR_H) " $nsrfile_h_typer
paste $FILES | awk 'BEGIN{print 1,"'"$nseis"'"}{
if($1!=0){print $0}}' | $bindir/nsr_h  > $nsrfile_h_typer

## type B (both R and T)
#FILES="
#$outputdir2/R10_R0r.d
#$outputdir2/R10_R10.d
#$outputdir2/R10_R1r.d
#$outputdir2/R10_T0r.d
#$outputdir2/R1r_R0r.d
#$outputdir2/R1r_R1r.d
#$outputdir2/R1r_T0r.d
#$outputdir2/R10_T10.d
#$outputdir2/R1r_T1r.d
#$outputdir2/T10_R0r.d
#$outputdir2/T10_T0r.d
#$outputdir2/T10_T1r.d
#$outputdir2/T1r_R0r.d
#$outputdir2/T1r_T0r.d
#$outputdir2/T1r_T1r.d"
#for file in $FILES;do
#. script/chkfile.sh $file; done
#echo "OUTPUT (for NSR_H: TYPE B) " $nsrfile_h_typeb
#paste $FILES | awk 'BEGIN{print 2,"'"$nseis"'"}{
#if($1!=0){print $0}}' | $bindir/nsr_h  > $nsrfile_h_typeb
#------------------------------ 

fi # id_center
