#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<SPECRATIO>"

#------------------------------ 
# CCA
if [ $nseis -ne 1 -a $nseis -ne 2 ]
then
FILES="$outputdir2/Z0r_Z0r.d $outputdir2/Z1r_Z1r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for CCA) " $spr_ccafile
paste $FILES| awk '{if($5!=0){freq=$1;printf "%g\t%g\n",freq,$2/$6}}'> $spr_ccafile
fi
#------------------------------ 

if [ $id_center -eq 1 ]
then

#------------------------------ 
# Orignal SPAC
FILES="$outputdir2/Z0r_Z00.d $outputdir2/Z00_Z00.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for SPAC) " $spr_spacfile
paste $FILES| awk '{if($5!=0){freq=$1;printf "%g\t%g\n",freq,$2/$6}}'> $spr_spacfile
#------------------------------ 

if test "$id_miniature_array" != "1"
then
#------------------------------ 
# h0
FILES="$outputdir2/Z0r_Z0r.d $outputdir2/Z00_Z00.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for H0) " $spr_h0file
paste $FILES| awk '{if($5!=0){freq=$1;printf "%g\t%g\n",freq,$2/$6}}'> $spr_h0file
#------------------------------ 
fi

if [ $nseis -ne 1 -a $nseis -ne 2 ]
then
#------------------------------ 
# amplitude-squared coherence between circle0 and center
FILES="$outputdir2/Z0r_Z00.d $outputdir2/Z00_Z00.d  $outputdir2/Z0r_Z0r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for MSC) " $cohfile
paste $FILES| awk '{product=$6*$10; if($5!=0&&product!=0){freq=$1;
printf "%g\t%g\n",freq,($2^2+$3^2)/product}}' > $cohfile
#------------------------------ 

#------------------------------ 
# NSR
. script/chkfile.sh $Z1rfile.log
radius=`cat $Z0rfile.log | sed -n '1,1'p | awk '{printf "%f",$4}'`
echo "Array radius: $radius [km][from $Z0rfile.log]"
FILES="$cohfile $spr_spacfile $spr_ccafile"
for file in $FILES;do
. script/chkfile.sh $file
done
echo "OUTPUT (for NSR_Z) " $nsrfile
paste $FILES | awk 'BEGIN{
printf "%s\n","'"$nsrlim_vfile0"'"
print "'"$radius"'","'"$nseis"'"}{
if($1!=0){print $0}}' | $bindir/calnsr_J0 > $nsrfile
if [ $idcmax_by_nsr -ne 1 ];then
rm -f $nsrlim_vfile0
fi
#------------------------------ 

#------------------------------ 
# Noise and Signal Powers
powfile=$outputdir2/Z00_Z00.d
tmpfile=$outputdir2/tmpnspow.d; rm -f $tmpfile
. script/chkfile.sh $powfile
cat   $powfile | awk '{if($1!=0){print $0}}' > $tmpfile
echo "OUTPUT (for signal power) " $pow_signal_file
echo "OUTPUT (for noise power)  " $pow_noise_file
paste $tmpfile $nsrfile | grep -v 'NO ROOT' | awk '{pow=$2;eps=$6
if(eps!=0.0){p=pow/(1+1/eps); printf "%e\t%30.20f\n",$1,p}}' > $pow_noise_file
paste $tmpfile $nsrfile | grep -v 'NO ROOT' | awk '{pow=$2;eps=$6
p=pow/(1+eps)               ; printf "%e\t%30.20f\n",$1,p}'  > $pow_signal_file; rm -f $tmpfile
#------------------------------ 

#------------------------------ 
# Arriving Direction & R/V Phase 
#echo "OUTPUT (for Rayleigh-wave arriving direction) " $directionfile
#infile=$outputdir2/Z00_Z1r.d
#cat $infile| $bindir/spec2direc | awk '{
#printf "%g\t%g\n",$1,$3-90.}'   | $bindir/correct360 > $directionfile
#
#infile=$outputdir2/Z00_R10.d
#if [ -f $infile ]
#then
#echo "OUTPUT (for Rayleigh-wave r/v phase) " $rvphasefile
#cat $infile| $bindir/spec2direc | awk '{
#printf "%g\t%g\n",$1,$3}'       | $bindir/correct360 > $rvphasefile.tmp
#paste $rvphasefile.tmp $directionfile | awk '{print $1,$2-$4-180.
#}' | $bindir/correct360 > $rvphasefile
#rm -f $rvphasefile.tmp
#fi
#------------------------------ 

if test "$id_miniature_array" != "1"
then
#------------------------------ 
# h1
FILES="$outputdir2/Z1r_Z1r.d $outputdir2/Z00_Z00.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for H1) " $spr_h1file
paste $FILES| awk '{if($5!=0){freq=$1;printf "%g\t%g\n",freq,$2/$6}}'> $spr_h1file
#------------------------------ 

#------------------------------ 
# V
FILES="$outputdir2/Z0r_Z00.d $outputdir2/Z1r_Z1r.d"
for file in $FILES;do
. script/chkfile.sh $file; done
echo "OUTPUT (for V) " $spr_vfile
paste $FILES| awk '{if($5!=0){freq=$1;printf "%g\t%g\n",freq,$2/$6}}'> $spr_vfile
#------------------------------ 
fi

fi # if nseis

fi # id_center
