#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo "<MKSEGMENT>"

#ovlpratio=0.

if test "$ovlpratio" == ""
then
    ovlpratio=0.5
    echo "Note: A parameter ovlpratio is not defined."
    echo "      Automatically set to $ovlpratio."
else
    echo "Note: A parameter ovlpratio is set to $ovlpratio."
fi

# Check parameters
if test "$segment_duration" == ""
then
echo ERROR segment_duration not defined. STOP
exit 1
fi
if test "$delta_t" == ""
then
echo ERROR delta_t not defined. STOP
exit 1
fi

# 0 normal selection/1 enforced to select all segments
if test "$idselectionflag_mksegment_BIDO" == ""
then
idselectionflag_mksegment_BIDO=0
else # if test "$idselectionflag_mksegment_BIDO" == ""
if test "$idselectionflag_mksegment_BIDO" == "1"
then
echo "Warning: idselectionflag_mksegment_BIDO is set to 1. "
echo "         Automatic selection is enforced to select all segments"
fi # if test "$idselectionflag_mksegment_BIDO" == "1"
fi # if test "$idselectionflag_mksegment_BIDO" == ""


if [ -f $segmentfile ]
then
    echo File named $segmentfile already exists.
    yn=""
    while [ "$yn" != "y" -a "$yn" != "Y" -a "$yn" != "n" -a "$yn" != "N" ]
      do
      echo "The option \"automatic selection of data portions\" on."
      echo "The file $segmentfile will be overwritten."
      echo "Are you sure to proceed? [y/n]"
      echo "(Type \"n\" to exit. Restart the program run.sh and set the option \"automatic selection of data portions\" off.)"

      if [ $idsilent -eq 0 ];then
	  read yn
      else
	  yn="y"
      fi
	  
      if test "$yn" != "y" -a "$yn" != "Y" -a "$yn" != "n" -a "$yn" != "N" 
	  then
	  echo "Type [y/n]"
      elif test "$yn" == "N" -o "$yn" == "n"  
	  then
	  echo idmksegment=0 >> $datadir/$paramfile
	  echo Abort.
	  exit 1
      fi

    done
fi

#---------------------------------------------------------------------------------------
# Create a segment file, which takes the parts having the most frequent value of RMS+-1
#---------------------------------------------------------------------------------------
# create RMS files
outputdir_codecomprmsall=$outputdir/rmsall.d
if [ -f $outputdir_codecomprmsall ]
then
rm -f $outputdir_codecomprmsall
fi
touch -f $outputdir_codecomprmsall

for code in $CODES;do
for comp in $comps;do

outputdir_code=$datadir/$code
outputdir_codecomprms=$outputdir/$code.$comp.rms
outputdir_codecomprms_dir=${outputdir_codecomprms%/*}

if [ ! -d $outputdir_codecomprms_dir ]
then
mkdir -p $outputdir_codecomprms_dir
fi

$bindir/evalrms <<EOF
$segment_duration
$delta_t
0
$ovlpratio
0
$comp
$outputdir_code
$outputdir_codecomprms
EOF
cat $outputdir_codecomprms | sed '1,1d' | awk '{
print $2}' >> $outputdir_codecomprmsall
done;done

idrecalc=1
ave=1.e18
idrecalcno=1
while [ $idrecalc -eq 1 -a $idrecalcno -le 3 ]
do
# Taking Avarage and ST.D. again using data having rms values smaller than ave x 2
buf=`cat $outputdir_codecomprmsall | awk 'BEGIN{n=0;sum=0;sumsq=0
ave=1.*"'"$ave"'";ulim=ave*2}{
d=$1;dsq=d^2
if(d<=ulim){n=n+1;sum=sum+d;sumsq=sumsq+dsq}
}END{ave=sum/n; uvar=(sumsq-n*ave^2)/(n-1); std=sqrt(uvar)
if(std>=ave){idrecalc=1}else{idrecalc=0}
printf "%e %e %d %d",ave,std,idrecalc,n
}'`

ave=`echo $buf | awk '{print $1}'`
std=`echo $buf | awk '{print $2}'`
idrecalc=`echo $buf | awk '{print $3}'`
kosu=`echo $buf | awk '{print $4}'`
#echo $ave $std $idrecalc $kosu
let idrecalcno=idrecalcno+1
done

RMS_ratio_min=`echo $ave $std | awk 'BEGIN{fac=1.*"'"$RMS_STDFAC"'"
}{printf "%e",$1-$2*fac}'`
RMS_ratio_max=`echo $ave $std | awk 'BEGIN{fac=1.*"'"$RMS_STDFAC"'"
}{printf "%e",$1+$2*fac}'`

if [ $idselectionflag_mksegment_BIDO -eq 0 ]
then
echo Waveform segments with RMS ratios between $RMS_ratio_min and $RMS_ratio_max will be selected.
fi


rm -f $outputdir_codecomprmsall

# Final process to make segment file
infile=$segmentfile.input; rm -f $infile
echo 10000                           > $infile
echo $idselectionflag_mksegment_BIDO >> $infile
echo $segment_duration               >> $infile
echo $delta_t                        >> $infile
echo 0                               >> $infile
echo $ovlpratio                      >> $infile
echo $ncode                                           >> $infile
echo $RMS_ratio_min  $RMS_ratio_max                   >> $infile
for code in $CODES;do
for comp in $comps;do
echo $outputdir/$code.$comp.rms >> $infile
done;done
echo $segmentfile                                     >> $infile
cat $infile | $bindir/segment; rm -f $infile
echo "cat $infile | $bindir/segment; rm -f $infile"

# Clean the temoraly RMS files
for code in $CODES;do
for comp in $comps;do
rm -f $outputdir/$code.$comp.rms
done;done


if test "$do_ntest" == "1"
then

echo "Note: a parameter do_ntest is defined."
echo "      Normality test (only for the vertical component) is executed for the final selection."

i=0;for code in $CODES;do
let i=i+1
done

infile=$segmentfile.input
echo $i             > $infile
echo 1              >> $infile
for code in $CODES;do
echo $datadir/$code >> $infile
done
cat $segmentfile    >> $infile

nblock_orignal=`head -1 $segmentfile`

cat $infile | $bindir/do_ntest > $segmentfile.ntest
rm -f $infile

nblock_ntest=`head -1 $segmentfile.ntest`

echo $nblock_orignal $nblock_ntest | awk '{printf "      The number of segments has been chaged from %d to %d [%3.2f] after the test.\n",$1,$2,$2/$1}'

echo "A parameter do_ntest is defined." > "$segmentfile"_ntest.log
echo "Normality test (only for the vertical component) is executed for the final selection."                           >> "$segmentfile"_ntest.log
echo "-----------------------------"   >> "$segmentfile"_ntest.log
echo " segments originally selected"   >> "$segmentfile"_ntest.log
echo "-----------------------------"   >> "$segmentfile"_ntest.log
cat $infile                            >> "$segmentfile"_ntest.log
echo $nblock_orignal $nblock_ntest | awk '{printf "      The number of segments has been chaged from %d to %d [%3.2f] after the test.\n",$1,$2,$2/$1
}'                                     >> "$segmentfile"_ntest.log
echo "See the segmentfile updated: $segmentfile"  >> "$segmentfile"_ntest.log
rm -f $infile
mv -f $segmentfile.ntest $segmentfile 

fi # if test "$do_ntest" == "1"

#echo KKKKKKKK
#echo KKKKKKKK
#echo KKKKKKKK
#echo KKKKKKKK test the selection of segments
#echo \cp  /home/cho/segment_z.d $segmentfile
#\cp  /home/cho/segment_z.d $segmentfile
#echo KKKKKKKK
#echo KKKKKKKK
#echo KKKKKKKK
#echo KKKKKKKK

echo Note: `cat $segmentfile | head -n 1` segments have been selected.
