#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo ""
echo "<mkgnplt_esac.sh >"

gnpltfile_esac=plot_esac.gnplt

echo OUTPUT: $outputdir/$gnpltfile_esac

cd $outputdir 

if [ -f $gnpltfile_esac ]
then
rm -f $gnpltfile_esac 
fi
touch -f $gnpltfile_esac 

echo set term png                      >> $gnpltfile_esac
echo set output \"rayleigh_esac.png\" >> $gnpltfile_esac

files=`ls ave/vel_spac_R*.d`

cat <<EOF >> $gnpltfile_esac 
set title "Phase Velocity by ESAC"
set xrange [0:50]
set yrange [0:1] 
EOF

echo plot \\            >> $gnpltfile_esac
echo 0.013\*x ti \"WL13m\",\\ >> $gnpltfile_esac
echo 0.025\*x ti \"WL25m\",\\ >> $gnpltfile_esac
echo 0.040\*x ti \"WL40m\",\\ >> $gnpltfile_esac

for file in $files
do
echo "\"$file\""  w l  ti \"\",\\          >> $gnpltfile_esac
done

echo \"ave/vel_esac.d\"  ti \"esac\",\\   >> $gnpltfile_esac
echo \"ave/vel_ncspac.d\"  ti \"ncspac\"  >> $gnpltfile_esac
echo "#pause -1"                      >> $gnpltfile_esac

$GNUPLOT $gnpltfile_esac
cd -

