#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo ""
echo "<mkgnplt_array_esac.sh >"

echo OUTPUT: $outputdir/$gnpltfile_array

cd $outputdir 

if [ -f $gnpltfile_array ]
then
rm -f $gnpltfile_array 
fi
touch -f $gnpltfile_array 

if test "$gnpltprint" == "1"
then
echo set term png             >> $gnpltfile_array
echo set output \"array.png\" >> $gnpltfile_array
fi

cat<<EOF>> $gnpltfile_array
set title "Array Geometry"
EOF

basename=${seismfile##*/}
filename=${basename%.*}.d
cat ../$filename | grep -v '^#' | awk '{if($2!=""){filename=$3
code=split(filename,filearray,".d")
printf "set label \"%s\" at %f,%f\n", filearray[1],$1,$2
}}'>> $gnpltfile_array

echo "set xlabel \"x [km]\""               >> $gnpltfile_array
echo "set ylabel \"y [km]\""               >> $gnpltfile_array
echo "set size ratio -1"                   >> $gnpltfile_array
echo "plot \\"                             >> $gnpltfile_array
echo "\"../$filename\""   ti \"\"          >> $gnpltfile_array

if test "$gnpltprint" != "1"
then
echo pause -1        >> $gnpltfile_array
fi

$GNUPLOT $gnpltfile_array
cd -

