#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo ""
echo "<mkgnplt_array.sh>"

echo OUTPUT: $outputdir/$gnpltfile_array

cd $outputdir 

if [ -f $gnpltfile_array ]
then
rm -f $gnpltfile_array 
fi
touch -f $gnpltfile_array 

if test "$gnpltprint" == "1"
then
echo set term png             >> $gnpltfile_array
echo set output \"array.png\" >> $gnpltfile_array
fi

basename=${seismlogfile##*/}
filename_log=${basename%.*}.log
x0=`cat $filename_log | grep 'CENTER POINT CALCULATED:' |\
 tr '(' ' ' | tr ')' ' ' | awk '{print $4}'`
y0=`cat $filename_log | grep 'CENTER POINT CALCULATED:' |\
 tr '(' ' ' | tr ')' ' ' | awk '{print $5}'`
radius=`cat $filename_log | grep 'RADIUS:' | awk '{printf "%s",$2}'`
echo $radius | awk '{r=$1
if(r==0)
{printf "set title \"Array Geometry\"\n"}
else if(r>=1)
{printf "set title \"Array Geometry with radius %g [km]\"\n",r}
else if(r>=0.001)
{printf "set title \"Array Geometry with radius %g [m]\"\n",1000*r}
else
{printf "set title \"Array Geometry with radius %g [cm]\"\n",100000*r}
}' >> $gnpltfile_array

basename=${seismfile##*/}
filename=${basename%.*}.d
cat ../$filename | grep -v '^#' | awk '{if($2!=""){filename=$3
code=split(filename,filearray,".d")
printf "set label \"%s\" at %f,%f\n", filearray[1],$1,$2
}}'>> $gnpltfile_array

echo $radius $x0 $y0 | awk '{r=$1;x0=$2;y0=$3;fac=1.1;halflen=r*fac
printf "set xrange [%f:%f]\n",x0-halflen,x0+halflen
printf "set yrange [%f:%f]\n",y0-halflen,y0+halflen
}' >> $gnpltfile_array

echo $x0 $y0 > center.d

echo $radius $x0 $y0 | awk 'BEGIN{pi2=3.141592*2;n=0;imax=40
dtheta=pi2/imax}{r=$1;x0=$2;y0=$3;
for(i=0;i<=imax;i++){
x=x0+r*cos(i*dtheta)
y=y0+r*sin(i*dtheta)
print x,y}}' > circle.d

echo "set xlabel \"x [km]\""               >> $gnpltfile_array
echo "set ylabel \"y [km]\""               >> $gnpltfile_array
echo "set size ratio -1"                   >> $gnpltfile_array
echo "plot \\"                             >> $gnpltfile_array
echo "\"./center.d\""     ti \"\",\\ >> $gnpltfile_array
echo "\"./circle.d\"" w l ti \"\",\\       >> $gnpltfile_array
echo "\"../$filename\""   ti \"\"          >> $gnpltfile_array

if test "$gnpltprint" != "1"
then
echo pause -1        >> $gnpltfile_array
fi

$GNUPLOT $gnpltfile_array
cd -

