#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

echo ""
echo "<mkgnplt.sh>"
echo "NOTE: This script uses a program gnuplot to plot the analysis results (all analysis results are contained in $outputdir). You can manually plot the same figures later, using a gnuplot macro, $gnpltfile, which was created by this script and is found in $outputdir. To do this, type cd $outputdir & gnuplot $gnpltfile" 

GNUPLOT_OPTION=`echo $GNUPLOT_VER | awk '{if($1>=4.3){print 1}else{print 0}}'`

if [ $GNUPLOT_OPTION -eq 1 ]
then
INSIDE="inside"
LTYPE="lc"
else
INSIDE=""
LTYPE="lt"
fi

if [ -f $Z0rfile.log ]
then
radius=`cat $Z0rfile.log | sed -n '1,1'p | awk '{printf "%f",$4}'`
elif [ -f $R0rfile.log ]
then
radius=`cat $R0rfile.log | sed -n '1,1'p | awk '{printf "%f",$4}'`
fi

for comp in $COMPS
do
n=1
done
#xmin=`head $avedir/SD$n"$comp"_SD$n"$comp".d|sed -n '1,1p'|awk '{print $1*2}'`
xmin=`grep 'Segment duration:' $avedir/ave.info | awk '{print 1/$3}'`
xmax_full=`tail $avedir/SD$n"$comp"_SD$n"$comp".d | tail -1 |awk '{print $1}'`
xmax=`echo $radius | awk '{r=$1
if     (r<=0.01) {xmax=20}
else if(r<=0.1)  {xmax=5}
else if(r<=1)    {xmax=2}
else             {xmax=1}
print xmax}'`

xmax_dum=`echo $xmax_for_gnuplot | awk '{if($1>0){printf "%f\n",$1}}'`
if test "$xmax_dum" != ""
then
xmax=$xmax_dum
xmax_full=$xmax_dum
fi

ymax=`echo $radius | awk '{r=$1
if     (r<0.01) {ymax=0.8}
else if(r<0.05) {ymax=1.5}
else if(r<0.1)  {ymax=3}
else            {ymax=5}
print ymax}'`

ymax_dum=`echo $ymax_for_gnuplot | awk '{if($1>0){printf "%f\n",$1}}'`
if test "$ymax_dum" != ""
then
ymax=$ymax_dum
fi

if test "$idcohcca" == "1" -a "$idhuddle" != "1"
then

FILES_V=""
FILES_COHCCA=`
cd $outputdir 
ls ave/vel_*.d`

else # if test "$idcohcca" == "1" -a "$idhuddle" != "1"

FILES_H_L=`
cd $outputdir
if [ -f ave/velh_cca_minus_L.d ] 
then
ls ave/velh_*_L.d
fi`

FILES_H_R=`
cd $outputdir
if [ -f ave/velh_cca_minus_R.d ] 
then
ls ave/velh_*_R.d
fi`

FILES_V=`
cd $outputdir
if [ -f ave/vel_spac.d -o -f ave/vel_cca.d ] 
then
ls ave/vel_*.d
fi`
FILES_COHCCA=""

fi # if test "$idcohcca" == "1" -a "$idhuddle" != "1"

FILES_NSR=`
cd $outputdir 
if [ -f ave/nsr.d ] 
then
ls ave/nsr*.d
#elif [ -f ave/nsr_h_typer.d ] 
elif [ -f ave/nsr_h.d ] 
then
ls ave/nsr*.d
fi`

cd $outputdir; echo 0 0 > ./dummy

if [ -f $gnpltfile ]
then
rm -f $gnpltfile
fi
touch -f $gnpltfile

echo OUTPUT: $outputdir/$gnpltfile

if test "$gnpltprint" == "1"
then
#echo set term postscript eps enhanced color >> $gnpltfile
#gnplt_file_extension="eps"
echo set term png >> $gnpltfile
gnplt_file_extension="png"
fi

printf "set xlabel \"Frequency [Hz]\"\nset ylabel \"Phase Velocity [km/s]\"\n" >> $gnpltfile
printf "set title \"Love Wave Velocities\"\n"              >> $gnpltfile
printf "#set key outside right\n"                               >> $gnpltfile
printf "set xrange [0:$xmax]\nset yrange [0:$ymax]\n "     >> $gnpltfile

if test "$FILES_H_L" != ""
then

if test "$gnpltprint" == "1"
then
echo set output \"love.$gnplt_file_extension\" >> $gnpltfile
fi

printf "plot " >> $gnpltfile
for fac in $FACS_RADIUS
do
echo $fac $radius | awk '{
printf "%d * %f * x ti \"%dr\",\\\n",$1,$2,$1}' >> $gnpltfile
done
for fac in $FACS_WL
do
echo $fac         | awk '{
printf "%f * x ti \"WL%g m\",\\\n",$1,$1}' >> $gnpltfile
done

# plot reference data
if test "`echo $vel_reference_love |awk '{print $1}'`" != ""
then
ifile=1
for file in $vel_reference_love 
do
echo $file $ifile | awk '{
printf "\"%s\" w l lw 2 ti \"Ref%d\",\\\n",$1,$2}'     >> $gnpltfile
let ifile=ifile+1
done
fi

for file in $FILES_H_L
do
basename=${file##*/}
filename=${basename%.*}
title=`echo $filename | sed 's/velh_//'`
echo $file $title | awk '{
printf "\"%s\" u 1:2:3 w errorbar ti \"%s\",\\\n",$1,$2}' >> $gnpltfile
done
printf "\"dummy\" ti \"\"\n"           >> $gnpltfile

if test "$gnpltprint" != "1"
then
printf "pause -1\n"                    >> $gnpltfile
else
printf "#pause -1\n"                   >> $gnpltfile
fi

fi

if test "$id_miniature_array" == "1"
then

if [ -f ave/vel_cca.d ]
then

if test "$gnpltprint" == "1"
then
echo set output \"rayleigh_cca.$gnplt_file_extension\" >> $gnpltfile
fi

printf "set title \"Rayleigh Wave Velocities by CCA\"\n"  >> $gnpltfile
echo | awk '{
printf "set xrange [0:20]\n"
printf "set yrange [0:0.8]\n"
printf "set ytics 0.1\n"
printf "set mytics 2\n"
printf "set grid\n"
printf "plot "
printf "0.013 * x ti \"WL13m(AVS10)\","
printf "0.025 * x ti \"WL25m(AVS20)\","
printf "0.04 * x ti \"WL40m(AVS30)\","
printf "0.1 * x ti \"WL100m\","
}'  >> $gnpltfile

if [ -f ave/$PSDRORFILE ]
then
echo | awk '{
printf "\"ave/%s\" u 1:(0.) ti \"Large-PSDR Ranges [%g>or<%g]\",\\\n",
"'"$PSDRORFILE"'",1.*"'"$PSDRLim2"'",1.*"'"$PSDRLim1"'"}'  >> $gnpltfile
fi

f=cmax_by_nsr.d
if [ -f ave/$f ]
then
echo $f | awk '{printf "\"ave/%s\" w l ti \"Upper limit for CCA\",\\\n",$1}'  >> $gnpltfile
fi

f=vel_nc-cca.d
if [ -f ave/$f ]
then
echo $f | awk '{printf "\"ave/%s\" w l ti \"nc-cca\",\\\n",$1}'  >> $gnpltfile
fi

cat <<EOF >> $gnpltfile
"ave/vel_cca.d" ti "cca"
EOF

if test "$gnpltprint" != "1"
then
printf "pause -1\n"                    >> $gnpltfile
else
printf "#pause -1\n"                   >> $gnpltfile
fi

fi   #if [ -f ave/vel_cca.d ]


else #if test "$id_miniature_array" == "1"


idok=0
if test "$FILES_H_R" != ""
then
idok=1
fi
if test "$FILES_V" != ""
then
idok=1
fi
if test "$FILES_COHCCA" != ""
then
idok=1
fi

if [ $idok -eq 1 ]
then

if test "$idcohcca" != "1"
then

if test "$gnpltprint" == "1"
then
echo set output \"rayleigh.$gnplt_file_extension\" >> $gnpltfile
fi
printf "set title \"Rayleigh Wave Velocities\"\n"  >> $gnpltfile

printf "plot "  >> $gnpltfile
for fac in $FACS_RADIUS
do
echo $fac $radius | awk '{
printf "%d * %f * x ti \"%dr\",\\\n",$1,$2,$1}' >> $gnpltfile
done

else # if test "$idcohcca" != "1"

if test "$gnpltprint" == "1"
then
echo set output \"rayleigh.$gnplt_file_extension\" >> $gnpltfile
fi
printf "set title \"Rayleigh Wave Velocities\"\n"  >> $gnpltfile

echo $radius | awk '{r=$1
if(r<=0.01){
printf "plot "
printf "0.013 * x ti \"WW13m(AVS10)\","
printf "0.025 * x ti \"WL25m(AVS20)\","
printf "0.04 * x ti \"WL40m(AVS30)\","
printf "0.1 * x ti \"WL100m\","}
else{
printf "plot "}
}'  >> $gnpltfile

fi  # if test "$idcohcca" != "1"

for fac in $FACS_WL
do
echo $fac         | awk '{
printf "%f * x ti \"WL%g m\",\\\n",$1,$1}' >> $gnpltfile
done

# plot reference data
if test "`echo $vel_reference_rayleigh |awk '{print $1}'`" != ""
then
ifile=1
for file in $vel_reference_rayleigh 
do
echo $file $ifile | awk '{
printf "\"%s\" w l lw 2 ti \"Ref%d\",\\\n",$1,$2}'     >> $gnpltfile
let ifile=ifile+1
done
fi

for file in $FILES_H_R
do
basename=${file##*/}
filename=${basename%.*}
title=`echo $filename | sed 's/velh_//'`
echo $file $title | awk '{
printf "\"%s\"  u 1:2:3 w errorbar ti \"%s\",\\\n",$1,$2}'     >> $gnpltfile
done

for file in $FILES_V
do
basename=${file##*/}
filename=${basename%.*}
title=`echo $filename | sed 's/vel_//'`
echo $file $title | awk '{
printf "\"%s\"  u 1:2:3 w errorbar ti \"%s\",\\\n",$1,$2}' >> $gnpltfile
done

# cmax for cca
if test "$idcohcca" == "1"
then
for f in cmax_by_nsr.d cmax_by_nsr.d.3st cmax_by_nsr.d.5st
do
if [ -f ave/$f ]
then
echo $f | awk '{printf "\"ave/%s\" w l ti \"Upper limit for CCA\",\\\n",$1}'  >> $gnpltfile
fi
done
fi

# cca and nc-cca
for file in $FILES_COHCCA
do
basename=${file##*/}
filename=${basename%.*}
title=`echo $filename | sed 's/vel_//'`

if test "$title" == "cca" -o "$title" == "nc-cca"
then
echo $file $title $radius_cca | awk '{r=$3
if(r<=0.00999)    {rc=sprintf ("%2.0fcm",r*100000+0.05)}
else if(r<=0.099) {rc=sprintf ("%2.1fm", r*1000+0.005)}
else              {rc=sprintf ("%2.0fm", r*1000+0.05)}
printf "\"%s\"  ti \"%s(R%s)\",\\\n",$1,$2,rc}' >> $gnpltfile
fi
done

# ordinary spac 
for file in $FILES_COHCCA
do
basename=${file##*/}
filename=${basename%.*}
title=`echo $filename | sed 's/vel_//'`
if test "$title" != "cca" -a "$title" != "nc-cca"
then
echo $title | grep No >& /dev/null  
if test "$?" != "0"
then
echo $file $title | awk '{
printf "\"%s\" ti \"%s\",\\\n",$1,$2}' >> $gnpltfile
fi  # test "$?" == "0"
fi  # test "$title" != "cca" -a "$title" != "nc-cca"
done

# two-staton spac 
for file in $FILES_COHCCA
do
basename=${file##*/}
filename=${basename%.*}
title=`echo $filename | sed 's/vel_//'`
if test "$title" != "cca" -a "$title" != "nc-cca"
then
echo $title | grep No >& /dev/null  
if test "$?" == "0"
then
echo $file $title | awk '{
printf "\"%s\" w l ti \"%s\",\\\n",$1,$2}' >> $gnpltfile
fi  # test "$?" == "0"
fi  # test "$title" != "cca" -a "$title" != "nc-cca"
done

printf "\"dummy\" ti \"\"\n"           >> $gnpltfile
if test "$gnpltprint" != "1"
then
printf "pause -1\n"                    >> $gnpltfile
else
printf "#pause -1\n"                   >> $gnpltfile
fi  
fi # idok


if test "$idcohcca" != "1"
then

if [ $idcmax_by_nsr -eq 1 -a -f ave/cmax_by_nsr.d ] 
then

if test "$gnpltprint" == "1"
then
echo set output \"rayleigh_cca.$gnplt_file_extension\" >> $gnpltfile
fi

printf "set title \"Rayleigh Wave Velocities by CCA\"\n"  >> $gnpltfile
printf "plot "  >> $gnpltfile

for fac in $FACS_RADIUS
do
echo $fac $radius | awk '{
printf "%d * %f * x ti \"%dr\",\\\n",$1,$2,$1}' >> $gnpltfile
done
for fac in $FACS_WL
do
echo $fac         | awk '{
printf "%f * x ti \"WL%g\",\\\n",$1,$1}' >> $gnpltfile
done

# plot reference data
if test "`echo $vel_reference_rayleigh |awk '{print $1}'`" != ""
then
ifile=1
for file in $vel_reference_rayleigh 
do
echo $file $ifile | awk '{
printf "\"%s\" w l lw 2 ti \"Ref%d\",\\\n",$1,$2}'     >> $gnpltfile
let ifile=ifile+1
done
fi

echo | awk '{printf "\"ave/cmax_by_nsr.d\" w l ti \"Upper limit for CCA (from NSR)\",\\\n"}'  >> $gnpltfile
echo | awk '{printf "\"ave/vel_nc-cca.d\" ti \"nc-cca\",\\\n"}'  >> $gnpltfile
echo | awk '{printf "\"ave/vel_spac.d\" ti \"spac\",\\\n"}'  >> $gnpltfile
echo | awk '{printf "\"ave/vel_cca.d\" ti \"cca\"\n"}'  >> $gnpltfile

fi # [ $idcmax_by_nsr -eq 1 -a -f ave/cmax_by_nsr.d ] 

if test "$gnpltprint" != "1"
then
printf "pause -1\n"                    >> $gnpltfile
else
printf "#pause -1\n"                   >> $gnpltfile
fi

fi # if test "$idcohcca" != "1"

fi   #if test "$id_miniature_array" == "1"


if [ -f ave/AmpRV_R.d ]
then
printf "set key $INSIDE top right\n"                              >> $gnpltfile
printf "set title \"Amplitude Ratio |R/V| of Rayleigh Waves\"\n"  >> $gnpltfile
printf "set autoscale y\n" >> $gnpltfile
if test "$gnpltprint" == "1"
then
echo set output \"rv.$gnplt_file_extension\" >> $gnpltfile
fi
printf "set ylabel \"Amplitude Ratio\"\nplot "  >> $gnpltfile
cat <<EOF>> $gnpltfile
"ave/AmpRV_R.d" u 1:2 w l lw 3 $LTYPE 1 ti "Average",\
"ave/AmpRV_R.d" u 1:3 w l lw 1 $LTYPE 1 ti "ST.D",\
"ave/AmpRV_R.d" u 1:4 w l lw 1 $LTYPE 1 ti ""
EOF
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
fi

if [ -f ave/AmpRV_R.d  -a -f ave/spr_hv.d ]
then
if test "$gnpltprint" == "1"
then
echo set output \"hv_and_rv.$gnplt_file_extension\" >> $gnpltfile
fi
printf "set key $INSIDE top right\n"                  >> $gnpltfile
printf "set title \"Comparison between H/V and R/V Spectra\"\n"  >> $gnpltfile
printf "set xrange [0:$xmax]\n"        >> $gnpltfile
printf "set autoscale y\nset logscale y\n"  >> $gnpltfile
printf "set ylabel \"Power Ratio\"\nplot "  >> $gnpltfile
cat <<EOF>> $gnpltfile
"ave/spr_hv.d" u 1:2 w l lw 3 $LTYPE 2 ti "H/V",\
"ave/spr_hv.d" u 1:3 w l lw 1 $LTYPE 2 ti "",\
"ave/spr_hv.d" u 1:4 w l lw 1 $LTYPE 2 ti "",\
"ave/AmpRV_R.d" u 1:(\$2**2) w l lw 3 $LTYPE 1 ti "R/V",\
"ave/AmpRV_R.d" u 1:(\$3**2) w l lw 1 $LTYPE 1 ti "",\
"ave/AmpRV_R.d" u 1:(\$4**2) w l lw 1 $LTYPE 1 ti ""
EOF
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
fi

if [ -f ave/powratio_R2L.d ]
then
if test "$gnpltprint" == "1"
then
echo set output \"power_rl.$gnplt_file_extension\" >> $gnpltfile
fi
printf "set title \"Power share of Rayleigh Waves (Rayleigh+Love=1)\"\n"  >> $gnpltfile
printf "set nologscale y\n"  >> $gnpltfile
printf "set yrange [0:1.5]\n "     >> $gnpltfile
printf "set ylabel \"Rayleigh-wave power share\"\nplot "  >> $gnpltfile
cat <<EOF>> $gnpltfile
"ave/powratio_R2L.d" u 1:2 w l lw 3 $LTYPE 1 ti "Average",\
"ave/powratio_R2L.d" u 1:3 w l lw 1 $LTYPE 1 ti "ST.D.",\
"ave/powratio_R2L.d" u 1:4 w l lw 1 $LTYPE 1 ti ""
EOF
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
fi


if test "$FILES_NSR" != ""
then

#if [ -f ave/nsr_h_typer.d ] 
if [ -f ave/nsr_h.d ] 
then
cat <<EOF>> $gnpltfile
set autoscale y
set yrange [:10]
set title "Noise-to-Signal Ratio Observed"
set xrange [0:$xmax]
set ylabel "NSR"
set logscale y
EOF

if [ -f ave/nsr.d ] 
then

#cat <<EOF>> $gnpltfile
#plot \
#"ave/nsr_h_typer.d" u 1:2  w l lw 3 $LTYPE 2 ti "Horizontal (Type R)",\
#"ave/nsr_h_typer.d" u 1:3  w l lw 1 $LTYPE 2 ti "",\
#"ave/nsr_h_typer.d" u 1:4  w l lw 1 $LTYPE 2 ti "",\
#"ave/nsr_h_typeb.d" u 1:2  w l lw 3 $LTYPE 3 ti "Horizontal (Type B)",\
#"ave/nsr_h_typeb.d" u 1:3  w l lw 1 $LTYPE 3 ti "",\
#"ave/nsr_h_typeb.d" u 1:4  w l lw 1 $LTYPE 3 ti "",\
#"ave/nsr.d" u 1:2 w l lw 3 $LTYPE 1 ti "Vertical",\
#"ave/nsr.d" u 1:3 w l lw 1 $LTYPE 1 ti "",\
#"ave/nsr.d" u 1:4 w l lw 1 $LTYPE 1 ti ""
#pause -1
#EOF

if test "$gnpltprint" == "1"
then
echo set output \"nsr.$gnplt_file_extension\" >> $gnpltfile
fi
cat <<EOF>> $gnpltfile
plot \
"ave/nsr_h.d" u 1:2  w l lw 3 $LTYPE 2 ti "Horizontal",\
"ave/nsr_h.d" u 1:3  w l lw 1 $LTYPE 2 ti "",\
"ave/nsr_h.d" u 1:4  w l lw 1 $LTYPE 2 ti "",\
"ave/nsr.d" u 1:2 w l lw 3 $LTYPE 1 ti "Vertical",\
"ave/nsr.d" u 1:3 w l lw 1 $LTYPE 1 ti "",\
"ave/nsr.d" u 1:4 w l lw 1 $LTYPE 1 ti ""
EOF
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi

else # ave/nsr.d

if test "$gnpltprint" == "1"
then
echo set output \"nsr_h.$gnplt_file_extension\" >> $gnpltfile
fi

#cat <<EOF>> $gnpltfile
#plot \
#"ave/nsr_h_typer.d" u 1:2  w l lw 3 $LTYPE 2 ti "Horizontal (Type R)",\
#"ave/nsr_h_typer.d" u 1:3  w l lw 1 $LTYPE 2 ti "",\
#"ave/nsr_h_typer.d" u 1:4  w l lw 1 $LTYPE 2 ti "",\
#"ave/nsr_h_typeb.d" u 1:2  w l lw 3 $LTYPE 3 ti "Horizontal (Type B)",\
#"ave/nsr_h_typeb.d" u 1:3  w l lw 1 $LTYPE 3 ti "",\
#"ave/nsr_h_typeb.d" u 1:4  w l lw 1 $LTYPE 3 ti ""
#pause -1
#EOF

cat <<EOF>> $gnpltfile
plot \
"ave/nsr_h.d" u 1:2  w l lw 3 $LTYPE 2 ti "Horizontal (Type R)",\
"ave/nsr_h.d" u 1:3  w l lw 1 $LTYPE 2 ti "",\
"ave/nsr_h.d" u 1:4  w l lw 1 $LTYPE 2 ti ""
EOF
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi

fi # ave/nsr.d

fi # ave/nsr_h.d

if [ -f ave/nsr.d ] 
then
if test "$gnpltprint" == "1"
then
echo set output \"nsr_limit.$gnplt_file_extension\" >> $gnpltfile
fi

cat <<EOF>> $gnpltfile
set title "Noise-to-Signal Ratio (for the vertical component only)"
set ylabel "NSR"
set autoscale y
set logscale y
plot \
"ave/nsr.d" u 1:2 w l lw 3 $LTYPE 1 ti "Observed",\
"ave/nsr.d" u 1:3 w l lw 1 $LTYPE 1 ti "",\
"ave/nsr.d" u 1:4 w l lw 1 $LTYPE 1 ti "",\
"ave/nsrlim_cca.d"        w l lw 2 ti "Upper limit (from PhsVel by CCA)",\
"ave/nsrlim_cca.lwapx.d"  w l lw 2 ti "Upper limit (from PhsVel by nc-CCA)"
EOF
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
fi # ave/nsr.d

fi # test "$FILES_NSR"


if [ -f ave/spr_hv.d ]
then
printf "set key $INSIDE top right\n"                             >> $gnpltfile
printf "set title \"Power Share of Horizontal-to-Vertical Components (Horizontal Power = EW + NS; bar: Standard Error)\"\n"  >> $gnpltfile

if test "$autologscale_x" == "1"
then
printf "set xrange [$xmin:$xmax_full]\n"        >> $gnpltfile
printf "set logscale x\n"        >> $gnpltfile
fi

if test "$gnpltprint" == "1"
then
echo set output \"hv.$gnplt_file_extension\" >> $gnpltfile
fi

printf "set autoscale y\nset logscale y\n"  >> $gnpltfile
printf "set ylabel \"Power Ratio\"\nplot "  >> $gnpltfile
cat <<EOF>> $gnpltfile
"ave/spr_hv.d"  u 1:2:(\$3/sqrt(\$4)) w errorbar lw 1 lc 1 ti ""
EOF
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
fi # ave/spr_hv.d

if [ $idpsd -eq 1 ]
then

cat <<EOF>> $gnpltfile
set key $INSIDE top left
set autoscale y
set logscale y
set ylabel "Amplitude[(Amplitude Unit of the Waveform)**2*s]"
EOF

if test "$autologscale_x" == "1"
then
cat <<EOF>> $gnpltfile
set logscale x
set xrange [$xmin:$xmax_full]
EOF
fi

for comp in $COMPS
do
n=1

if test "$gnpltprint" == "1"
then
echo set output \"psd_$comp.$gnplt_file_extension\" >> $gnpltfile
fi

cat<<EOF>> $gnpltfile
set title "Power Spectral Density (bar: Standard Error) [$comp]"
set format y "10^{%L}" 
EOF

printf "plot " >> $gnpltfile

# plot reference data
if test "$comp" == "u"
then

if test "`echo $psd_reference_u |awk '{print $1}'`" != ""
then
ifile=1
for file in $psd_reference_u
do
echo $file $ifile | awk '{
printf "\"%s\" w l lw 2 ti \"Ref%d\",\\\n",$1,$2}'     >> $gnpltfile
let ifile=ifile+1
done
fi

elif test "$comp" == "n"
then

if test "`echo $psd_reference_n |awk '{print $1}'`" != ""
then
ifile=1
for file in $psd_reference_n
do
echo $file $ifile | awk '{
printf "\"%s\" w l lw 2 ti \"Ref%d\",\\\n",$1,$2}'     >> $gnpltfile
let ifile=ifile+1
done
fi

elif test "$comp" == "e"
then

if test "`echo $psd_reference_e |awk '{print $1}'`" != ""
then
ifile=1
for file in $psd_reference_e
do
echo $file $ifile | awk '{
printf "\"%s\" w l lw 2 ti \"Ref%d\",\\\n",$1,$2}'     >> $gnpltfile
let ifile=ifile+1
done
fi

fi

while [ $n -le $nseis_total ] 
do

file=ave/SD$n"$comp"_SD$n"$comp".d
if [ -f $file ]
then
echo $n | awk '{
printf "\"ave/SD%d%s_SD%d%s.d\" u 1:2:($3/sqrt($4)) w errorbar lw 1 %s %d ti \"No%d; %s\",\\\n",$1,"'"$comp"'",$1,"'"$comp"'","'"$LTYPE"'",$1,$1,"'"${codechar[$n]}"'"}' >> $gnpltfile
fi  # file
let n=n+1
done # n

if [ $idhuddle -ne 1 ]
then

#if test "$id_miniature_array" == "1"
#then
if [ -f ave/pow_noise.d ]
then
echo $n | awk '{
printf "\"ave/pow_noise.d\" u 1:2:($3/sqrt($4)) w errorbar lw 1 %s %d ti \"Incoherent Nise\",\\\n","'"$LTYPE"'",$1}' >> $gnpltfile
fi
#fi
fi

printf "\"dummy\" ti \"\"\n"           >> $gnpltfile
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else # $idpsd
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
done # comp

if [ -f ave/nsr_cca.lwapx.d ]
then
cat <<EOF>> $gnpltfile
set yrange [:]
set ylabel "NSR"
set title "Noise-to-Signal Ratio by long-wavelength approximation (bar: Standard Error) [u]"
plot \
"ave/nsr_cca.lwapx.d"  u 1:2:(\$3/sqrt(\$4)) w errorbar lw 1 lc 1 ti ""
EOF
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else # $idpsd
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
fi # if [ -f ave/nsr_cca.lwapx.d ]

fi  # idpsd

printf "set format y\n" >> $gnpltfile

if [ $nseis_total -gt 1 ]
then
if [ $idpsd -eq 1 ]
then

# Power Spectral Ratio
cat <<EOF>> $gnpltfile
set key $INSIDE top left
set nologscale y
set yrange [0.5:2]
set ylabel "Power Spectral Ratio"
EOF

for comp in $COMPS
do
i=1

if test "$gnpltprint" == "1"
then
echo set output \"psdratio_$comp.$gnplt_file_extension\" >> $gnpltfile
fi

printf "set title \"PSD Ratio to a Reference Staton (No1) [$comp]\"\nplot 1 ti \"\"," >> $gnpltfile
while [ $i -le $nseis_total ]
do
j=1
while [ $j -le $nseis_total ]
do
if [ $i -eq 1 -a $j -gt $i ]
then
file=ave/PSDRATIO"$i"_"$j"$comp.d
if [ -f $file ]
then
echo $i $j | awk '{
printf "\"ave/PSDRATIO%d_%d%s.d\" u 1:2 w l lw 3 %s %d ti \"Average(No%d.vs.%d; %s.vs.%s)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2,
"'"${codechar[$i]}"'","'"${codechar[$j]}"'"}'  >> $gnpltfile
echo $i $j | awk '{printf "\"< cat ave/PSDRATIO%d_%d%s.d | awk '\''{if($3!=999){print $0}}'\''\" u 1:($2+$3) w l lw 1 %s %d ti \"ST.D(No%d.vs.%d; %s.vs.%s)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2,"'"${codechar[$i]}"'","'"${codechar[$j]}"'"}'  >> $gnpltfile
echo $i $j | awk '{printf "\"< cat ave/PSDRATIO%d_%d%s.d | awk '\''{if($3!=999){print $0}}'\''\" u 1:($2-$3) w l lw 1 %s %d ti \"\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2}'  >> $gnpltfile
fi
fi
let j=j+1
done # j
let i=i+1
done # i
printf "\"dummy\" ti \"\"\n"           >> $gnpltfile

if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi

done # comp

fi # idpsd
fi # if [ $nseis_total -gt 1 ]


if [ $idhuddle -eq 1 ]
then

# MSQ coherence
cat <<EOF>> $gnpltfile
set key $INSIDE top left
set nologscale y
set yrange [0:1]
set ylabel "Coherence value"
EOF

for comp in $COMPS
do
i=1

if test "$gnpltprint" == "1"
then
echo set output \"msc_$comp.$gnplt_file_extension\" >> $gnpltfile
fi

printf "set title \"Magnitude Squared Coherence [$comp]\"\nplot " >> $gnpltfile
while [ $i -le $nseis_total ]
do
j=1
while [ $j -le $nseis_total ]
do
if [ $i -eq 1 -a $j -gt $i ]
then
file=ave/MSQcoh"$i"_"$j"$comp.d
if [ -f $file ]
then
echo $i $j | awk '{printf "\"ave/MSQcoh%d_%d%s.d\" u 1:2 w l lw 3 %s %d ti \"Average(No%d.vs.%d; %s.vs.%s)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2,
"'"${codechar[$i]}"'","'"${codechar[$j]}"'"}'  >> $gnpltfile
echo $i $j | awk '{printf "\"< cat ave/MSQcoh%d_%d%s.d | awk '\''{if($3!=999){print $0}}'\''\" u 1:($2+$3) w l lw 1 %s %d ti \"ST.D(No%d.vs.%d; %s.vs.%s)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2,"'"${codechar[$i]}"'","'"${codechar[$j]}"'"}'  >> $gnpltfile
echo $i $j | awk '{printf "\"< cat ave/MSQcoh%d_%d%s.d | awk '\''{if($3!=999){print $0}}'\''\" u 1:($2-$3) w l lw 1 %s %d ti \"\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2}'  >> $gnpltfile
fi
fi
let j=j+1
done
let i=i+1
done # j
printf "\"dummy\" ti \"\"\n"           >> $gnpltfile
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
done # i


# Phase difference
cat <<EOF>> $gnpltfile
set key $INSIDE top left
set nologscale y
set yrange [-90:90]
set ylabel "Angle[deg]"
EOF

for comp in $COMPS
do
i=1
if test "$gnpltprint" == "1"
then
echo set output \"phase_$comp.$gnplt_file_extension\" >> $gnpltfile
fi

printf "set title \"Phase Difference [$comp]\"\nplot 0 ti \"\"," >> $gnpltfile
while [ $i -le $nseis_total ]
do
j=1
while [ $j -le $nseis_total ]
do
if [ $i -eq 1 -a $j -gt $i ]
then
file=ave/PHASE"$i"_"$j"$comp.d
if [ -f $file ]
then
echo $i $j | awk '{printf "\"ave/PHASE%d_%d%s.d\" u 1:2 w l lw 3 %s %d ti \"Average(No%d.vs.%d; %s.vs.%s)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2,"'"${codechar[$i]}"'","'"${codechar[$j]}"'"}'  >> $gnpltfile
fi
fi
let j=j+1
done  # j
let i=i+1
done  # i
printf "\"dummy\" ti \"\"\n"           >> $gnpltfile
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
done  # comp

if test "$id_miniature_array" != "1"
then

# NSR
cat <<EOF>> $gnpltfile
set key $INSIDE bottom left
set autoscale y
set logscale y
set ylabel "Noise-to-signal ratio"
EOF

for comp in $COMPS
do
i=1

if test "$gnpltprint" == "1"
then
echo set output \"nsr_$comp.$gnplt_file_extension\" >> $gnpltfile
fi

printf "set title \"Noise-to-Signal Ratio [$comp]\"\nplot " >> $gnpltfile
while [ $i -le $nseis_total ]
do
j=1
while [ $j -le $nseis_total ]
do
if [ $i -eq 1 -a $j -gt $i ]
then
file=ave/NSR"$i"_"$j"$comp.d
if [ -f $file ]
then
echo $i $j | awk '{printf "\"ave/NSR%d_%d%s.d\" u 1:2 w l lw 3 %s %d ti \"Average(by No%d&%d; %s&%s)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2,
"'"${codechar[$i]}"'","'"${codechar[$j]}"'"}'  >> $gnpltfile
echo $i $j | awk '{printf "\"ave/NSR%d_%d%s.d\" u 1:($2+$3) w l lw 1 %s %d ti \"ST.D(by No%d&%d; %s&%s)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2,
"'"${codechar[$i]}"'","'"${codechar[$j]}"'"}'  >> $gnpltfile
echo $i $j | awk '{printf "\"ave/NSR%d_%d%s.d\" u 1:($2-$3) w l lw 1 %s %d ti \"\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2}'  >> $gnpltfile
fi
fi
let j=j+1
done
let i=i+1
done
printf "\"dummy\" ti \"\"\n"           >> $gnpltfile
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
done

# PSD of Noise
cat <<EOF>> $gnpltfile
set key $INSIDE  bottom left
set autoscale y
set logscale y
set ylabel "Amplitude[(Amplitude Unit of the Waveform)**2*s]"
EOF

for comp in $COMPS
do
i=1

if test "$gnpltprint" == "1"
then
echo set output \"psd_noise_$comp.$gnplt_file_extension\" >> $gnpltfile
fi

printf "set title \"Power Spectral Density of Incoherent Noise [$comp]\"\nplot " >> $gnpltfile
while [ $i -le $nseis_total ]
do
j=1
while [ $j -le $nseis_total ]
do
if [ $i -eq 1 -a $j -gt $i ]
then
file=ave/PSD_NOISE"$i"_"$j"$comp.d
if [ -f $file ]
then
echo $i $j | awk '{printf "\"ave/PSD_NOISE%d_%d%s.d\" u 1:2 w l lw 3 %s %d ti \"Average(by No%d&%d; %s&%s)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2,"'"${codechar[$i]}"'","'"${codechar[$j]}"'"}'  >> $gnpltfile
echo $i $j | awk '{printf "\"ave/PSD_NOISE%d_%d%s.d\" u 1:($2+$3) w l lw 1 %s %d ti \"ST.D(by No%d&%d; %s&%s)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2,"'"${codechar[$i]}"'","'"${codechar[$j]}"'"}'  >> $gnpltfile
echo $i $j | awk '{printf "\"ave/PSD_NOISE%d_%d%s.d\" u 1:($2-$3) w l lw 1 %s %d ti \"\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2}'  >> $gnpltfile
fi
fi
let j=j+1
done
let i=i+1
done
printf "\"dummy\" ti \"\"\n"           >> $gnpltfile
if test "$gnpltprint" != "1"
then
cat <<EOF>> $gnpltfile
pause -1
EOF
else
cat <<EOF>> $gnpltfile
#pause -1
EOF
fi
done

## PSD of Signal
#cat <<EOF>> $gnpltfile
#set key $INSIDE top right
#set autoscale y
#set logscale y
#set ylabel "Amplitude[(Amplitude Unit of the Waveform)**2*s]"
#EOF
#
#for comp in $COMPS
#do
#i=1
#printf "set title \"Power Spectral Density of Coherent Signal [$comp]\"\nplot " >> $gnpltfile
#while [ $i -le $nseis_total ]
#do
#j=1
#while [ $j -le $nseis_total ]
#do
#if [ $i -eq 1 -a $j -gt $i ]
#then
#file=ave/PSD_NOISE"$i"_"$j"$comp.d
#if [ -f $file ]
#then
#echo $i $j | awk '{printf "\"ave/PSD_SIGNAL%d_%d%s.d\" u 1:2 w l lw 3 %s %d ti \"Average(by No%d&No%d)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2}'  >> $gnpltfile
#echo $i $j | awk '{printf "\"ave/PSD_SIGNAL%d_%d%s.d\" u 1:($2+$3) w l lw 1 %s %d ti \"ST.D(by No%d&No%d)\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2}'  >> $gnpltfile
#echo $i $j | awk '{printf "\"ave/PSD_SIGNAL%d_%d%s.d\" u 1:($2-$3) w l lw 1 %s %d ti \"\",\\\n",$1,$2,"'"$comp"'","'"$LTYPE"'",$2,$1,$2}'  >> $gnpltfile
#fi
#fi
#let j=j+1
#done
#let i=i+1
#done
#printf "\"dummy\" ti \"\"\n"           >> $gnpltfile
#printf "pause -1\n"                    >> $gnpltfile
#done

fi # test "$id_miniature_array" == "1"

fi # huddle

$GNUPLOT $gnpltfile

cd -

