#!/bin/bash
# Shell script for Packege BIDO
# (C) 2025 AIST All Rights Reserved.

seislogfile_cohcca=../1/seism_cohcca.log
inputfile=infile.esac
outfile=vel_esac.d
outfile_spr=spr_esac.d
outfile_rad=seism_esac.log
outfile_a=vel_aesac.d

#freq_max=100.
freq_max=50.
#freq_max=5.

#######################################################################
# Don't touch from here
#######################################################################
echo "<ESAC COH --> VEL>"

executedir=$outputdir2

cd $executedir
echo $executedir

SPRSPACFILES=`ls spr_spac_R*1p_No*.d`

ifile=0
for file in $SPRSPACFILES
do
let ifile=ifile+1
done

if [ -f $inputfile ]
then
    rm -f $inputfile 
fi
touch -f $inputfile 
cat <<EOF >> $inputfile
$freq_max
999.
$ifile
EOF


for file in $SPRSPACFILES
do
fileid=`echo $file | sed s/spr_spac//|sed 's/\.d//'`
r=`cat $seislogfile_cohcca | awk 'BEGIN{fileid="'"$fileid"'"
}{if(fileid==$9){print $2}}'`

cat <<EOF >> $inputfile
$file
$r
EOF
done

echo $outfile   >> $inputfile
echo $outfile_a >> $inputfile

echo processing esac...
cat $inputfile | $bindir/sctr2pv_esac
cat $outfile  | awk '{print $1,$3}'   > $outfile_spr
cat $outfile  | awk '{printf "%10.7f\n", $4}' | sort | uniq   > $outfile_rad

echo processing ncspac...
cat $inputfile | $bindir/sctr2pv_ncspac

echo done.

cd -
